#ifndef BRTWINDOW_H
#define BETWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class BetWindow;
}

class BetWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit BetWindow(QWidget *parent = 0, Player* player=0);
    ~BetWindow();

    int GetRounds() { return m_Round; }

    void exec();

protected:
    void closeEvent(QCloseEvent *event);

private:
    Ui::BetWindow *ui;

    bool m_CanClose;
    int m_Bet;
    int m_Value;
    int m_Won;
    Player* m_Player;
    QEventLoop* m_Loop;

    int m_Round;
    int m_Number;
    RandomNumberPicker* m_RandomPicker;

    void EnableButtons(bool enable);
    void UpdateData();
    void Evaluate();

private slots:
    void RandomSlot(int);
    void BetMinusSlot();
    void BetPlusSlot();
    void PlaySlot();

};

#endif // BETWINDOW_H
