#include "selectgoldcrownswindow.h"
#include "ui_selectgoldcrownswindow.h"

SelectGoldCrownsWindow::SelectGoldCrownsWindow(QWidget *parent, Player* player, int min) :
    QDialog(parent),
    ui(new Ui::SelectGoldCrownsWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    m_Player = player;
    m_MinValue = min;
    m_Value = m_MinValue;
    ui->lblValue->setText(QString::number(m_Value));

    connect(ui->pbnMinus, SIGNAL(clicked()), this, SLOT(MinusSlot()));
    connect(ui->pbnPlus, SIGNAL(clicked()), this, SLOT(PlusSlot()));
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(OkSlot()));
}

SelectGoldCrownsWindow::~SelectGoldCrownsWindow()
{
    delete ui;
}

void SelectGoldCrownsWindow::MinusSlot()
{
    if (m_Value > m_MinValue){
        m_Value--;
        ui->lblValue->setText(QString::number(m_Value));
    }
}

void SelectGoldCrownsWindow::PlusSlot()
{
    if (m_Value < m_Player->GoldCrowns){
        m_Value++;
        ui->lblValue->setText(QString::number(m_Value));
    }
}

void SelectGoldCrownsWindow::OkSlot()
{
    accept();
}

int SelectGoldCrownsWindow::GetSelectedValue()
{
    return m_Value;
}
