#include "ruleswindow.h"
#include "ui_ruleswindow.h"
#ifdef Q_WS_MAEMO_5
#include "qwebviewselectionsuppressor.h"
#include <QAbstractKineticScroller>
#endif
#include <QFile>
#include "commonstatic.h"
#include <QDebug>
#include <QWebFrame>

RulesWindow::RulesWindow(QWidget *parent, QString bookDirectory) :
    QMainWindow(parent),
    ui(new Ui::RulesWindow)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_OS_SYMBIAN
    QAction* backSoftKey = new QAction( tr("Back"), this );
    backSoftKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(backSoftKey, SIGNAL(triggered()), this, SLOT(accept()));
    addAction(backSoftKey);
#endif

    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QWebViewSelectionSuppressor* suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
    ui->webView->property("kineticScroller").value<QAbstractKineticScroller *>()->setEnabled(true);
#endif

    ui->webView->setContextMenuPolicy(Qt::NoContextMenu);
    m_BookDirectory = bookDirectory;
    /*QUrl baseUrl = QUrl::fromLocalFile(QString("%1/Data/dummy.htm").arg(bookDirectory));
    QFile input(QString("%1/rules.htm").arg(bookDirectory));
    if (input.open(QIODevice::ReadOnly)){
#ifdef Q_WS_MAEMO_5
        QString css = "main_n900.css";
#else
        QString css = "main.css";
#endif
        QString html = QString("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \
                        <html xmlns=\"http://www.w3.org/1999/xhtml\"> \
                        <head> \
                        <link type=\"text/css\" href=\"%1\" rel=\"stylesheet\" /> \
                        </head>").arg(css);
        html.append(QString::fromUtf8(input.readAll()));
        html.append("</html>");

        ui->webView->setHtml(html, baseUrl);
    }*/
}

RulesWindow::~RulesWindow()
{
    delete ui;
}

void RulesWindow::ScrollToAnchor(QString anchor)
{
    ui->webView->page()->mainFrame()->evaluateJavaScript(QString("window.location.hash=\"%1\";").arg(anchor));
}

void RulesWindow::show()
{
    QMainWindow::show();

    QUrl baseUrl = QUrl::fromLocalFile(QString("%1/Data/dummy.htm").arg(m_BookDirectory));
    QFile input(QString("%1/rules.htm").arg(m_BookDirectory));
    if (input.open(QIODevice::ReadOnly)){
#ifdef Q_WS_MAEMO_5
        QString css = "main_n900.css";
#else
        QString css = "main.css";
#endif
        QString html = QString("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \
                        <html xmlns=\"http://www.w3.org/1999/xhtml\"> \
                        <head> \
                        <link type=\"text/css\" href=\"%1\" rel=\"stylesheet\" /> \
                        </head>").arg(css);
        html.append(QString::fromUtf8(input.readAll()));
        html.append("</html>");

        ui->webView->setHtml(html, baseUrl);
    }
}
