#include "player.h"
#include <QDebug>

Player::Player(QObject *parent) :
    QObject(parent)
{
    TemporaryCombatSkillDelta = 0;
    BaseCombatSkill = 0;
    BaseEndurance = 0;
    Endurance = 0;
    GoldCrowns = 0;
    KaiDisciplines.clear();

    m_Backpack = true;
    m_CanHunt = true;

    DeathsCount = 0;
}

Player::Player(const Player& player) :
        QObject(player.parent())
{
    TemporaryCombatSkillDelta = player.TemporaryCombatSkillDelta;
    BaseCombatSkill = player.BaseCombatSkill;
    BaseEndurance = player.BaseEndurance;
    Endurance = player.Endurance;
    GoldCrowns = player.GoldCrowns;

    m_Backpack = player.m_Backpack;
    m_CanHunt = player.m_CanHunt;

    DeathsCount = player.DeathsCount;
    Properties = QHash<QString, QString>(player.Properties);
}

QList<Weapon*> Player::Weapons()
{
    QList<Weapon*> res;
    foreach (Item* i, Items){
        if (i->GetIsWeapon() && !i->GetIsSpecial())
            res.append((Weapon*)i);
    }
    return res;
}

QList<Item*> Player::BackpackItems()
{
    QList<Item*> res;
    foreach (Item* i, Items){
        if (!i->GetIsWeapon() && !i->GetIsSpecial())
            res.append(i);
    }
    return res;
}

QList<Item*> Player::SpecialItems()
{
    QList<Item*> res;
    foreach (Item* i, Items){
        if (i->GetIsSpecial())
            res.append(i);
    }
    return res;
}

QString Player::GetRankDescription(int kaiDisciplinesCount)
{
    switch (kaiDisciplinesCount)
    {
    case 1:
        return "Novice";
        break;
    case 2:
        return "Intuite";
        break;
    case 3:
        return "Doan";
        break;
    case 4:
        return "Acolyte";
        break;
    case 5:
        return "Initiate";
        break;
    case 6:
        return "Aspirant";
        break;
    case 7:
        return "Guardian";
        break;
    case 8:
        return "Warmarn";
        break;
    case 9:
        return "Savant";
        break;
    case 10:
        return "Master";
        break;
    default:
        return "";
        break;
    }
}

int Player::MealsCount()
{
    int result = 0;
    foreach (Item* i, Items){
        if (i->GetIsMeal())
            result += 1;
    }
    return result;
}

bool Player::IsDead()
{
    return Endurance <= 0;
}

int Player::GetCombatSkill()
{
    int result = BaseCombatSkill + TemporaryCombatSkillDelta;
    foreach (Item* i, Items){
        if (i->GetIsEquipped())
            result += i->GetCombatskillDelta();
    }

    foreach (KaiDiscipline* d, KaiDisciplines){
        result += d->CombatSkillDelta;

        Weaponskill* ws = qobject_cast<Weaponskill*>(d);
        if (ws){
            foreach(Item* i, Items){
                if (i->GetIsWeapon()){
                    Weapon* w = (Weapon*)i;
                    if (w->GetIsEquipped() && w->Classes().contains(ws->Weapon)){
                        result += 2;
                        break;
                    }
                }
            }
        }
    }

    if (Weapons().count() == 0)
        result -= 4;

    return result;
}

int Player::GetBaseEndurance()
{
    int result = BaseEndurance;
    foreach (Item* i, Items){
        if (i->GetIsEquipped())
            result += i->GetEnduranceDelta();
    }

    return result;
}

int Player::GetCombatSkill(Enemy* enemy)
{
    int result = BaseCombatSkill + TemporaryCombatSkillDelta;
    foreach (Item* i, Items){
        if (i->GetIsEquipped())
            result += i->GetCombatskillDelta();
    }

    foreach (KaiDiscipline* d, KaiDisciplines){
        if (!enemy->DisciplineImmunities.contains(d->Name))
            result += d->CombatSkillDelta;

        Weaponskill* ws = qobject_cast<Weaponskill*>(d);
        if (ws){
            foreach(Item* i, Items){
                if (i->GetIsWeapon()){
                    Weapon* w = (Weapon*)i;
                    if (w->GetIsEquipped() && w->Classes().contains(ws->Weapon)){
                        result += 2;
                        break;
                    }
                }
            }
        }
    }

    if (GetEquippedWeapon() == NULL)
        result -= 4;

    return result;
}

void Player::RemoveDiscipline(QString name)
{
    KaiDiscipline* remove = NULL;
    foreach (KaiDiscipline* d, KaiDisciplines){
        if (QString::compare(d->Name, name, Qt::CaseInsensitive) == 0){
            remove = d;
        }
    }

    if (remove)
        KaiDisciplines.removeOne(remove);
}

int Player::GetDisciplineCount()
{
    return KaiDisciplines.count();
}

bool Player::HasDiscipline(QString name)
{
    foreach (KaiDiscipline* d, KaiDisciplines){
        if (QString::compare(d->Name, name, Qt::CaseInsensitive) == 0)
            return true;
    }
    return false;
}

bool Player::HasWeaponskillIn(QString className)
{
    foreach (KaiDiscipline* d, KaiDisciplines){
        if (QString::compare(d->Name, "Weaponskill", Qt::CaseInsensitive) == 0){
            Weaponskill* ws = qobject_cast<Weaponskill*>(d);
            if (ws)
                return ws->Weapon == Weapon::GetClass(className);

        }
    }
    return false;
}

bool Player::HasWeaponskillBonus()
{
    foreach (KaiDiscipline* d, KaiDisciplines){
        if (QString::compare(d->Name, "Weaponskill", Qt::CaseInsensitive) == 0){
            Weaponskill* ws = qobject_cast<Weaponskill*>(d);
            foreach(Item* i, Items){
                if (i->GetIsWeapon()){
                    Weapon* w = (Weapon*)i;
                    if (w->GetIsEquipped() && w->Classes().contains(ws->Weapon)){
                        return true;
                    }
                }
            }
            break;
        }
    }
    return false;
}

int Player::GetEndurance()
{
    return Endurance;
}

void Player::SetEndurance(int endurance)
{
    if (endurance < 0)
        endurance = 0;

    if (endurance <= GetBaseEndurance())
        Endurance = endurance;
    else
        Endurance = GetBaseEndurance();
}

void Player::CheckEndurance()
{
    if (Endurance > GetBaseEndurance())
        Endurance = GetBaseEndurance();
    else if (Endurance < 0)
        Endurance = 0;
}

int Player::GetBaseCombatSkill()
{
    return BaseCombatSkill;
}

void Player::SetBaseCombatSkill(int baseCombatSkill)
{
    BaseCombatSkill = baseCombatSkill;
}

void Player::SetTempCombatSkillDelta(int tempCombastSkill)
{
    TemporaryCombatSkillDelta = tempCombastSkill;
}

int Player::GetGoldCrowns()
{
    return GoldCrowns;
}

void Player::SetGoldCrowns(int crowns)
{
    if (crowns >= 0){
        if (crowns > 50)
            crowns = 50;
        GoldCrowns = crowns;
    }else
        GoldCrowns = 0;
}

bool Player::HasItem(QString name)
{
    foreach(Item* i, Items){
        if (QString::compare(i->Name, name, Qt::CaseInsensitive) == 0)
            return true;
    }
    return false;
}

bool Player::HasSpecialItem(QString name)
{
    foreach(Item* i, Items){
        if (QString::compare(i->Name, name, Qt::CaseInsensitive) == 0 && i->GetIsSpecial())
            return true;
    }
    return false;
}

Item* Player::AddItem(QString name, bool special)
{
    if (!name.isEmpty() && (HasBackpack() || special)){
        Item* i = new Item(this);
        i->Name = name;
        i->SetIsSpecial(special);
        Items.append(i);
        return i;
    }
    return NULL;
}

Item* Player::AddMeal(QString name)
{
    if (!name.isEmpty() && HasBackpack()){
        Item* i = new Item(this);
        i->Name = name;
        i->SetIsMeal(true);
        Items.append(i);
        return i;
    }
    return NULL;
}

Item* Player::AddHealingItem(QString name, int enduranceRestore)
{
    if (!name.isEmpty() && enduranceRestore > 0 && HasBackpack()){
        Item* i = new Item(this);
        i->Name = name;
        i->SetEnduranceRestore(enduranceRestore);
        i->Description = QString("Restores %1 ENDURANCE POINTS").arg(enduranceRestore);
        Items.append(i);
        return i;
    }
    return NULL;
}

bool Player::RemoveItem(QString name)
{
    if (!name.isEmpty()){
        Item* found = NULL;
        foreach(Item* i, Items){
            if (QString::compare(i->Name, name) == 0){
                found = i;
                break;
            }
        }
        if (found){
            Items.removeOne(found);
            return true;
        }
    }
    return false;
}

QStringList Player::GetHiddenItems()
{
    QStringList res;
    foreach (Item* i, HiddenItems)
        res.append(i->Name);
    return res;
}

bool Player::HideItem(QString name)
{
    if (!name.isEmpty()){
        Item* found = NULL;
        foreach(Item* i, Items){
            if (QString::compare(i->Name, name) == 0){
                found = i;
                break;
            }
        }
        if (found){
            found->Unequip();
            Items.removeOne(found);
            HiddenItems.append(found);
            return true;
        }
    }
    return false;
}

bool Player::RestoreHiddenItem(QString name)
{
    if (!name.isEmpty()){
        Item* found = NULL;
        foreach(Item* i, HiddenItems){
            if (QString::compare(i->Name, name) == 0){
                found = i;
                break;
            }
        }
        if (found){
            HiddenItems.removeOne(found);
            Items.append(found);
            return true;
        }
    }
    return false;
}

Item* Player::GetItem(QString name)
{
    if (!name.isEmpty()){
        foreach(Item* i, Items){
            if (QString::compare(i->Name, name) == 0)
                return i;
        }
    }
    return NULL;
}

int Player::SpecialItemsCount()
{
    int res = 0;
    foreach(Item* i, Items){
        if (i->GetIsSpecial())
            res++;
    }
    return res;
}

int Player::ItemsCount()
{
    return GetItems().count();
}

void Player::SetHasBackpack(bool value)
{
    m_Backpack = value;
    if (!m_Backpack){
        QList<Item*> toRemove;
        foreach (Item* i, Items){
            if (!i->GetIsSpecial())
                toRemove.append(i);
        }

        foreach (Item* i, toRemove){
            Items.removeOne(i);
            delete i;
        }
    }
}

bool Player::IsBackpackFull()
{
    int size = 0;
    foreach(Item* i, Items){
        if (!i->GetIsSpecial())
            size += i->GetSize();
    }

    return size >= 8;
}

int Player::GetBackpackFreeSpace()
{
    if (!HasBackpack())
        return 0;

    int size = 0;
    foreach(Item* i, Items){
        if (!i->GetIsSpecial())
            size += i->GetSize();
    }
    return 8 - size;
}

int Player::WeaponsCount()
{
    return Weapons().count();
}

QStringList Player::GetWeapons()
{
    QStringList res;
    foreach (Weapon* w, Weapons()){
        res.append(w->Name);
    }
    return res;
}

Weapon* Player::GetEquippedWeapon()
{
    foreach (Item* i, Items){
        if (i->GetIsWeapon() && i->GetIsEquipped())
            return (Weapon*)i;
    }
    return NULL;
}

QStringList Player::GetSpecialItems()
{
    QStringList res;
    foreach (Item* i, Items){
        if (i->GetIsSpecial())
            res.append(i->Name);
    }
    return res;
}

QStringList Player::GetItems()
{
    QStringList res;
    foreach (Item* i, Items){
        if (!i->GetIsSpecial() && !i->GetIsWeapon())
            res.append(i->Name);
    }
    return res;
}

bool Player::HasWeapon(QString name)
{
    foreach(Weapon* w, Weapons()){
        if (QString::compare(w->Name, name, Qt::CaseInsensitive) == 0)
            return true;
    }
    return false;
}

Weapon* Player::GetWeapon(QString name)
{
    foreach(Weapon* w, Weapons()){
        if (QString::compare(w->Name, name, Qt::CaseInsensitive) == 0)
            return w;
    }
    return NULL;
}

bool Player::IsEquipped(QString name)
{
    foreach(Item* w, Items){
        if (QString::compare(w->Name, name, Qt::CaseInsensitive) == 0 && w->GetIsEquipped())
            return true;
    }

    return false;
}

void Player::Equip(QString name)
{
    foreach(Item* w, Items){
        if ((w->GetIsWeapon() || w->GetIsArmor()) && QString::compare(w->Name, name, Qt::CaseInsensitive) == 0)
            w->Equip();
    }
}

int Player::GetFreeHands()
{
    int res = 2;
    foreach(Item* i, Items){
        if (i->GetIsEquipped())
            res -= i->GetHands();
    }
    return res;
}

Weapon* Player::AddWeapon(QString name, QString classname)
{
    if (!name.isEmpty() && !classname.isEmpty() && WeaponsCount() < 2){
        Weapon* w = new Weapon(this);
        w->Name = name;
        w->AddClass(Weapon::GetClass(classname));
        Items.append(w);
        return w;
    }
    return NULL;
}

Weapon* Player::AddSpecialWeapon(QString name, QString classname)
{
    if (!name.isEmpty() && !classname.isEmpty()){
        Weapon* w = new Weapon(this);
        w->Name = name;
        w->AddClass(Weapon::GetClass(classname));
        w->SetIsSpecial(true);
        Items.append(w);
        return w;
    }
    return NULL;
}

void Player::RemoveWeapon(QString name)
{
    if (!name.isEmpty()){
        Weapon* found = NULL;
        foreach(Weapon* w, Weapons()){
            if (QString::compare(w->Name, name) == 0){
                found = w;
                break;
            }
        }
        if (found)
            Items.removeOne(found);
    }
}

QString Player::GetProperty(QString name)
{
    if (Properties.contains(name))
        return Properties[name];
    return "";
}

void Player::SetProperty(QString name, QString value)
{
    Properties[name] = value;
}

void Player::RemoveProperty(QString name)
{
    if (Properties.contains(name))
        Properties.remove(name);
}

void Player::ClearProperties()
{
    Properties.clear();
}

void Player::Dump()
{
    qDebug() << "Properties:";
    foreach(QString key, Properties.keys()){
        qDebug() << key << ":" << Properties[key];
    }
}
