#include "mapwindow.h"
#include "ui_mapwindow.h"
#ifdef Q_WS_MAEMO_5
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#endif
#include <QKeyEvent>
#include <QScrollBar>
#include "commonstatic.h"

MapWindow::MapWindow(QWidget *parent, QString filename) :
    QMainWindow(parent),
    ui(new Ui::MapWindow)
{
    ui->setupUi(this);
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif

#ifdef Q_OS_SYMBIAN
    QAction* backSoftKey = new QAction( tr("Back"), this );
    backSoftKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(backSoftKey, SIGNAL(triggered()), this, SLOT(accept()));
    addAction(backSoftKey);
#endif

    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    ui->sliZoom->setValue(100);
    connect(ui->sliZoom, SIGNAL(valueChanged(int)), this, SLOT(ZoomChangedSlot(int)));

    QPixmap map(filename);
    if (!map.isNull())
        m_Size = map.size();
    ui->lblMap->setPixmap(map);
    ZoomChangedSlot(100);

#ifdef Q_WS_MAEMO_5
    ui->sliZoom->setVisible(false);

    unsigned long val = 1;
    Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
    XChangeProperty (QX11Info::display(),
            winId(),
            atom,
            XA_INTEGER,
            32,
            PropModeReplace,
            reinterpret_cast<unsigned char *>(&val),
            1);
#endif
}

MapWindow::~MapWindow()
{
    delete ui;
}

void MapWindow::ZoomChangedSlot(int value)
{
    if (!m_Size.isEmpty()){
        ui->lblMap->setFixedSize(m_Size.width() / 100.0 * value, m_Size.height() / 100.0 * value);
    }
}

void MapWindow::keyPressEvent(QKeyEvent* event)
{
    switch (event->key()) {
    case Qt::Key_F7:
        ui->sliZoom->setValue(ui->sliZoom->value() + 10);
        event->accept();
        break;

    case Qt::Key_F8:
        ui->sliZoom->setValue(ui->sliZoom->value() - 10);
        event->accept();
        break;
    }
    QWidget::keyPressEvent(event);
}
