#ifndef BOOKS_H
#define BOOKS_H

#include <QObject>

class BookEntry : public QObject
{
    Q_OBJECT
public:
    explicit BookEntry(QObject *parent = 0);

public:
    QString Serie;
    QString Title;
    int Number;
    bool Available;
    bool Downloaded;
    int Version;
    int Revision;
    QString DownloadUrl;

};

class Books : public QObject
{
    Q_OBJECT
public:
    explicit Books(QObject *parent = 0);

    int Version;
    QString DownloadUrl;
    QList<BookEntry*> List;

    static QString BaseUrl();
    static QString Directory();
    static QString GetBookFilename(int number);
    bool LoadList();

};

#endif // BOOKS_H
