#include "settingswindow.h"
#include "ui_settingswindow.h"
#include "commonstatic.h"
#include "fontswindow.h"
#include <QColorDialog>

SettingsWindow::SettingsWindow(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    ui->chkAutoSave->setVisible(false);

    connect(ui->chkOverrideCSS, SIGNAL(toggled(bool)), this, SLOT(CssSlot(bool)));
    connect(ui->pbnSave, SIGNAL(clicked()), this, SLOT(SaveSlot()));
    connect(ui->pbnBackground, SIGNAL(clicked()), this, SLOT(BackgroundSlot()));
    connect(ui->pbnColor, SIGNAL(clicked()), this, SLOT(ColorSlot()));
    connect(ui->pbnFont, SIGNAL(clicked()), this, SLOT(FontSlot()));
    m_Settings = CommonStatic::GeneralSettings(this);

    ShowData();
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::ShowData()
{
    ui->chkAutoSave->setChecked(m_Settings->value("autosave", true).toBool());
    ui->chkOverrideCSS->setChecked(m_Settings->value("overridecss", false).toBool());
    CssSlot(ui->chkOverrideCSS->isChecked());

    QColor b(m_Settings->value("background", "#ffffe6").toString());
    if (b.isValid()){
        ui->pbnBackground->setText(b.name());
        QPixmap p(32, 32);
        p.fill(b);
        ui->pbnBackground->setIcon(QIcon(p));
    }

    QColor c(m_Settings->value("color", "#003300").toString());
    if (c.isValid()){
        ui->pbnColor->setText(c.name());
        QPixmap p(32, 32);
        p.fill(c);
        ui->pbnColor->setIcon(QIcon(p));
    }

    QString font = m_Settings->value("font", "").toString();
    QStringList elem = font.split(";", QString::SkipEmptyParts);
    if (elem.count() == 3){
        m_Font = QFont(elem.at(0), -1, elem.at(2) == "true");
        m_Font.setPixelSize(elem.at(1).toInt());
    }
    ui->pbnFont->setText(m_Font.family());

}

void SettingsWindow::SaveSlot()
{
    m_Settings->setValue("autosave", ui->chkAutoSave->isChecked());
    m_Settings->setValue("overridecss", ui->chkOverrideCSS->isChecked());
    m_Settings->setValue("background", ui->pbnBackground->text());
    m_Settings->setValue("color", ui->pbnColor->text());
    m_Settings->setValue("font", QString("%1;%2;%3").arg(m_Font.family())
                                                    .arg(m_Font.pixelSize())
                                                    .arg(m_Font.bold() ? "true": "false"));
    m_Settings->sync();

    accept();
}

void SettingsWindow::BackgroundSlot()
{
    QColor c = QColorDialog::getColor(QColor(m_Settings->value("background", "#ffffe6").toString()), this);
    if (c.isValid()){
        ui->pbnBackground->setText(c.name());
        QPixmap p(32, 32);
        p.fill(c);
        ui->pbnBackground->setIcon(QIcon(p));
    }
}

void SettingsWindow::ColorSlot()
{
    QColor c = QColorDialog::getColor(QColor(m_Settings->value("color", "#003300").toString()), this);
    if (c.isValid()){
        ui->pbnColor->setText(c.name());
        QPixmap p(32, 32);
        p.fill(c);
        ui->pbnColor->setIcon(QIcon(p));
    }
}

void SettingsWindow::FontSlot()
{
    FontsWindow* dlg = new FontsWindow(this, m_Font);
    if (dlg->exec() == QDialog::Accepted){
        m_Font = dlg->GetSelected();
        ui->pbnFont->setText(m_Font.family());
    }
}

void SettingsWindow::CssSlot(bool checked)
{
    ui->pbnBackground->setEnabled(checked);
    ui->pbnColor->setEnabled(checked);
    ui->pbnFont->setEnabled(checked);
}
