#include "playercreationwindow.h"
#include "ui_playercreationwindow.h"
#ifdef Q_WS_MAEMO_5
#include <QMaemo5Style>
#endif
#include "commonstatic.h"
#include "ruleswindow.h"
#include "core/books.h"

PlayerCreationWindow::PlayerCreationWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::PlayerCreationWindow)
{
    ui->setupUi(this);
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QColor secondaryColor = QMaemo5Style::standardColor("SecondaryTextColor");
    QPalette secondaryPalette(QColor(255,255,255, 0));
    secondaryPalette.setColor(QPalette::Foreground, secondaryColor);

    ui->lblPick->setPalette(secondaryPalette);
    ui->lblDisciplines->setPalette(secondaryPalette);
    ui->lblItem->setPalette(secondaryPalette);
#endif

    m_RandomPicker = new RandomNumberPicker(this, ui->lblDice);
    connect(m_RandomPicker, SIGNAL(Random(int)), SLOT(RandomSlot(int)));

    m_Loop = NULL;
    m_Player = new Player();
    m_Player->AddItem("Map of Sommerlund", true);
    m_Player->AddMeal("Meal");

    Weapon* axe = new Weapon(m_Player);
    axe->Name = "Axe";
    axe->AddClass(Weapon::Axe);
    m_Player->Items.append(axe);

    m_SkillDone = false;
    m_EnduranceDone = false;
    m_CrownsDone = false;
    m_WeaponskillDone = false;
    m_ItemDone = false;

    EnableButtons(true);
    ShowData();

    connect(ui->actionRules, SIGNAL(triggered()), this, SLOT(RulesSlot()));

    connect(ui->pbnCombatSkill, SIGNAL(clicked()), this, SLOT(CombatSkillSlot()));
    connect(ui->pbnEndurance, SIGNAL(clicked()), this, SLOT(EnduranceSlot()));
    connect(ui->pbnCrowns, SIGNAL(clicked()), this, SLOT(CrownsSlot()));
    connect(ui->pbnPickItem, SIGNAL(clicked()), this, SLOT(ItemSlot()));
    connect(ui->pbnPickWeaponskill, SIGNAL(clicked()), this, SLOT(WeaponskillRandomSlot()));
    connect(ui->pbnDone, SIGNAL(clicked()), this, SLOT(close()));

    connect(ui->chkAnimalKinship, SIGNAL(toggled(bool)), this, SLOT(AnimalKinshipSlot(bool)));
    connect(ui->chkCamouflage, SIGNAL(toggled(bool)), this, SLOT(CamouflageSlot(bool)));
    connect(ui->chkHealing, SIGNAL(toggled(bool)), this, SLOT(HealingSlot(bool)));
    connect(ui->chkHunting, SIGNAL(toggled(bool)), this, SLOT(HuntingSlot(bool)));
    connect(ui->chkMindblast, SIGNAL(toggled(bool)), this, SLOT(MindblastSlot(bool)));
    connect(ui->chkMindOverMatter, SIGNAL(toggled(bool)), this, SLOT(MindOverMatterSlot(bool)));
    connect(ui->chkMindshield, SIGNAL(toggled(bool)), this, SLOT(MindshieldSlot(bool)));
    connect(ui->chkSixthSense, SIGNAL(toggled(bool)), this, SLOT(SixthSenseSlot(bool)));
    connect(ui->chkTracking, SIGNAL(toggled(bool)), this, SLOT(TrackingSlot(bool)));
    connect(ui->chkWeaponSkill, SIGNAL(toggled(bool)), this, SLOT(WeaponskillSlot(bool)));
}

PlayerCreationWindow::~PlayerCreationWindow()
{
    delete ui;
}

void PlayerCreationWindow::exec()
{
    m_Loop = new QEventLoop(this);
    show();
    m_Loop->exec();
}

void PlayerCreationWindow::closeEvent(QCloseEvent*)
{
    if (m_Loop)
        m_Loop->quit();
    QMainWindow::close();
}

Player* PlayerCreationWindow::GetPlayer()
{
    if (m_SkillDone && m_EnduranceDone && m_CrownsDone && m_ItemDone && CheckDisciplines())
        return m_Player;
    delete m_Player;
    return NULL;
}

void PlayerCreationWindow::PickRandomNumber()
{
    m_RandomPicker->GetRandomNumber(this);
}

void PlayerCreationWindow::RandomSlot(int random)
{
    switch(m_Random){
    case RandomSkill:
        m_Player->BaseCombatSkill = random + 10;
        m_SkillDone = true;
        break;
    case RandomEndurance:
        m_Player->BaseEndurance = random + 20;
        m_Player->Endurance = m_Player->GetBaseEndurance();
        m_EnduranceDone = true;
        break;
    case RandomCrowns:
        m_Player->GoldCrowns += random;
        m_CrownsDone = true;
        break;
    case RandomWeaponSkill:
        {
            switch (random){
            case 0:
                m_RandomWeaponskill = Weapon::Dagger;
                break;
            case 1:
                m_RandomWeaponskill = Weapon::Spear;
                break;
            case 2:
                m_RandomWeaponskill = Weapon::Mace;
                break;
            case 3:
                m_RandomWeaponskill = Weapon::ShortSword;
                break;
            case 4:
                m_RandomWeaponskill = Weapon::WarHammer;
                break;
            case 5:
            case 7:
                m_RandomWeaponskill = Weapon::Sword;
                break;
            case 6:
                m_RandomWeaponskill = Weapon::Axe;
                break;
            case 8:
                m_RandomWeaponskill = Weapon::Quarterstaff;
                break;
            case 9:
                m_RandomWeaponskill = Weapon::Broadsword;
                break;
            }
            m_WeaponskillDone = true;
            Weaponskill* s = new Weaponskill(m_Player);
            s->Weapon = m_RandomWeaponskill;
            m_Player->KaiDisciplines.append(s);
            ui->lblWeaponskill->setText(s->Description());
        }
        break;
    case RandomItem:
        {
            switch (random){
            case 0:
                {
                    Weapon* w = new Weapon(m_Player);
                    w->Name = "Broadsword";
                    w->AddClass(Weapon::Broadsword);
                    m_Player->Items.append(w);
                }
                ui->lblItemMessage->setText("You got a Broadsword.");
                break;
            case 1:
                {
                    Weapon* w = new Weapon(m_Player);
                    w->Name = "Sword";
                    w->AddClass(Weapon::Sword);
                    m_Player->Items.append(w);
                }
                ui->lblItemMessage->setText("You got a Sword.");
                break;
            case 2:
                {
                    Item* i = m_Player->AddItem("Helmet", true);
                    i->Description = "Adds 2 ENDURANCE points to your total";
                    i->SetEnduranceDelta(2);
                    m_Player->Endurance = m_Player->GetBaseEndurance();
                }
                ui->lblItemMessage->setText("You got a Helmet.");
                break;
            case 3:
                {
                    m_Player->AddMeal("Meal");
                    m_Player->AddMeal("Meal");
                }
                ui->lblItemMessage->setText("You got two Meals.");
                break;
            case 4:
                {
                    Item* i = m_Player->AddItem("Chainmail Waistcoat", true);
                    i->Description = "Adds 4 ENDURANCE points to your total";
                    i->SetEnduranceDelta(4);
                    m_Player->Endurance = m_Player->GetBaseEndurance();
                }
                ui->lblItemMessage->setText("You got a Chainmail Waistcoat.");
                break;
            case 5:
                {
                    Weapon* w = new Weapon(m_Player);
                    w->Name = "Mace";
                    w->AddClass(Weapon::Mace);
                    m_Player->Items.append(w);
                }
                ui->lblItemMessage->setText("You got a Mace.");
                break;
            case 6:
                m_Player->AddHealingItem("Healing Potion", 4);
                ui->lblItemMessage->setText("You got a Healing Potion.");
                break;
            case 7:
                {
                    Weapon* w = new Weapon(m_Player);
                    w->Name = "Quarterstaff";
                    w->AddClass(Weapon::Quarterstaff);
                    m_Player->Items.append(w);
                }
                ui->lblItemMessage->setText("You got a Quarterstaff.");
                break;
            case 8:
                {
                    Weapon* w = new Weapon(m_Player);
                    w->Name = "Spear";
                    w->AddClass(Weapon::Spear);
                    w->SetHands(2);
                    m_Player->Items.append(w);
                }
                ui->lblItemMessage->setText("You got a Spear.");
                break;
            case 9:
                m_Player->GoldCrowns += 12;
                ui->lblItemMessage->setText("You got 12 Gold Crowns.");
                break;
            }
        }
        m_ItemDone = true;
        break;
    }

    ShowData();
    EnableButtons(true);
}

void PlayerCreationWindow::CombatSkillSlot()
{
    EnableButtons(false);
    m_Random = RandomSkill;
    PickRandomNumber();
}

void PlayerCreationWindow::EnduranceSlot()
{
    EnableButtons(false);
    m_Random = RandomEndurance;
    PickRandomNumber();
}

void PlayerCreationWindow::CrownsSlot()
{
    EnableButtons(false);
    m_Random = RandomCrowns;
    PickRandomNumber();
}

void PlayerCreationWindow::ItemSlot()
{
    EnableButtons(false);
    m_Random = RandomItem;
    PickRandomNumber();
}

void PlayerCreationWindow::WeaponskillRandomSlot()
{
    EnableButtons(false);
    m_Random = RandomWeaponSkill;
    PickRandomNumber();
}

void PlayerCreationWindow::EnableButtons(bool enable)
{
    ui->pbnCombatSkill->setEnabled(enable && !m_SkillDone);
    ui->pbnEndurance->setEnabled(enable && !m_EnduranceDone);
    ui->pbnCrowns->setEnabled(enable && !m_CrownsDone);
    ui->pbnPickWeaponskill->setEnabled(enable && !m_WeaponskillDone && ui->chkWeaponSkill->isChecked());
    ui->pbnPickItem->setEnabled(enable && !m_ItemDone);
    CheckDone();
}

void PlayerCreationWindow::ShowData()
{
    ui->lblSkill->setText(QString::number(m_Player->BaseCombatSkill));
    ui->lblEndurance->setText(QString::number(m_Player->Endurance));
    ui->lblCrowns->setText(QString::number(m_Player->GoldCrowns));

    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);
    QSizePolicy stretchOne;
    stretchOne.setHorizontalStretch(1);

    QList<Weapon*> weapons = m_Player->Weapons();
    if (weapons.count() > 0)
        ui->lblWeapon1->setText(weapons.at(0)->Name);
    else
        ui->lblWeapon1->setText("-");

    if (weapons.count() > 1)
        ui->lblWeapon2->setText(weapons.at(1)->Name);
    else
        ui->lblWeapon2->setText("-");

    QLayoutItem* child;
    while ((child = ui->layItems->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    int row = 0;
    int index = 0;
    foreach(Item* i, m_Player->Items){
        if (!i->GetIsWeapon()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            ui->layItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            lbl = new QLabel(this);
            lbl->setText(i->Description);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 2);

            row++;
        }
        index++;
    }
}

bool PlayerCreationWindow::CheckDisciplines()
{
    int number = 0;
    if (ui->chkAnimalKinship->isChecked())
        number += 1;
    if (ui->chkCamouflage->isChecked())
        number += 1;
    if (ui->chkHealing->isChecked())
        number += 1;
    if (ui->chkHunting->isChecked())
        number += 1;
    if (ui->chkMindblast->isChecked())
        number += 1;
    if (ui->chkMindOverMatter->isChecked())
        number += 1;
    if (ui->chkMindshield->isChecked())
        number += 1;
    if (ui->chkSixthSense->isChecked())
        number += 1;
    if (ui->chkTracking->isChecked())
        number += 1;

    if (ui->chkWeaponSkill->isChecked())
        number += 1;

    if (number == 5){
        ui->chkAnimalKinship->setEnabled(ui->chkAnimalKinship->isChecked());
        ui->chkCamouflage->setEnabled(ui->chkCamouflage->isChecked());
        ui->chkHealing->setEnabled(ui->chkHealing->isChecked());
        ui->chkHunting->setEnabled(ui->chkHunting->isChecked());
        ui->chkMindblast->setEnabled(ui->chkMindblast->isChecked());
        ui->chkMindOverMatter->setEnabled(ui->chkMindOverMatter->isChecked());
        ui->chkMindshield->setEnabled(ui->chkMindshield->isChecked());
        ui->chkSixthSense->setEnabled(ui->chkSixthSense->isChecked());
        ui->chkTracking->setEnabled(ui->chkTracking->isChecked());
        ui->chkWeaponSkill->setEnabled(ui->chkWeaponSkill->isChecked());
    }else{
        ui->chkAnimalKinship->setEnabled(true);
        ui->chkCamouflage->setEnabled(true);
        ui->chkHealing->setEnabled(true);
        ui->chkHunting->setEnabled(true);
        ui->chkMindblast->setEnabled(true);
        ui->chkMindOverMatter->setEnabled(true);
        ui->chkMindshield->setEnabled(true);
        ui->chkSixthSense->setEnabled(true);
        ui->chkTracking->setEnabled(true);
        ui->chkWeaponSkill->setEnabled(true);
    }

    CheckDone();
    return m_Player->KaiDisciplines.count() == 5;
}

void PlayerCreationWindow::AnimalKinshipSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new AnimalKinship(m_Player));
    else
        m_Player->RemoveDiscipline("Animal Kinship");
    CheckDisciplines();
}

void PlayerCreationWindow::CamouflageSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new Camouflage(m_Player));
    else
        m_Player->RemoveDiscipline("Camouflage");
    CheckDisciplines();
}

void PlayerCreationWindow::HealingSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new Healing(m_Player));
    else
        m_Player->RemoveDiscipline("Healing");
    CheckDisciplines();
}

void PlayerCreationWindow::HuntingSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new Hunting(m_Player));
    else
        m_Player->RemoveDiscipline("Hunting");
    CheckDisciplines();
}

void PlayerCreationWindow::MindblastSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new Mindblast(m_Player));
    else
        m_Player->RemoveDiscipline("Mindblast");
    CheckDisciplines();
}

void PlayerCreationWindow::MindOverMatterSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new MindOverMatter(m_Player));
    else
        m_Player->RemoveDiscipline("Mind Over Matter");
    CheckDisciplines();
}

void PlayerCreationWindow::MindshieldSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new Mindshield(m_Player));
    else
        m_Player->RemoveDiscipline("Mindshield");
    CheckDisciplines();
}

void PlayerCreationWindow::SixthSenseSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new SixthSense(m_Player));
    else
        m_Player->RemoveDiscipline("Sixth Sense");
    CheckDisciplines();
}

void PlayerCreationWindow::TrackingSlot(bool value)
{
    if (value)
        m_Player->KaiDisciplines.append(new Tracking(m_Player));
    else
        m_Player->RemoveDiscipline("Tracking");
    CheckDisciplines();
}

void PlayerCreationWindow::WeaponskillSlot(bool value)
{
    if (value){
        if (m_WeaponskillDone){
            Weaponskill* s = new Weaponskill(m_Player);
            s->Weapon = m_RandomWeaponskill;
            m_Player->KaiDisciplines.append(s);
            ui->lblWeaponskill->setText(s->Description());
        }
        ui->pbnPickWeaponskill->setEnabled(!m_WeaponskillDone);
    }else{
        m_Player->RemoveDiscipline("Weaponskill");
        ui->pbnPickWeaponskill->setEnabled(false);
    }
    CheckDisciplines();
}

void PlayerCreationWindow::RulesSlot()
{
    QString filename = Books::GetBookFilename(1);
    QFileInfo info(filename);

    RulesWindow* dlg = new RulesWindow(this, info.absolutePath());
    dlg->show();
}

void PlayerCreationWindow::CheckDone()
{
    if (m_SkillDone && m_EnduranceDone && m_CrownsDone && m_ItemDone && m_Player->KaiDisciplines.count() == 5)
        ui->pbnDone->setEnabled(true);
    else
        ui->pbnDone->setEnabled(false);
}
