#include "bonusdisciplinewindow.h"
#include "ui_bonusdisciplinewindow.h"
#include <QPushButton>

BonusDisciplineWindow::BonusDisciplineWindow(QWidget *parent, int serie, Player* player) :
    QDialog(parent),
    ui(new Ui::BonusDisciplineWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif
    m_RandomPicker = new RandomNumberPicker(this, ui->lblDice, true);
    connect(m_RandomPicker, SIGNAL(Random(int)), SLOT(GetRandomSlot(int)));

    m_Serie = serie;
    m_Player = player;

    switch (m_Serie){
    case Book::Kai:
        m_List << new Camouflage(m_Player) << new Hunting(m_Player) << new SixthSense(m_Player)
               << new Tracking(m_Player) << new Healing(m_Player) << new Weaponskill(m_Player)
               << new Mindshield(m_Player) << new Mindblast(m_Player) << new AnimalKinship(m_Player)
               << new MindOverMatter(m_Player);
        break;
    default:
        break;
    }

    ShowData();
}

BonusDisciplineWindow::~BonusDisciplineWindow()
{
    delete ui;
}

void BonusDisciplineWindow::ShowData()
{
    QLayoutItem* child;
    while ((child = ui->layKaiDisciplines->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    m_Buttons.clear();
    int row = 0;
    foreach (KaiDiscipline* d, m_List){
        if (!m_Player->HasDiscipline(d->Name)){
            QLabel* lbl = new QLabel(this);
            lbl->setText(d->Description());
            ui->layKaiDisciplines->addWidget(lbl, row, 0);

            bool done = false;
            QPushButton* pbn = new QPushButton(this);
            pbn->setObjectName(d->Name);
            if (d->Name == "Weaponskill"){
                Weaponskill* ws = qobject_cast<Weaponskill*>(d);
                if (ws && ws->Weapon == Weapon::None){
                    pbn->setText("Pick");
                    connect(pbn, SIGNAL(clicked()), this, SLOT(RandomSlot()));
                    done = true;
                }
            }

            if (!done){
                pbn->setText("Choose");
                connect(pbn, SIGNAL(clicked()), this, SLOT(ChooseSlot()));
            }
            pbn->setMaximumSize(75, 50);
            ui->layKaiDisciplines->addWidget(pbn, row, 1);
            m_Buttons.append(pbn);
            row++;
        }
    }
}

KaiDiscipline* BonusDisciplineWindow::GetDiscipline(QString name)
{
    foreach (KaiDiscipline* d, m_List){
        if (!QString::compare(d->Name, name))
            return d;
    }
    return NULL;
}

void BonusDisciplineWindow::ChooseSlot()
{
    QString name = sender()->objectName();
    switch (m_Serie){
    case Book::Kai:
        {
            KaiDiscipline* d = GetDiscipline(name);
            if (d)
                m_Player->KaiDisciplines.append(d);
        }
        break;
    default:
        break;
    }

    accept();
}

void BonusDisciplineWindow::RandomSlot()
{
    m_RandomSender = sender()->objectName();
    foreach(QPushButton* b, m_Buttons)
        b->setEnabled(false);
    m_RandomPicker->GetRandomNumber(this);
}

void BonusDisciplineWindow::GetRandomSlot(int random)
{
    if (m_RandomSender == "Weaponskill"){
        KaiDiscipline* d = GetDiscipline(m_RandomSender);
        Weaponskill* ws = qobject_cast<Weaponskill*>(d);
        switch (random){
        case 0:
            ws->Weapon = Weapon::Dagger;
            break;
        case 1:
            ws->Weapon = Weapon::Spear;
            break;
        case 2:
            ws->Weapon = Weapon::Mace;
            break;
        case 3:
            ws->Weapon = Weapon::ShortSword;
            break;
        case 4:
            ws->Weapon = Weapon::WarHammer;
            break;
        case 5:
        case 7:
            ws->Weapon = Weapon::Sword;
            break;
        case 6:
            ws->Weapon = Weapon::Axe;
            break;
        case 8:
            ws->Weapon = Weapon::Quarterstaff;
            break;
        case 9:
            ws->Weapon = Weapon::Broadsword;
            break;
        }
    }
    ShowData();
}
