// this file is part of liqbase by Gary Birkett
		
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>

#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
		
int liqbookreader_run(char *bookfilename);
		
//#####################################################################
//#####################################################################
//##################################################################### liqbook_select :: by gary birkett
//#####################################################################
//#####################################################################
		
		
/**	
 * liqbook_select widget filter, the system is asking you to filter to the specified .
 */	
static int liqbook_select_filter(liqcell *self,liqcellfiltereventargs *args, liqcell *context)
{
	// system is indicating the user has typed into the search box
	// you are expected to filter your content based upon this searchterm.
	// show or hide details and rearrange contents to apply this filter.
	char *searchterm = NULL;
	args->resultoutof=0;  // total number of searchable contents
	args->resultshown=0;  // count of options remaining after filtering.
	searchterm = args->searchterm;
	if(searchterm && *searchterm)
	{
		 // check the name property
		 args->resultoutof++;
		 if( stristr(self->name,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check the classname property
		 args->resultoutof++;
		 if( stristr(self->classname,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check any other properties or children and increment counters
		 // filter out list items recursively
	}
	return 0;
}
/**	
 * liqbook_select widget refresh, all params set, present yourself to the user.
 */	
static int liqbook_select_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqbook_select dialog_open - the user zoomed into the dialog
 */	
static int liqbook_select_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * liqbook_select dialog_close - the dialog was closed
 */	
static int liqbook_select_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * liqbook_select widget shown - occurs once per lifetime
 */	
static int liqbook_select_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqbook_select mouse - occurs all the time as you stroke the screen
 */	
static int liqbook_select_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqbook_select click - occurs when a short mouse stroke occured
 */	
static int liqbook_select_click(liqcell *self, liqcellclickeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqbook_select keypress - the user pressed a key
 */	
static int liqbook_select_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqbook_select keyrelease - the user released a key
 */	
static int liqbook_select_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqbook_select paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int liqbook_select_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
//{
//	// big heavy event, use sparingly
//	return 0;
//}
/**	
 * liqbook_select dynamic resizing
 */	
static int liqbook_select_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float iw=((float)self->w);
	float ih=((float)self->h);
	
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
	        liqcell *body = liqcell_child_lookup(backplane, "body");
	liqcell *cmdaccept = liqcell_child_lookup(self, "cmdaccept");

	liqcell_setrect( backplane, iw*0.000,ih*0.000, iw*1.000,ih*1.000);
	liqcell_setrect( body, iw*0.000,ih*0.000, iw*1.000,ih*1.000);
	liqcell_setrect( cmdaccept, iw*0.722,ih*0.900, iw*0.258,ih*0.100);

	liqcell *c = liqcell_getlinkchild_visible(body);
	while(c)
	{
		if(iw > ih)
			liqcell_setrect( c, 0,0, iw,ih*0.15);
		else
			liqcell_setrect( c, 0,0, iw,ih*0.08);
		c=liqcell_getlinknext_visible(c);
	}
        liqcell_child_arrange_easycol(body);
	
	return 0;
}

/**	
 * liqbook_select dynamic layout
 */	
static int liqbook_select_layout(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float ww=canvas.pixelwidth;
	float hh=canvas.pixelheight;
	liqcell_setrect(self,		0,0,  ww,hh);
	return 0;
}
/**	
 * liqbook_select.cmdaccept clicked
 */	
static int cmdaccept_click(liqcell *self,liqcellclickeventargs *args, liqcell *liqbook_select)
{
	liqcell *backplane = liqcell_child_lookup(liqbook_select, "backplane");
	        liqcell *body = liqcell_child_lookup(backplane, "body");
	liqcell *cmdaccept = liqcell_child_lookup(liqbook_select, "cmdaccept");
	
	char *bookname = liqcell_propgets( liqbook_select,"bookname", "");
	if(bookname && *bookname)
	{
		liqbookreader_run(bookname);
		liqapp_pref_setvalue("book_filename",bookname);
		liqapp_prefs_save();
	}
	liqcell *sel = liqcell_child_getfirstselected(body);
	if(sel)
	{
		liqapp_log("SHOWN: %lx %ld",sel->kind,sel->kind);
		liqcell_setshown(sel,0);
		liqapp_log("SHOW2: %lx %ld",sel->kind,sel->kind);
		liqcell_setdirty(sel,1);
	}

       	return 0;
}
/**	
 * liqbook_select_child_test_seek this function shows how to access members
 */	
	  
static void liqbook_select_child_test_seek(liqcell *liqbook_select)
{	  
	liqcell *backplane = liqcell_child_lookup(liqbook_select, "backplane");
        liqcell *body = liqcell_child_lookup(backplane, "body");
	liqcell *cmdaccept = liqcell_child_lookup(liqbook_select, "cmdaccept");

}



/**	
 * liqbook_booklistitem_click - occurs when a short mouse stroke occured
 */	
static int liqbook_booklistitem_click(liqcell *self, liqcellclickeventargs *args,liqcell *liqbook_select)
{
	liqcell *backplane = liqcell_child_lookup(liqbook_select, "backplane");
        liqcell *body = liqcell_child_lookup(backplane, "body");
	liqcell *cmdaccept = liqcell_child_lookup(liqbook_select, "cmdaccept");

    liqcell_child_selectnone(body);
    liqcell_setselected(self,1);
    liqcell_propsets( liqbook_select,"bookname", self->name);

    liqcell_setenabled(cmdaccept,1);
    
	return 0;
}


static int liqcell_scan_folder_for_books(liqcell *self,char *path)
{
    
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
        liqcell *body = liqcell_child_lookup(backplane, "body");

		char *widgetpath = path;
		DIR           *	dir_p;
		struct dirent *	dir_entry_p;
		char 			fn[FILENAME_MAX+1];
		char          * ft;
        struct pagefilename pfn;
		dir_p = opendir( widgetpath );
		if(!dir_p)
		{
			liqapp_log("liqcell_scan_folder_for_books opendir failed: '%s'",widgetpath);
			return -1;			// heh thanks kot :)
		}
		while( NULL != (dir_entry_p = readdir(dir_p)))
		{
			if( dir_entry_p->d_name[0]=='.' )
				continue;

			ft=dir_entry_p->d_name;

			snprintf(fn , FILENAME_MAX , "%s/%s", widgetpath , ft);

			struct stat     statbuf;
			if(stat(fn, &statbuf) == -1)
			{
				liqapp_log("liqcell_scan_folder_for_books stat failed: '%s'",fn);
				return -2;
			}
            
			if ( S_ISDIR(statbuf.st_mode) )
			{
				//printf(" DIR  ");
				liqcell_scan_folder_for_books(self,fn);	
			}
			else
			// got the information we need
			if ( S_ISREG(statbuf.st_mode) )
			{
			
				const char *ext=liqapp_filename_walktoextension(ft);
				if( strcasecmp(ext,"txt")==0 )
				{
					liqapp_log("book addin1: '%s'",fn);
					liqcell *booklistitem = liqcell_quickcreatevis(fn, "bookitem", 0, 0, body->w, 58);
					liqcell_child_append(  body, booklistitem);
					liqcell_handleradd_withcontext(booklistitem, "click",		(void*)liqbook_booklistitem_click ,self);
				}
			}
		}
		closedir(dir_p);
		return 0;

}



/**	
 * create a new liqbook_select widget
 */	
liqcell *liqbook_select_create()
{
	liqcell *self = liqcell_quickcreatewidget("liqbook_select", "form", 800, 480);
	if(!self) {liqapp_log("liqcell error not create 'liqbook_select'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering



	//############################# backplane:label
	liqcell *backplane = liqcell_quickcreatevis("backplane", "label", 0, 0, 800, 480);
	//liqcell_setfont(	backplane, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
	//liqcell_setcaption(backplane, "backplane" );
	//liqcell_propsets(  backplane, "textcolor", "rgb(255,0,0)" );
	//liqcell_propsets(  backplane, "backcolor", "rgb(64,64,64)" );
	//liqcell_propseti(  backplane, "textalign", 2 );
	//liqcell_propseti(  backplane, "textaligny", 2 );
	liqcell_child_append(  self, backplane);
 
		//############################# backplane:label
		liqcell *body = liqcell_quickcreatevis("body", "label", 0, 0, 800, 480);
		//liqcell_setfont(	body, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
		//liqcell_setcaption(body, "backplane" );
		//liqcell_propsets(  body, "textcolor", "rgb(255,0,0)" );
		//liqcell_propsets(  body, "backcolor", "rgb(64,64,64)" );
		//liqcell_propseti(  body, "textalign", 2 );
		//liqcell_propseti(  body, "textaligny", 2 );
		liqcell_handleradd(body,    "mouse",   liqcell_easyhandler_kinetic_mouse );
		liqcell_child_append(  backplane,body);


	//############################# cmdaccept:label
	liqcell *cmdaccept = liqcell_quickcreatevis("cmdaccept", "label", 594, 432, 206, 48);
	liqcell_setfont(	cmdaccept, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (29), 0) );
	liqcell_setcaption(cmdaccept, "Open Book" );
	liqcell_propsets(  cmdaccept, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  cmdaccept, "backcolor", "xrgb(0,64,0)" );
	liqcell_propsets(  cmdaccept, "bordercolor", "rgb(255,255,255)" );
	liqcell_propseti(  cmdaccept, "textalign", 2 );
	liqcell_propseti(  cmdaccept, "textaligny", 2 );
	liqcell_handleradd_withcontext(cmdaccept, "click", (void*)cmdaccept_click, self );
	liqcell_child_append(  self, cmdaccept);
    liqcell_setenabled(cmdaccept,0);


    

	char buf[FILENAME_MAX+1];
        snprintf(buf,sizeof(buf),"%s/%s",app.homepath,"MyDocs/ebooks");
        
        liqcell_scan_folder_for_books( self, buf);
        liqapp_log("book group: '%s'",buf);
        liqcell_child_arrange_easycol(body);
        liqapp_log("book grou2: '%s'",buf);
        
       

	//liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	//liqcell_setimage(  self ,  liqimage_cache_getfile( "/usr/share/liqbase/liqbook/media/liqbook_select_back.png",0,0,0) );
	liqcell_handleradd_withcontext(self, "filter",		 (void*)liqbook_select_filter ,self);
	liqcell_handleradd_withcontext(self, "refresh",		(void*)liqbook_select_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown",		  (void*)liqbook_select_shown ,self);
	liqcell_handleradd_withcontext(self, "resize",	  (void*)liqbook_select_resize ,self);
	liqcell_handleradd_withcontext(self, "layout",	  (void*)liqbook_select_layout ,self);
	//liqcell_handleradd_withcontext(self, "keypress",	(void*)liqbook_select_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", (void*)liqbook_select_keyrelease ,self);
	//liqcell_handleradd_withcontext(self, "mouse",		(void*)liqbook_select_mouse,self );
	//liqcell_handleradd_withcontext(self, "click",		(void*)liqbook_select_click ,self);
	//liqcell_handleradd_withcontext(self, "paint",		(void*)liqbook_select_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open",  (void*)liqbook_select_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", (void*)liqbook_select_dialog_close ,self);
	return self;
}

