import QtQuick 1.0
import "search"
import "components"
import "common"

Window {
	id: root
	width: parent.width; height: parent.height
	borderTitle: "Search Results"

	onGetFinished: root.xml = xml

	onParamChanged: search(param, pagedList.start,pagedList.count)

	function search(param, start,count){
		if(type === "Profile"){
			get(API.search_person(param,start,count))
			pagedList.pageQuery = "/people-search/people"
			pagedList.model = searchModel
			pagedList.delegate = searchDelegate
		}else if(type === "Companies"){
			get(API.search_company(param,start,count))
			pagedList.pageQuery = "/company-search/companies"
			pagedList.model = companyModel
			pagedList.delegate = companyDelegate
		}
		else if(type === "Jobs"){
			get(API.search_job(param,start,count))
			pagedList.pageQuery = "/job-search/jobs"
			pagedList.model = jobModel
			pagedList.delegate = jobDelegate
		}
	}

	property string param
	property string type
	property string xml

	SearchBar{
		id: searchBar
		z:1
		anchors.top: parent.top
		anchors.topMargin: borderHeight
		onClicked: {
			root.type = type
			root.param = param
		}
	}

	PagedList{
		id: pagedList
		xml: root.xml
		anchors.topMargin: borderHeight + searchBar.height
		onXmlSet: root.busy = true
		onXmlLoaded: root.busy = false
		//		pageQuery: root.type === "Profile" ? "/people-search/people" : "/company-search/companies"
		//		model: root.type === "Profile" ? searchModel : companyModel
		//		delegate: root.type === "Profile" ? searchDelegate : companyDelegate
		Connections{
			onStartChanged: root.search(root.param, pagedList.start, pagedList.count)
		}
	}



	/*model and delegate for people searches*/
	SearchModel{
		id: searchModel
		xml: root.xml
	}
	Component{
		id: searchDelegate
		SearchDelegate{
			onClicked: {
				var comp = Qt.createComponent("Profile.qml")
				var object = comp.createObject(root.parent)
				object.profileID = profileID
				object.caller = root
				root.state = "hidden"
			}
		}
	}


	/*model and delegate for company searches*/
	SearchCompanyModel{
		id: companyModel
		xml: root.xml
	}
	Component{
		id: companyDelegate
		SearchCompanyDelegate{
			onClicked: {
				var comp = Qt.createComponent("company/Company.qml")
				var object = comp.createObject(root.parent)
				object.profileID = profileID
				object.caller = root
				root.state = "hidden"
			}
		}
	}

	/*model and delegate for job searches*/
	SearchJobModel{
		id: jobModel
		xml: root.xml

	}
	Component{
		id: jobDelegate
		SearchJobDelegate{
			onClicked: {
				var comp = Qt.createComponent("Job.qml")
				var object = comp.createObject(root.parent)
				object.profileID = profileID
				object.caller = root
				root.state = "hidden"
			}
		}
	}




}
