import QtQuick 1.0
import "jobBookmarks"
import "components"
import "common"

Window {
	id: root
	width: parent.width; height: parent.height
	borderTitle: "Bookmarked Jobs"

	onGetFinished: root.xml = xml
	Component.onCompleted: get(API.get_job_bookmarks(pagedList.start, pagedList.count))

	property string xml


PagedList{
	id: pagedList
	xml: root.xml
	anchors.topMargin: borderHeight
	onXmlSet: root.busy = true
	onXmlLoaded: root.busy = false
	pageQuery: "/job-bookmarks"
	model: model
	delegate: delegate
	Connections{
		onStartChanged: root.get(API.get_job_bookmarks(pagedList.start, pagedList.count))
	}
}



JobBookmarksModel{
	id: model
	xml: root.xml
}
Component{
	id: delegate
	JobBookmarksDelegate{
		onClicked: {
			var comp = Qt.createComponent("Job.qml")
			var object = comp.createObject(root.parent)
			object.profileID = profileID
			object.caller = root
			root.state = "hidden"
		}
	}
}





}
