import QtQuick 1.0
import "common"
import "components"
import "job"

Window {
	id: root

	width: parent.width; height: parent.height
	borderTitle: "Job"

	onProfileIDChanged: get(API.get_job_by_id(profileID))
	onGetFinished: {
		profileXML = xml
		loader.sourceComponent = content
		loader.visible = true
	}


	property string profileID
	property string profileXML

	SystemPalette{id: palette}

	Loader{
		id: loader
		anchors.fill: parent
		anchors.topMargin: borderHeight
		visible: false
	}

	Component{
		id: content
		Flickable{
			anchors.fill: parent
			contentHeight: column.height + 50

			Column{
				id: column
				anchors.top: parent.top
				width: parent.width
				spacing: 20

				JobModel{
					id: companyModel
					xml: profileXML
					onStatusChanged: {
						if(status === XmlListModel.Ready && xml){
							root.borderTitle = get(0).name
						}
					}
				}



				ListView{
					id: general
					width: parent.width
					height: contentHeight
					model: companyModel
					interactive: false
					delegate: JobDelegate{
						id: compDel
						onBookmark: root.post(API.post_job_bookmark(id))
						onUnbookmark: root.httpDelete(API.delete_job_bookmark(id))
//						onFinance: {
//							var comp = Qt.createComponent("../Finance.qml")
//							var obj = comp.createObject(root.parent)
//							obj.ticker = ticker
//							obj.caller = root
//							root.state = "hidden"
//						}
						onNews: {
							var comp = Qt.createComponent("News.qml")
							var obj = comp.createObject(root.parent)
							obj.searchString = name
							obj.caller = root
							root.state = "hidden"
						}

						Connections{
							target: root
							onPostFinished: {
								var x = xml
								var sCode = statusCode
								var sText = statusText
								if(sCode === "201"){
									compDel.bookmarked = true
									User.bookmark(id,name) //add the job id to the QHash
								}
							}
							onDeleteFinished:{
								var x = xml
								var sCode = statusCode
								var sText = statusText
								if(sCode === "201"){
									compDel.bookmarked = false
									User.unbookmark(id) //remove the job id from the QHash
								}
							}
						}
					}
				}



//				Section{
//					id: specialties
//					text: "Specialties"
//					width: column.width
//					model: SpecialtiesModel{xml: profileXML}
//					delegate: SpecialtiesDelegate{}
//				}

//				Section{
//					id: locations
//					text: "Locations"
//					width: column.width
//					listSpacing: 20
//					model: LocationsModel{xml: profileXML}
//					delegate: LocationsDelegate{}

//				}
			}


		}

	}







}
