/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0

Component{
	id: component

	Flickable{
		id: root
//		width: parent.width; height: parent.height
//		width: 800; height: 480
		anchors.fill: parent

		/*Color and font properties*/
		property string fontStyle: "Arial"
		property int fontSize: 25
		property int smallFontSize: fontSize * .8
		property string fontColor: "#006699"

		boundsBehavior: Flickable.StopAtBounds
		contentHeight: height
		contentWidth: width

		Row{
			id: row
			spacing: 10
			Image {
				id: image
				height:  80
				width: height
				source: pictureUrl
				Component.onCompleted: {
					if(!pictureUrl)
						source = "qrc:///qml/images/profile-picture.png"
				}
			}

			Column{
				Text {font.pixelSize: 20; font.family: "Arial"; text: firstName + " " + lastName}
				Text {font.pixelSize: 16; font.family: "Arial"; text: headline}
			}


		}
	}

}
