/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0


Flickable {
	id: root
	width: parent.width
	height: 180

	property string title
	signal clicked (string name)

	flickableDirection: Flickable.HorizontalFlick
	contentWidth: 100*8+(30*7)

	Row{
		anchors.verticalCenter: parent.verticalCenter
		anchors.verticalCenterOffset: -20
		spacing: 30

		Repeater{
			anchors.verticalCenter: parent.verticalCenter
			id: repeater
			model: 8
			delegate: ToolbarIcon{
				Connections{
					onClicked: root.clicked(name)
				}
				onClicked: root.title = title

				Component.onCompleted: {
					switch(index){
					case 0: {title = "Me"; name = "profile"; source = "qrc:///qml/images/home.png"};break
					case 1: {title = "Search"; name = "search"; source = "qrc:///qml/images/searchView.png"};break
					case 2: {title = "User"; name = "viewConnection"; source = "qrc:///qml/images/user.png"};break
					case 3: {title = "Mail"; name = "mail"; source = "qrc:///qml/images/email.png"};break
					case 4: {title = "Connections"; name = "connections"; source = "qrc:///qml/images/connections.png"};break
					case 5: {title = "News"; name = "news"; source = "qrc:///qml/images/news.png"};break
					default: {name = ""};break
					}
				}
			}
	}



	}


}
