/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0



Item {
	id: root
	width: parent.width; height: row.height

	signal clicked(string profileID)
//	property string website: websiteUrl

//	Component.onCompleted: {
//		if(websiteUrl.search("http") < 0){
//			website = "http://" + websiteUrl
//		}
//	}
	Row{
		id: row
		spacing: 10

		Image {
			id: image
			height:  80
			smooth: true
			width: height
			source: squareLogo ? squareLogo : (logoUrl ? logoUrl :"qrc:///qml/images/profile-picture.png" )


			MouseArea{
				anchors.fill: parent
				onClicked: {
					root.clicked(id)
				}
			}
		}

		Column{
			id: column
			width: root.width - image.width
			Text {font.pixelSize: 24; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: name}
			Text {font.pixelSize: 20; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: type}
			Text {font.pixelSize: 20; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: experience}
			Text {font.pixelSize: 20; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: location}

		}


	}



}



