/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "../components"

Item{
	id: root
	width: parent.width
	height: rootColumn.height

	property bool bookmarked: User.bookmarked(id) ? true : false

	signal bookmark(string id)
	signal unbookmark(string id)
//	signal finance(string tickerSymbol)
	signal news(string companyName)

	SystemPalette{id: palette}

	Column{
		id: rootColumn
		width: root.width
		spacing: 20



		Column{
			width: parent.width


			spacing: 20
			Image {
				id: image
				height: 100
				width: 200
				fillMode: Image.PreserveAspectFit
				source: logoUrl
				smooth: true
				anchors.horizontalCenter: parent.horizontalCenter
				Component.onCompleted: {
					if(!logoUrl)
						source = "qrc:///qml/images/profile-picture.png"
				}
			}
			//Text {font.pixelSize: 25; font.family: "Arial"; wrapMode: Text.Wrap;  color: palette.text; text: name; anchors.verticalCenter: parent.verticalCenter}





			Text {
				font.pixelSize: 20;
				font.family: "Arial";
				color: palette.text;
				text: '<a href="'+jobUrl+'">'+jobUrl+'</a>'
				onLinkActivated: Qt.openUrlExternally(link)
			}

			Text {
				font.pixelSize: 20;
				font.family: "Arial";
				wrapMode: Text.Wrap;
				width: parent.width-10;
				color: palette.text;
				text: "Type: "+ type
			}

			Text {
				font.pixelSize: 20;
				font.family: "Arial";
				wrapMode: Text.Wrap;
				width: parent.width-10;
				color: palette.text;
				text: "Experience: " + experience
			}

			Text {
				font.pixelSize: 20;
				font.family: "Arial";
				wrapMode: Text.Wrap;
				width: parent.width-10;
				color: palette.text;
				text:  location
			}



			Row{//two rows for buttons becuase the follow button grows large
				id: buttonRow
//				Button{
//					id: financeButton
//					enabled: ticker ? true : false
//					iconSource: "qrc:///qml/images/stock-small.png"
//					onClicked: root.finance(ticker)
//				}
//				Button{
//					id: newsButton
//					iconSource: "qrc:///qml/images/news-small.png"
//					onClicked: root.news(name)
//				}
			}

			Row{
				Button{
					id: bookmarkButton
					text: bookmarked ? "Bookmarked " + name : "Bookmark " + name
					//				   onClicked: following ? root.stopFollow(id) : root.follow(id) //mm uncomment this when xmlhttp delete is implemented
					onClicked: root.bookmark(id)
					iconSource: bookmarked ? "qrc:///qml/images/star-on.png" : "qrc:///qml/images/star-off.png"
					//				   Behavior on text { NumberAnimation{ duration: 250}}
				}
			}

		}



		Row{ //mm this text resizing does not seem to register to the parent row. The components underneath it don't get repositioned
			Text {font.pixelSize: 20; font.family: "Arial"; wrapMode: Text.Wrap; width: root.width-10; color: palette.text; text: description}

		}




	}



}
