/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0

Rectangle {
	id: button
	width: 40
	height: width
	color: "#32000000"
	radius: 5
	border.color: "#7e7e7e"

	MouseArea {
		id: mouse_area1
	   anchors.rightMargin: -30
	   anchors.leftMargin: -30
		anchors.fill: parent
		anchors.margins: -20
		onClicked: button.state = button.state === "" ? "down" : ""
	}

	 Image {
		 id: arrow
		 smooth: true
		 anchors.fill: parent
		 source: "qrc:///qml/images/arrow.png"
		 Behavior on rotation{NumberAnimation{duration:250}}
	 }


	 states: [
		 State {
			 name: "down"
			 PropertyChanges { target: arrow; rotation: 180}
		 }
	 ]
}
