/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0


Item {
	id: rootItem

	property string pageQuery : "/people-search"
	property string xml

	property string start: "0"
	property string count: "10"

	property Component delegate
	property Component customPageModel
	property alias	model: mainList.model

	anchors.fill: parent
	anchors.topMargin: borderHeight

	signal xmlSet
	signal xmlLoaded

	ListView{
		id: mainList

		header: headerComp
		clip: true
		spacing: 10
		anchors.fill: parent
		model: rootItem.model
		delegate: rootItem.delegate
	}

	/*
	  This model and component represent the page numbers displayed
	  along the top and bottom of the list.
	  */
	PageModel{
		id: pageModel
		query: rootItem.pageQuery
		xml: rootItem.xml
		onStatusChanged: {
			if(status === XmlListModel.Ready && xml){
				rootItem.xmlLoaded()
			}

		}
		onXmlChanged: rootItem.xmlSet()
	}

	Component{
		id: pageComp
		PageDelegate{
			onChangePage: {
				rootItem.start = start
				rootItem.count = count
			}
		}
	}
	Component{
		id: headerComp
		ListView{
			id: pages
			clip: true
			spacing: 5
			height: 80
			model: customPageModel ? customPageModel : pageModel
			anchors.left: parent.left
			anchors.right: parent.right
			orientation: ListView.Horizontal
			delegate: pageComp

		}
	}


}
