/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "selfConnections"
import "components"

Window {
	id: root
	busy: true
	borderTitle: "Connections"
	signal clicked(string xml)

	onProfileIDChanged: get(API.get_connections_by_id(profileID))
	onGetFinished: {
		model.xml = xml
		root.busy = false
	}


	property string profileID

	ListView{
		id: list
		clip: true
		spacing: 10
		anchors.fill: parent
		anchors.topMargin: borderHeight
		model:  model
		delegate: SelfConnectionsDelegate{
			onClicked: {
				var comp = Qt.createComponent("Profile.qml")
				var object = comp.createObject(root.parent)
				object.profileID = id
				object.caller = root
				root.state = "hidden"
			}
		}
	}


	SelfConnectionsModel{
		id: model
	}
}
