/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "news"

Window {
	id: root
	width: parent.width
	height: parent.height

	property string searchString

	onSearchStringChanged: {
		if(searchString){
			model.source = "http://news.google.com/news?pz=1&ned=us&hl=en&output=rss&q=" + searchString
			root.busy = true
		}
		else if(User.numFollowing()){
			model.source = User.getCompanyQuery()
			root.busy = true
		}

		else
			var obj = noFollows.createObject(root)
	}

	imgSource: "qrc:///qml/images/gnews.png"

	NewsModel{
		id: model
		onStatusChanged: {
			if(status === XmlListModel.Ready)
				root.busy = false
		}
	}

	ListView{
		anchors.fill: parent
		anchors.topMargin: borderHeight
		spacing: 20
		model: model
		delegate: NewsDelegate{
			width: root.width
		}
	}

	Component{
		id: noFollows
		Text {
			text: "You are not following any companies.\n\nYou can search for companies on the home page and follow them there"
			font.pixelSize: 24
			color: palette.text
			width: parent.width
			anchors.verticalCenter: parent.verticalCenter
			wrapMode: Text.Wrap
			horizontalAlignment: Text.AlignHCenter

			Image {
				source: "qrc:///qml/images/star-off.png"
				anchors.bottom: parent.top
				anchors.margins: 20
				anchors.horizontalCenter: parent.horizontalCenter
				smooth: true
				scale:  1.2
			}
		}
	}

}
