/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "jobBookmarks"
import "components"
import "common"

Window {
	id: root
	width: parent.width; height: parent.height
	borderTitle: "Bookmarked Jobs"

	onGetFinished: root.xml = xml
	Component.onCompleted: get(API.get_job_bookmarks(pagedList.start, pagedList.count))

	property string xml


PagedList{
	id: pagedList
	xml: root.xml
	anchors.topMargin: borderHeight
	onXmlSet: root.busy = true
	onXmlLoaded: root.busy = false
	pageQuery: "/job-bookmarks"
	model: model
	delegate: delegate
	Connections{
		onStartChanged: root.get(API.get_job_bookmarks(pagedList.start, pagedList.count))
	}
}



JobBookmarksModel{
	id: model
	xml: root.xml
}
Component{
	id: delegate
	JobBookmarksDelegate{
		onClicked: {
			var comp = Qt.createComponent("Job.qml")
			var object = comp.createObject(root.parent)
			object.profileID = profileID
			object.caller = root
			root.state = "hidden"
		}
	}
}





}
