/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/

#ifndef NOTIFIER_H
#define NOTIFIER_H

#include <QObject>
#include <string>
#include <stdlib.h>

class Notifier : public QObject
{
    Q_OBJECT
public:
	explicit Notifier(QObject *parent = 0){}
	Q_INVOKABLE void notify(QString notification){
#ifdef Q_WS_MAEMO_5
		QString s("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'"+notification+"'");
		system(s.toStdString().c_str());
#endif
	}
	Q_INVOKABLE void longNotify(QString notification){
#ifdef Q_WS_MAEMO_5
		QString str("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'"+notification+"' uint32:0 string:'OK'");
		system(str.toStdString().c_str());
#endif
	}
	Q_INVOKABLE void minimize(){
#ifdef Q_WS_MAEMO_5
		system("dbus-send --type=signal --session /com/nokia/hildon_desktop com.nokia.hildon_desktop.exit_app_view");
#endif
	}

signals:

public slots:

};

#endif // NOTIFIER_H
