#!/bin/sh
set -x

# Set the vars

FPC=fpcsrc
LAZARUS=lazarus
PPCARM=ppcarm
PRFX=~/laz-temp
FPC_INSTALL_DIR=fpcinst

function get_fpc {
#check if fpc source already downloaded
#could be commented while uploading to the autobuilder
if [ -f $PRFX/$FPC/Makefile ]
then
	echo "compiler installed"
else	
	if [ -d $PRFX ] 
	then
	    echo "$PRFX already exists"
	else
	    mkdir $PRFX
	    cp compiler/$PPCARM $PRFX/
	    cp t_linux.diff $PRFX/t_linux.diff
	fi 
  cd $PRFX
  echo "getting source from svn"
  svn checkout http://svn.freepascal.org/svn/fpc/trunk fpc
  mv fpc $FPC
fi  
}

function apply_patches {
  cd $PRFX
  echo "applying patches"
  patch -p1 $FPC/compiler/systems/t_linux.pas < $PRFX/t_linux.diff
  touch $FPC/compiler/utils/fpini.inc
  touch $FPC/utils/fpcmkcfg/fpccfg.inc
}

function compile {
  if [ -d $PRFX ] 
  then
    echo "$PRFX already exists"
  else
    mkdir $PRFX
  fi 


if [ -f $PRFX/fpcinst/bin/fpc ]
   then
	echo "compiler installed"
else	

  
  cd $PRFX
  chmod 777 $PPCARM
  cd $FPC
  echo "About to make all"
  make all PP=$PRFX/$PPCARM DATA2INC="$PRFX/$FPC/utils/data2inc" PREFIX=$PRFX/$FPC_INSTALL_DIR OPT="-dFPC_ARMEL -O- -dFPC_ABI_EABI -CfSOFT"
  echo "press enter"
  read LINE
  echo "About to make install"
  make install PP=$PRFX/$PPCARM  DATA2INC="$PRFX/$FPC/utils/data2inc"   PREFIX=$PRFX/$FPC_INSTALL_DIR OPT="-dFPC_ARMEL -O- -dFPC_ABI_EABI -CfSOFT"
  cd ..
  echo "Done"
fi  
}

function create_cfg_file {
  echo "config file setup"
  cp compiler/fpc.etc /etc/fpc.cfg
  cp compiler/fpc.usr ~/.fpc.cfg  
}

function make_fpc {
  echo "make fpc"
  create_cfg_file
  get_fpc
  apply_patches
  compile
}

function get_lazarus {
if [ -d $PRFX/lazarus/lcl ]
  then
     echo "lazarus downloaded"
  else     
  cd $PRFX
  echo "getting lazarus"
  svn co http://svn.freepascal.org/svn/lazarus/trunk lazarus  
  fi
}

#BEGIN
make_fpc
get_lazarus


