/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of lightmeter.

    lightmeter is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    lightmeter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with lightmeter.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QSettings>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent)
    : QDialog(parent), ui(new Ui::SettingsDialog) {
    ui->setupUi(this);
    QSettings cameraSettings("/opt/lightmeter/camera.conf", QSettings::NativeFormat);
    QSettings lensSettings("/opt/lightmeter/lens.conf", QSettings::NativeFormat);
    ui->cameraComboBox->addItems(cameraSettings.childGroups());
    ui->lensComboBox->addItems(lensSettings.childGroups());
    readSettings();
    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(writeSettings()));
}

SettingsDialog::~SettingsDialog() {
    delete ui;
}

void SettingsDialog::changeEvent(QEvent *e) {
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsDialog::readSettings() {
    QSettings settings;
    QString camera = settings.value("camera", QString()).toString();
    QString lens = settings.value("lens", QString()).toString();
    int index = ui->cameraComboBox->findText(camera);
    if(index != -1) {
        ui->cameraComboBox->setCurrentIndex(index);
    } else {
        index = ui->cameraComboBox->findText(QString("D80 0.3EV"));
        ui->cameraComboBox->setCurrentIndex(index);
    }
    index = ui->lensComboBox->findText(lens);
    if(index != -1) {
        ui->lensComboBox->setCurrentIndex(index);
    } else {
        index = ui->lensComboBox->findText(QString("Nikkor DX AF-S 16-85mm 1:3.5-5.6G ED VR 0.3EV"));
        ui->lensComboBox->setCurrentIndex(index);
    }
}

void SettingsDialog::writeSettings() {
    QSettings settings;
    settings.setValue("camera", ui->cameraComboBox->currentText());
    settings.setValue("lens", ui->lensComboBox->currentText());
}
