/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include "settingsdlg.h"


SettingsDlg::SettingsDlg(QWidget *parent) :
    QDialog(parent)
{
    this->setWindowTitle(QString::fromUtf8("Lựa Chọn"));

    buttonBox = new QDialogButtonBox(QDialogButtonBox::Save | QDialogButtonBox::Cancel);
    buttonBox->setOrientation(Qt::Vertical);
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    tabWidget = new QTabWidget;
    tabWidget ->addTab(new GeneralTab(), QString::fromUtf8("Hiển Thị "));
    tabWidget ->addTab(new ThemeTab(), QString::fromUtf8("Kiểu Mẫu Widget"));

    mainLayout = new QGridLayout(this);

    mainLayout->addWidget(tabWidget,0,0,1,1);
    mainLayout->addWidget(buttonBox,0,1,1,1);
\
    this->setLayout(mainLayout);

}

void SettingsDlg::showSettingsDialog(){
    this->show();
}

GeneralTab::GeneralTab(QWidget *parent)
     : QWidget(parent)
{
    mainLayout = new QVBoxLayout;
    setLayout(mainLayout);
}

ThemeTab::ThemeTab(QWidget *parent)
     : QWidget(parent)
{
    themes = new QListWidget(this);
    themes->addItem(new QListWidgetItem( QString::fromUtf8("Mặc định (344 x 200) pixel.")));
    themes->addItem(new QListWidgetItem( QString::fromUtf8("Lớn (430 x 500) pixel.")));
    mainLayout = new QVBoxLayout;
    mainLayout->addWidget(themes);
    setLayout(mainLayout);
}

