/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0
import "../DatePicker/component" as Comp

Item{
    id: item1
    BorderImage { anchors.centerIn: parent;source: "./img/titlebar.sci"; width: 344+2; height: 234+14; y: +7  }
    Rectangle {
        id: rectangle1
        x: 0
        y: -16
        anchors.centerIn: parent
        width:344
        height: 234
        color: "#19262b"
        radius: 8
        border.color: "#b57e8f"
        visible: true
        opacity:0.9



        Column {
            id: datePicker
            width: 260
            property int mDay: screen.curDay
            property int mMonth: screen.curMonth
            property int mYear: screen.curYear
            anchors.centerIn: parent

            Comp.DateReel {
                id: dateReel
                width: parent.width
            }}


        Button {
            id: button2
            x: 102
            anchors.right: parent.right; anchors.rightMargin: 102; y: 185; width: 140; height: 40
            text: "OK"
            visible: true
            onClicked: {

                LC.reset(datePicker.mDay,datePicker.mMonth,datePicker.mYear)
                screen.calculateLunar(datePicker.mDay,datePicker.mMonth,datePicker.mYear)
                screen.state="mainscreen"
                screen.refresh()
                maindatemodel.reset()
                txtDATEpv.currentIndex = datePicker.mDay-1;
                }
        }

        Button {
            id: button3
            x: 298
            y: 6
            width: 39
            height: 40
            text: "X"
            anchors.rightMargin: 56
            onClicked: {screen.state="mainscreen";screen.refresh();}
        }
    }

    function reset(){
        dateReel.day_reset()
                dateReel.month_reset()
                dateReel.year_reset()
    }

    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutBack } }
    ]
}
