/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/


#include <QtCore/QDateTime>
#include "lunarcalendar.h"

LunarCalendar::LunarCalendar(QObject *parent) :
    QObject(parent)
{
    this->curDayA =  QDateTime::currentDateTime().toString("d").toUInt();
    this->curMonthA = QDateTime::currentDateTime().toString("M").toUInt();
    this->curYearA = QDateTime::currentDateTime().toString("yyyy").toUInt();
}

/*
  Calendar
  */
QString LunarCalendar::nextDay(){
    int value = this->curDayA+1;
    int days = calDays(this->curMonthA,this->curYearA);
    if (value>days){
        value = 1;
        this->curMonthA++;
        if (this->curMonthA > 12){
            this->curMonthA = 1;
            this->curYearA++;
        }
    }
    this->curDayA=value;
    return QString::number(value);
}

QString LunarCalendar::prevDay(){
    int value = this->curDayA-1;
    if(!value){
        this->curMonthA--;
        if (!this->curMonthA){
            this->curMonthA = 12;
            this->curYearA--;
        }
        value = calDays( this->curMonthA,this->curYearA);
    }
     this->curDayA=value;
    return QString::number(value);
}

int LunarCalendar::curDay(){
    return this->curDayA;
}

int LunarCalendar::curMonth(){
    return this->curMonthA;
}

int LunarCalendar::curYear(){
    return this->curYearA;
}

int LunarCalendar::curHour(){
    return QDateTime::currentDateTime().toString("H").toUInt();
}

int LunarCalendar::curMinute(){
    return QDateTime::currentDateTime().toString("m").toUInt();
}

void LunarCalendar::reset(int D, int M, int Y){
 this->curDayA = D;
    this->curMonthA = M;
    this->curYearA = Y;
}


int LunarCalendar::calDays(int Month, int Year){
    if (Month == 4 || Month == 6 || Month == 9 || Month == 11)
        return 30;
    else
    if (Month == 2) {
        bool isLeapYear = (Year % 4 == 0 && Year % 100 != 0) || (Year % 400 == 0);
        if (isLeapYear == 0)
            return 28;
        else
            return 29;
    }
    else
    return 31;
}

