/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

Item{

Rectangle {
    id: rectangle1
    anchors.fill: parent; anchors.bottomMargin: 0
    visible: true
    opacity:0.9
    color:"white"

    ListModel{
        id:img

        function list(){
            while(img.count>0) img.remove(img.count-1);
            var limg = Controller.getImages("/home/cuongle");
            for (var i=0;i<limg.length;i++)
                append({name:limg[i]})
        }
    }

    GridView {
        anchors.fill: parent;anchors.topMargin: 35;anchors.leftMargin: 5;anchors.rightMargin: 5;anchors.bottomMargin: 12
        model: img
        delegate: Column {
            Image { source:  "file:"+name; anchors.horizontalCenter: parent.horizontalCenter; width:100;height:100; }
            Text { text: "-"; anchors.horizontalCenter: parent.horizontalCenter }
        }
    }


}

ToolBar { id: toolBar; height: 50;
    y: screen.height-78
    width: parent.width;
    button1Label: "Đồng Ý"
    button2Label: "Hủy Bỏ"
    onButton1Clicked:
    {
        screen.state="menuscreen"
    }
    onButton2Clicked: {
        screen.state="menuscreen"
    }
}

function refresh(){
    img.list();
}

}
