/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0
import "amlich-hnd.js" as AmLich
import "amlich-aa98.js" as AmLich98

import "Settings.js" as Settings
import "Themes.js" as Themes
import "CacNgayLeTrongNam.js" as CNLTN

Item {
     id: screen
     width: 480
     height: 800

     property int curDay: LC.curDay()
     property int curMonth: LC.curMonth()
     property int curYear: LC.curYear()

     property int initcurDay: LC.curDay()
     property int initcurMonth: LC.curMonth()
     property int initcurYear:LC.curYear()

     property int lunarDay: AmLich.getLunarDate(curDay,curMonth,curYear).day
     property int lunarMonth: AmLich.getLunarDate(curDay,curMonth,curYear).month
     property string lunarYear: AmLich.getCanChi(AmLich.getLunarDate(curDay,curMonth,curYear))[2]

     property int lunarYearInt : AmLich.getLunarDate(curDay,curMonth,curYear).year
     property int jd : AmLich.getLunarDate(curDay,curMonth,curYear).jd
     property string lunarGioHoangDao : AmLich.getGioHoangDao(jd)

     property string lunarDayCanChi : AmLich.getCanChi(AmLich.getLunarDate(curDay,curMonth,curYear))[0]
     property string lunarMonthCanChi : AmLich.getCanChi(AmLich.getLunarDate(curDay,curMonth,curYear))[1]

     property string day_info : CNLTN.get(screen)
     property bool is_holiday : CNLTN.is_holiday(screen.curDay,screen.curMonth, screen.curYear, screen.lunarDay, screen.lunarMonth)

     state:"mainscreen"

     Loader {
         id: theme_manager
         property alias theme: theme_manager.item
         source: Themes.default_theme()
     }

     Rectangle {
         id: background
         anchors.fill: parent
         color: "#343434"

         state:"jumptodate"
         Image {
             source: theme_manager.theme.background_image; fillMode: Image.Stretch; anchors.fill: parent; opacity: 0.3
         }


         MouseArea {
             id:mouseareaMM
             property int  xfrom: 0
             property int  yfrom: 0

             property int fixed: 40
             property int rise: 0

             anchors.fill: parent;anchors.topMargin: 60;anchors.bottomMargin:60;

             onPressAndHold:{
                 if (Settings.pressandhold()==1){
                    screen.state="xemngaytotxauhoangdao"
                 }
             }

             onDoubleClicked:{

                 if (Settings.doubleclicked()==1){
                     screen.state="datetimedialog"
                 }
             }
         }

         Text {
             id: txtDMY
             x: 140
             y: 77
             width: 80
             height: 20
             color: "#29d999"
             text: "Tháng "+screen.curMonth+" Năm "+screen.curYear
             anchors.horizontalCenter: parent.horizontalCenter
             font.bold: true
             font.family: "Tahoma"
             smooth: true
             horizontalAlignment: Text.AlignHCenter
             font.pixelSize: 28
         }

         //------------------------------------------------

                  Rectangle {
                      id:reelx
                      width: 300
                      height: 100
                      y: 116
                      anchors.horizontalCenter: parent.horizontalCenter
                      property int index: 0
                      onIndexChanged: txtDATEpv.currentIndex = reelx.index
                      color: "transparent"
                      Component {
                          id: delegate
                          Column {
                              id: wrapper
                              Text {
                                  id: nameText
                                  text: name
                                  font.bold: true
                                  font.pixelSize: wrapper.PathView.isCurrentItem ? 80 : 40
                                  color: {
                                      if (wrapper.PathView.isCurrentItem){
                                          var stemp = AmLich98.convertSolar2Lunar(txtDATEpv.currentIndex+1,curMonth,curYear,7);
                                          if (CNLTN.is_holiday(txtDATEpv.currentIndex+1,curMonth, stemp[0], stemp[1])){
                                              return theme_manager.theme.markdate.holidays;
                                          }else{
                                          var mark_day = (AmLich.getLunarDate(txtDATEpv.currentIndex+1,curMonth,curYear).jd+1)%7;
                                          if (mark_day === 0) //sunday
                                              return theme_manager.theme.markdate.sunday;
                                          if (mark_day == 6) //saturday
                                              return theme_manager.theme.markdate.saturday;
                                          else
                                              return  theme_manager.theme.markdate.otherday_selected;
                                          }
                                      }
                                      else
                                          return theme_manager.theme.markdate.otherday;
                                    }
                              }
                          }
                      }

                      PathView {
                          id:txtDATEpv
                          anchors.fill: parent
                          model: maindatemodel
                          delegate: delegate
                          pathItemCount: 3
                          clip: true
                          preferredHighlightBegin: 0.5
                          preferredHighlightEnd: 0.5
                          highlightRangeMode: PathView.StrictlyEnforceRange
                          focus: true
                          path: Path {
                              startX: 0
                              startY: 50
                              PathLine {x: reelx.width; y: 50}
                          }
                          onMovementEnded: {
                              calculateLunar(txtDATEpv.currentIndex+1, LC.curMonth(), LC.curYear())
                          }
                      }
                  }
                  ListModel {
                      id:maindatemodel

                      function reset(){
                          while(maindatemodel.count>0){
                              try{maindatemodel.remove(maindatemodel.count-1)}catch(e){}
                          }

                          for(var i=1;i<=LC.calDays(screen.curMonth,screen.curYear);i++)
                              append({name:i})
                          reelx.index = screen.curDay -1
                      }
                  }

         //-------------------------------------------------
                  Component.onCompleted: {
                     maindatemodel.reset()
                  }

         Text {
             id: txtTHU
             x: 151
             y: 210
             width: 80
             height: 20
             color: "#f0f0f5"
             text: AmLich.getTHU(screen.jd)
             horizontalAlignment: Text.AlignHCenter
             anchors.horizontalCenter: parent.horizontalCenter
             opacity: 0.6
             font.bold: true
             font.pixelSize: 30
         }

         Text {
             id: txtInfo
             x: 151
             y: (screen.is_holiday ? 270 : 250)
             width: 80
             height: 20
             color: (screen.is_holiday ? theme_manager.theme.markdate.holidays : theme_manager.theme.markdate.not_holidays)
             text: screen.day_info
             horizontalAlignment: Text.AlignHCenter
             anchors.horizontalCenter: parent.horizontalCenter
             opacity: 0.6
             font.bold: (screen.is_holiday ? true : false)
             font.pixelSize: (screen.is_holiday ? 25 : 20)
         }

         Text {

             id: txtDAYAmLich
             x: 151
             y: 330
             width: 80
             height: 20
             color: "#f0f0f5"
             text: "Ngày <span style='color:#C0C0C0;'>"+screen.lunarDay+" ("+screen.lunarDayCanChi+")</span><br>Tháng <span style='color:#C0C0C0;'>"+screen.lunarMonth+" ("+screen.lunarMonthCanChi+")</span><br>Năm <span style='color:#C0C0C0;'>"+screen.lunarYearInt+" ("+screen.lunarYear+")</span>"
             horizontalAlignment: Text.AlignHCenter
             anchors.horizontalCenter: parent.horizontalCenter
             opacity: 0.6
             font.bold: true
             font.pixelSize: 25
         }


         MenuScreen{
             id: menuScreen
             state:"menuscreen"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }

         OptionsScreen{
             id: optionsScreen
             state:"optionsscreen"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }

         ChangeTheme{
             id: changeTheme
             state:"changetheme"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }

         XemNgayTotXauHoangDao{
             id: xntxhdScreen
             state:"xemngaytotxauhoangdao"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }

         DateTimeDialog{
             id: datetimeDialog
             state:"datetimedialog"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }

         AmDateTimeDialog{
             id: amdatetimeDialog
             state:"amdatetimedialog"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }

         FullMonth{
             id: fullmonthDialog
             state:"xemtheothang"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }

         NoFeatureDialog{
             id: nofeatureDialog
             state:"nofeaturedialog"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }


         About{
             id: aboutDialog
             state:"aboutdialog"
             anchors.verticalCenter: parent.verticalCenter
             width: parent.width; height: parent.height-60;
             x: -(screen.width * 1.5)
         }


         MultiTitleBar { id: titleBar; width: parent.width }
         ToolBar { id: toolBar; height: 50;
             y: screen.height - 48
             width: parent.width; opacity: 0.9
             button1Label: "Menu"
             button2Label: "Lựa Chọn"
             onButton1Clicked:
             {
                 screen.state="menuscreen"
             }
             onButton2Clicked: {
                 screen.state="optionsscreen"
             }
         }
     }

     states: [
         State {
             name: "menuscreen";
             PropertyChanges { target: menuScreen; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
                          PropertyChanges { target: mouseareaMM;enabled:false }

         },
         State {
             name: "optionsscreen";
             PropertyChanges { target: optionsScreen; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
                          PropertyChanges { target: mouseareaMM;enabled:false }

         },
         State {
             name: "changetheme";
             PropertyChanges { target: changeTheme; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
                          PropertyChanges { target: mouseareaMM;enabled:false }

         },
         State {
             name: "xemngaytotxauhoangdao";
             PropertyChanges { target: xntxhdScreen; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
             PropertyChanges { target: mouseareaMM;enabled:false }

             StateChangeScript {
                 script:{
                     xntxhdScreen.reset()
                 }
                }

         },
         State {
             name: "datetimedialog";
             PropertyChanges { target: datetimeDialog; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
             PropertyChanges { target: mouseareaMM;enabled:false }
                                                                 PropertyChanges { target: reelx;enabled:false }
             StateChangeScript {
                 script:{
                     datetimeDialog.reset()
                 }
                }
         },
         State {
             name: "amdatetimedialog";
             PropertyChanges { target: amdatetimeDialog; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
             PropertyChanges { target: mouseareaMM;enabled:false }
                                                                 PropertyChanges { target: reelx;enabled:false }
             StateChangeScript {
                 script:{
                     amdatetimeDialog.reset()
                 }
                }
         },
         State {
             name: "nofeaturedialog";
             PropertyChanges { target: nofeatureDialog; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
             PropertyChanges { target: mouseareaMM;enabled:false }
                                                                 PropertyChanges { target: reelx;enabled:false }
         },
         State {
             name: "aboutdialog";
             PropertyChanges { target: aboutDialog; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
             PropertyChanges { target: mouseareaMM;enabled:false }
         },
         State {
             name: "xemtheothang";
             PropertyChanges { target: fullmonthDialog; x: 0; focus:true}
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
             StateChangeScript {
                 script:{
                     fullmonthDialog.reset()
                 }
                }
             PropertyChanges { target: mouseareaMM;enabled:false }
         }
     ]

     transitions: [
         Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutBack } }
     ]


     function lunarTietKhi(){
         return AmLich.TIETKHI[AmLich.getSunLongitude(screen.jd+1,7.0)];
     }


     function calculateLunar(D,M,Y){
         screen.curDay =D
         screen.curMonth = M
         screen.curYear = Y
         screen.lunarDay = AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear).day
         screen.lunarMonth = AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear).month
         screen.lunarYearInt = AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear).year
         screen.lunarYear = AmLich.getCanChi(AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear))[2]//AmLich.getYearCanChi(screen.curYear)
         screen.jd = AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear).jd
         screen.lunarGioHoangDao = AmLich.getGioHoangDao(screen.jd)

         screen.lunarDayCanChi = AmLich.getCanChi(AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear))[0]
         screen.lunarMonthCanChi = AmLich.getCanChi(AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear))[1]

     }

     function reset(){
         calculateLunar(initcurDay, initcurMonth, initcurYear)
         LC.reset(initcurDay, initcurMonth, initcurYear)
         screen.state="mainscreen"
         maindatemodel.reset()
         txtDATEpv.currentIndex = initcurDay-1;
     }

     function refresh(){
     }

     Component.onCompleted: {

     }
}
