import QtQuick 1.0

Item {
    id: container

    // Year item dimensions
    property int yearWidth: (width-2*spacing)*0.4
    property int yearHeight: height
    // Month item dimensions
    property int monthWidth: (width-2*spacing)*0.3
    property int monthHeight: height
    // Day item dimensions
    property int dayWidth: (width-2*spacing)*0.3
    property int dayHeight: height
    // Font properties
    property string fontName: 'Helvetica'
    property int fontSize: 22
    property color fontColor: "#666666"
    // Spacing between items
    property int spacing: 8

    property Component itemBackground: Component {
        BorderImage {
            border { top: 8; bottom: 8; left: 8; right: 8 }
            source:  theme_manager.theme.datepicker.button
        }
    }
    property Component itemBackgroundPressed: Component {
        BorderImage {
            border { top: 8; bottom: 8; left: 8; right: 8 }
            source: theme_manager.theme.datepicker.button_pressed
        }
    }

    width: 240
    height:  90

    Component.onCompleted: {
    }

    Component {
        id: dayDelegate
        Button {
            width: container.dayWidth
            height: container.dayHeight
            text: number
            fontColor: container.fontColor
            fontName: container.fontName
            fontSize: container.fontSize
            bg: itemBackground
            bgPressed: itemBackgroundPressed
             opacity: (index+1 < days.start || index+1 > days.end) ? 0.5 : 1.0
        }
    }

    Component {
        id: monthDelegate
        Button {
            width: container.monthWidth
            height: container.monthHeight
            text: number
            fontColor: container.fontColor
            fontName: container.fontName
            fontSize: container.fontSize
            bg: itemBackground
            bgPressed: itemBackgroundPressed

        }
    }

    Component {
        id: yearDelegate
        Button {
            width: container.yearWidth
            height: container.yearHeight
            text: number
            fontColor: container.fontColor
            fontName: container.fontName
            fontSize: container.fontSize
            bg: itemBackground
            bgPressed: itemBackgroundPressed
        }
    }


    Row {
        id: reels
        spacing: container.spacing

        Reel {
            id: day
            width: container.dayWidth
            height: container.dayHeight
            model: days
            delegate:  dayDelegate
            autoClose: false

            function mouseoff(){
                if (day.index+1 < days.start) day.index = days.start-1;
                else if (day.index+1 > days.end ) day.index = days.end-1;


                datePicker.mDay = day.index + 1;
                datePicker.mMonth = month.index + 1;
                datePicker.mYear = year.index + 1900;
            }
        }

        Reel {
            id: month
            width: container.monthWidth
            height: container.monthHeight
            model: months
            delegate: monthDelegate
            autoClose: false

            function mouseoff(){
                days.reset()
                datePicker.mDay = day.index + 1;
                datePicker.mMonth = month.index + 1;
                datePicker.mYear = year.index + 1900;
            }
        }

        Reel {
            id: year
            width: container.yearWidth
            height: container.yearHeight
            model: years
            delegate: yearDelegate
            autoClose: false

            function mouseoff(){
                 days.reset()
                datePicker.mDay = day.index + 1;
                datePicker.mMonth = month.index + 1;
                datePicker.mYear = year.index + 1900;
            }
        }

    }


    ListModel {
        id: days

        property int start: 1
        property int end: 31

        Component.onCompleted: {
            appends()
            day.index = screen.curDay - 1
            end = LC.calDays(month.index+1,year.index+1900);
        }

        function reset(){
            var howmanydays =  LC.calDays(month.index+1,year.index+1900);
            end = howmanydays;

            if (day.index+1 < days.start) day.index = days.start-1;
            else if (day.index+1 > days.end ) day.index = days.end-1;
        }

        function appends(){
            for(var j=1;j<=31;j++){
                if (j<=9)
                   append({number:"0"+j})
                else
                   append({number:j})
            }
        }

        function change(){
           day.index = screen.curDay-1;
        }
    }

    ListModel{
        id: months
        Component.onCompleted: {
            for(var j=1;j<=12;j++){
                if (j<=9)
                   append({number:"0"+j})
                else
                   append({number:j})
            }
            month.index = screen.curMonth - 1
        }

        function change(){
             month.index = screen.curMonth - 1;
        }
    }

    ListModel{
        id: years
        Component.onCompleted: {
            for(var i=1900;i<2099;i++){
                append({number:i})
            }
            year.index = screen.curYear - 1900
        }

        function change(){
              year.index = screen.curYear - 1900
        }
    }

    function day_reset(){
         datePicker.mDay = screen.curDay
        days.change()
    }

    function month_reset(){
                 datePicker.mMonth = screen.curMonth
        months.change()
    }

    function year_reset(){
        datePicker.mYear = screen.curYear
        years.change()
    }


}
