/*
 * requests.cpp -- Manage all network requests
 *
 * Copyright (C) 2010 Andrea Grandi
 * Authors: Andrea Grandi <a.grandi@gmail.com>
 *
 * This file is part of LastGo and is published under the GNU GPLv2
 * See the README file for more details.
 */

#include "requests.h"
#include <QDebug>

Requests::Requests(QObject *parent) :
    QObject(parent)
{
    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(apiRequestReplied(QNetworkReply*)));
}

void Requests::apiRequest(QString url)
{
    QNetworkRequest request;
    request.setUrl(url);
    request.setRawHeader("User-Agent", "LastGo 1.0");
    manager->get(request);
}

void Requests::apiRequestPost(QString url, QByteArray params)
{
    QNetworkRequest request;
    request.setUrl(url);
    request.setRawHeader("User-Agent", "LastGo 1.0");
    manager->post(request, params);
}

void Requests::apiRequestReplied(QNetworkReply *reply)
{
    QByteArray data = reply->readAll();
    emit dataAvailable(QString::fromUtf8(data));
}
