#ifndef REQUESTS_H
#define REQUESTS_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QMap>

#define LASTFM_BASE_URL "http://ws.audioscrobbler.com/2.0/"

class Requests : public QObject
{
    Q_OBJECT
public:
    explicit Requests(QObject *parent = 0);
    void apiRequest(QString url);
    void apiRequestPost(QString url, QByteArray params);

private:
    QNetworkAccessManager *manager;
    QNetworkReply *reply;

signals:
    void dataAvailable(QString value);

public slots:

private slots:
    void apiRequestReplied(QNetworkReply *reply);

};

#endif // REQUESTS_H
