#include "apiclient.h"
#include <QXmlStreamReader>
#include <QDomDocument>
#include <QDebug>
#include <QMap>

ApiClient::ApiClient(QString key, QString secret, QObject *parent) :
    QObject(parent)
{
    api_key = key;
    api_secret = secret;
}

void ApiClient::authGetMobileSession(QString username, QString password)
{
    Utils *u = new Utils();

    QString token = u->getAuthToken(username, password);

    QMap<QString, QString> params;
    params["username"] = username;
    params["authToken"] = token;
    params["api_key"] = api_key;
    params["method"] = "auth.getMobileSession";

    QString signature = u->buildSignature(params, api_secret);
    params["api_sig"] = signature;

    QString api_url = u->buildApiUrl(LASTFM_BASE_URL, params);

    Requests *r = new Requests(this);
    connect(r, SIGNAL(dataAvailable(QString)), this, SLOT(authGetMobileSessionReply(QString)));
    r->apiRequest(api_url);
}

void ApiClient::authGetMobileSessionReply(QString data)
{
    QXmlStreamReader xml;
    xml.addData(data);

    QMap<QString, QString> response;
    QString status;

    while (!xml.atEnd())
    {
        xml.readNext();

        if (xml.isStartElement())
        {
            if(xml.name() == "lfm")
            {
                status = xml.attributes().value("status").toString();
                response["status"] = status;
            }
            else
            {
                if(status == "ok")
                {
                    if(xml.name() == "name")
                        response[xml.name().toString()] = xml.readElementText();
                    if(xml.name() == "key")
                        response[xml.name().toString()] = xml.readElementText();
                    if(xml.name() == "subscriber")
                        response[xml.name().toString()] = xml.readElementText();
                }
                else if(status == "failed")
                {
                    if(xml.name() == "error")
                    {
                        response[xml.name().toString()] = xml.attributes().value("code").toString();
                        response["message"] = xml.readElementText();
                    }
                }
            }
        }
    }

    emit authGetMobileSessionData(response);
}

void ApiClient::userShout(QString user, QString message, QString sk)
{
    Utils *u = new Utils();

    QMap<QString, QString> params;
    params["user"] = user;
    params["message"] = message;
    params["method"] = "user.shout";
    params["api_key"] = api_key;
    params["sk"] = sk;

    QString signature = u->buildSignature(params, api_secret);
    params["api_sig"] = signature;

    QByteArray post_params = u->buildPostParameters(params);

    Requests *r = new Requests(this);
    connect(r, SIGNAL(dataAvailable(QString)), this, SLOT(userShoutReply(QString)));
    r->apiRequestPost(LASTFM_BASE_URL, post_params);
}

void ApiClient::userShoutReply(QString data)
{
    QXmlStreamReader xml;
    xml.addData(data);

    QMap<QString, QString> response;
    QString status;

    while (!xml.atEnd())
    {
        xml.readNext();

        if (xml.isStartElement())
        {
            if(xml.name() == "lfm")
            {
                status = xml.attributes().value("status").toString();
                response["status"] = status;
            }
            else
            {
                if(status == "failed")
                {
                    if(xml.name() == "error")
                    {
                        response[xml.name().toString()] = xml.attributes().value("code").toString();
                        response["message"] = xml.readElementText();
                    }
                }
            }
        }
    }

    emit userShoutData(response);
}

void ApiClient::radioTune(QString station, QString sk)
{
    Utils *u = new Utils();

    QMap<QString, QString> params;
    params["station"] = station;
    params["method"] = "radio.tune";
    params["api_key"] = api_key;
    params["sk"] = sk;

    QString signature = u->buildSignature(params, api_secret);
    params["api_sig"] = signature;

    QByteArray post_params = u->buildPostParameters(params);

    Requests *r = new Requests(this);
    connect(r, SIGNAL(dataAvailable(QString)), this, SLOT(radioTuneReply(QString)));
    r->apiRequestPost(LASTFM_BASE_URL, post_params);
}

void ApiClient::radioTuneReply(QString data)
{
    QXmlStreamReader xml;
    xml.addData(data);

    QMap<QString, QString> response;
    QString status;

    while (!xml.atEnd())
    {
        xml.readNext();

        if (xml.isStartElement())
        {
            if(xml.name() == "lfm")
            {
                status = xml.attributes().value("status").toString();
                response["status"] = status;
            }
            else
            {
                if(status == "ok")
                {
                    if(xml.name() == "type")
                        response[xml.name().toString()] = xml.readElementText();
                    if(xml.name() == "name")
                        response[xml.name().toString()] = xml.readElementText();
                    if(xml.name() == "url")
                        response[xml.name().toString()] = xml.readElementText();
                    if(xml.name() == "supportsdiscovery")
                        response[xml.name().toString()] = xml.readElementText();
                }
                else if(status == "failed")
                {
                    if(xml.name() == "error")
                    {
                        response[xml.name().toString()] = xml.attributes().value("code").toString();
                        response["message"] = xml.readElementText();
                    }
                }
            }
        }
    }

    emit radioTuneData(response);
}

void ApiClient::radioGetPlaylist(QString sk)
{
    Utils *u = new Utils();

    QMap<QString, QString> params;
    params["method"] = "radio.getplaylist";
    params["api_key"] = api_key;
    params["sk"] = sk;

    QString signature = u->buildSignature(params, api_secret);
    params["api_sig"] = signature;

    QString api_url = u->buildApiUrl(LASTFM_BASE_URL, params);

    Requests *r = new Requests(this);
    connect(r, SIGNAL(dataAvailable(QString)), this, SLOT(radioGetPlaylistReply(QString)));
    r->apiRequest(api_url);
}

void ApiClient::radioGetPlaylistReply(QString data)
{
    QDomDocument doc("Playlist");
    doc.setContent(data.toUtf8());

    QDomElement elem = doc.documentElement();
    QString status = elem.attribute("status");

    QList<LastfmTrack*> track_list;

    if(status == "ok")
    {
        QDomNodeList tracks = elem.elementsByTagName("playlist").
                              at(0).toElement().elementsByTagName("trackList").
                              at(0).toElement().elementsByTagName("track");

        qDebug() << elem.elementsByTagName("playlist").at(0).toElement().elementsByTagName("title").at(0).toElement().text();

        for(int i = 0; i < tracks.count(); i++)
        {
            LastfmTrack *track = new LastfmTrack();

            track->Location = tracks.at(i).toElement().elementsByTagName("location").at(0).toElement().text();
            track->Title = tracks.at(i).toElement().elementsByTagName("title").at(0).toElement().text();
            track->Identifier = tracks.at(i).toElement().elementsByTagName("identifier").at(0).toElement().text();
            track->Album = tracks.at(i).toElement().elementsByTagName("album").at(0).toElement().text();
            track->Creator = tracks.at(i).toElement().elementsByTagName("creator").at(0).toElement().text();
            track->Duration = tracks.at(i).toElement().elementsByTagName("duration").at(0).toElement().text();
            track->ArtistPage = tracks.at(i).toElement().elementsByTagName("artistpage").at(0).toElement().text();
            track->AlbumPage = tracks.at(i).toElement().elementsByTagName("albumpage").at(0).toElement().text();
            track->TrackPage = tracks.at(i).toElement().elementsByTagName("trackpage").at(0).toElement().text();
            track->Image = tracks.at(i).toElement().elementsByTagName("image").at(0).toElement().text();

            track_list.append(track);
        }
    }

    emit radioGetPlaylistData(track_list);
}
