#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include <QSettings>

SettingsDialog::SettingsDialog(LastGoWH *mainwindow, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    mwindow = mainwindow;
    connect(ui->saveButton, SIGNAL(clicked()), this, SLOT(saveSettings()));
    loadSettings();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::saveSettings()
{
    QSettings settings("LastGo", "LastGo");
    settings.setValue("username", ui->usernameText->text());
    settings.setValue("password", ui->passwordText->text());

    mwindow->setUsername(settings.value("username").toString());
    mwindow->setPassword(settings.value("password").toString());

    this->close();
}

void SettingsDialog::loadSettings()
{
    QSettings settings("LastGo", "LastGo");
    ui->usernameText->setText(settings.value("username").toString());
    ui->passwordText->setText(settings.value("password").toString());
}
