#ifndef VKB_H
#define VKB_H

#include <QWidget>
QT_FORWARD_DECLARE_CLASS(QPushButton)

class VKB : public QWidget
{
    Q_OBJECT
public:
    explicit VKB(QWidget *parent = 0);
    ~VKB();
signals:
    void VKBButtonClicked(QString value);
    void openButtonClicked();
    void saveButtonClicked();
    void copyButtonClicked();
    void pasteButtonClicked();
    void fwButtonClicked();
    void bwButtonClicked();
    void bspaceButtonClicked();

public slots:

private:
    QWidget* createVKB(const unsigned short  keys[3][10]);
    void createToolBar();

    QWidget *mvkb;  //vkb first page
    QWidget *msvkb;  //vkb after shift button
    QWidget *mtbar;  //toolbar
    QFont *mUGFont;  //font

    QPushButton *mOpen;
    QPushButton *mSave;
    QPushButton *mCopy;
    QPushButton *mPaste;
    QPushButton *mShift;
    QPushButton *mFW;
    QPushButton *mSpace;
    QPushButton *mBW;
    QPushButton *mEnter;
    QPushButton *mBSpace;

    bool mShiftToggled;
private slots:
    void keyClicked();
    void shiftButtonClicked();
    void spaceButtonClicked();
    void enterButtonClicked();
};

#endif // VKB_H
