#include <QtGui/QApplication>
#include <QFontDatabase>
#include <QFile>
#include <QByteArray>
#include <QFont>
#include <QDebug>
#include "kumushedit.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    QFile fontFile(":/ttf/UyghurEditRiwaj.ttf");
    fontFile.open(QIODevice::ReadOnly);
    QByteArray fontData = fontFile.QIODevice::readAll();
    int rv = QFontDatabase::addApplicationFontFromData(fontData);
    if (rv == -1) {
        qDebug()<<"Failed to load font file!\n";
    } else {
        QFont ugFont("UyghurEdit Riwaj");
        QApplication::setFont(ugFont, "QPushButton");
        qDebug()<<QFontDatabase::applicationFontFamilies(rv);
    }

    KumushEdit w;
#if defined(Q_OS_SYMBIAN)
    w.showMaximized();
#else
    w.show();
#endif
    return a.exec();
}
