/* This file is part of the KDE project
 * Copyright ( C ) 2007 Thorsten Zachmann <zachmann@kde.org>
 * Copyright (C) 2010 Benjamin Port <port.benjamin@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (  at your option ) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "KPrShapeManagerAnimationStrategy.h"

#include <QPainter>
#include <KoShape.h>
#include <KoShapeManager.h>
#include <KoPAPageBase.h>

#include "KPrShapeAnimations.h"
#include "KPrPlaceholderShape.h"
#include "KPrAnimationDirector.h"
#include "KPrPageSelectStrategyBase.h"
#include "kdebug.h"

KPrShapeManagerAnimationStrategy::KPrShapeManagerAnimationStrategy( KoShapeManager * shapeManager, KPrAnimationDirector * animationDirector,
                                                                    KPrPageSelectStrategyBase * strategy )
: KoShapeManagerPaintingStrategy( shapeManager )
, m_animationDirector( animationDirector )
, m_strategy( strategy )
{
}

KPrShapeManagerAnimationStrategy::~KPrShapeManagerAnimationStrategy()
{
    delete m_strategy;
}

void KPrShapeManagerAnimationStrategy::paint( KoShape * shape, QPainter &painter, const KoViewConverter &converter, bool forPrint )
{
    if ( ! dynamic_cast<KPrPlaceholderShape *>( shape ) && m_strategy->page()->displayShape( shape ) ) {
        if ( m_animationDirector->shapeShown( shape ) ) {

            qreal zoom;
            converter.zoom(&zoom, &zoom);
            painter.save();
            QTransform animationTransform = m_animationDirector->shapeTransform(shape);
            animationTransform.translate(animationTransform.dx() * (zoom - 1), animationTransform.dy() * zoom);
            QTransform transform(painter.matrix() * shape->absoluteTransformation( &converter ));
            transform *= animationTransform;

            painter.setTransform(transform);
            // paint shape
            shapeManager()->paintShape( shape, painter, converter, forPrint );
            painter.restore();  // for the transform
        }
    }
}

void KPrShapeManagerAnimationStrategy::adapt( KoShape * shape, QRectF & rect )
{
}
