#include <kdialog.h>
#include <klocale.h>

#ifndef UI_XSLTDIALOG_H
#define UI_XSLTDIALOG_H

#include <qvariant.h>


#include <Qt3Support/Q3GroupBox>
#include <Qt3Support/Q3ListBox>
#include <Qt3Support/Q3MimeSourceFactory>
#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QComboBox>
#include <QtGui/QDialog>
#include <QtGui/QHBoxLayout>
#include <QtGui/QHeaderView>
#include <QtGui/QPushButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QVBoxLayout>

QT_BEGIN_NAMESPACE

class Ui_XSLTDialog
{
public:
    QVBoxLayout *vboxLayout;
    Q3GroupBox *GroupBox1;
    QVBoxLayout *vboxLayout1;
    Q3ListBox *xsltList;
    Q3GroupBox *GroupBox2;
    QHBoxLayout *hboxLayout;
    QComboBox *recentBox;
    QSpacerItem *Spacer2;
    QPushButton *chooseBtn;
    QHBoxLayout *hboxLayout1;
    QSpacerItem *Spacer57;
    QPushButton *OkBtn;
    QPushButton *CancelBtn;

    void setupUi(QDialog *XSLTDialog)
    {
        if (XSLTDialog->objectName().isEmpty())
            XSLTDialog->setObjectName(QString::fromUtf8("XSLTDialog"));
        XSLTDialog->resize(373, 389);
        XSLTDialog->setSizeGripEnabled(false);
        vboxLayout = new QVBoxLayout(XSLTDialog);
        vboxLayout->setSpacing(6);
        vboxLayout->setMargin(11);
        vboxLayout->setObjectName(QString::fromUtf8("vboxLayout"));
        GroupBox1 = new Q3GroupBox(XSLTDialog);
        GroupBox1->setObjectName(QString::fromUtf8("GroupBox1"));
        GroupBox1->setColumnLayout(0, Qt::Vertical);
        GroupBox1->layout()->setSpacing(6);
        GroupBox1->layout()->setMargin(11);
        vboxLayout1 = new QVBoxLayout();
        QBoxLayout *boxlayout = qobject_cast<QBoxLayout *>(GroupBox1->layout());
        if (boxlayout)
            boxlayout->addLayout(vboxLayout1);
        vboxLayout1->setAlignment(Qt::AlignTop);
        vboxLayout1->setObjectName(QString::fromUtf8("vboxLayout1"));
        xsltList = new Q3ListBox(GroupBox1);
        xsltList->setObjectName(QString::fromUtf8("xsltList"));
        xsltList->setMinimumSize(QSize(0, 200));
        xsltList->setFrameShape(QFrame::StyledPanel);
        xsltList->setFrameShadow(QFrame::Sunken);

        vboxLayout1->addWidget(xsltList);


        vboxLayout->addWidget(GroupBox1);

        GroupBox2 = new Q3GroupBox(XSLTDialog);
        GroupBox2->setObjectName(QString::fromUtf8("GroupBox2"));
        GroupBox2->setColumnLayout(0, Qt::Vertical);
        GroupBox2->layout()->setSpacing(6);
        GroupBox2->layout()->setMargin(11);
        hboxLayout = new QHBoxLayout();
        QBoxLayout *boxlayout1 = qobject_cast<QBoxLayout *>(GroupBox2->layout());
        if (boxlayout1)
            boxlayout1->addLayout(hboxLayout);
        hboxLayout->setAlignment(Qt::AlignTop);
        hboxLayout->setObjectName(QString::fromUtf8("hboxLayout"));
        recentBox = new QComboBox(GroupBox2);
        recentBox->setObjectName(QString::fromUtf8("recentBox"));
        QSizePolicy sizePolicy(static_cast<QSizePolicy::Policy>(7), static_cast<QSizePolicy::Policy>(0));
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(recentBox->sizePolicy().hasHeightForWidth());
        recentBox->setSizePolicy(sizePolicy);

        hboxLayout->addWidget(recentBox);

        Spacer2 = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum);

        hboxLayout->addItem(Spacer2);

        chooseBtn = new QPushButton(GroupBox2);
        chooseBtn->setObjectName(QString::fromUtf8("chooseBtn"));

        hboxLayout->addWidget(chooseBtn);


        vboxLayout->addWidget(GroupBox2);

        hboxLayout1 = new QHBoxLayout();
        hboxLayout1->setSpacing(6);
        hboxLayout1->setMargin(0);
        hboxLayout1->setObjectName(QString::fromUtf8("hboxLayout1"));
        Spacer57 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        hboxLayout1->addItem(Spacer57);

        OkBtn = new QPushButton(XSLTDialog);
        OkBtn->setObjectName(QString::fromUtf8("OkBtn"));
        OkBtn->setDefault(true);

        hboxLayout1->addWidget(OkBtn);

        CancelBtn = new QPushButton(XSLTDialog);
        CancelBtn->setObjectName(QString::fromUtf8("CancelBtn"));

        hboxLayout1->addWidget(CancelBtn);


        vboxLayout->addLayout(hboxLayout1);


        retranslateUi(XSLTDialog);
        QObject::connect(OkBtn, SIGNAL(clicked()), XSLTDialog, SLOT(okSlot()));
        QObject::connect(CancelBtn, SIGNAL(clicked()), XSLTDialog, SLOT(cancelSlot()));
        QObject::connect(chooseBtn, SIGNAL(clicked()), XSLTDialog, SLOT(chooseSlot()));
        QObject::connect(recentBox, SIGNAL(activated(QString)), XSLTDialog, SLOT(chooseRecentSlot()));
        QObject::connect(xsltList, SIGNAL(selectionChanged()), XSLTDialog, SLOT(chooseCommonSlot()));

        QMetaObject::connectSlotsByName(XSLTDialog);
    } // setupUi

    void retranslateUi(QDialog *XSLTDialog)
    {
        XSLTDialog->setWindowTitle(tr2i18n("Export XSLT Configuration", 0));
        GroupBox1->setTitle(tr2i18n("Common xslt Files", 0));
        GroupBox2->setTitle(tr2i18n("Personal xslt Files", 0));
        chooseBtn->setText(tr2i18n("Choose...", 0));
        OkBtn->setText(tr2i18n("&OK", 0));
        CancelBtn->setText(tr2i18n("&Cancel", 0));
        Q_UNUSED(XSLTDialog);
    } // retranslateUi

};

namespace Ui {
    class XSLTDialog: public Ui_XSLTDialog {};
} // namespace Ui

QT_END_NAMESPACE

class XSLTDialog : public QDialog, public Ui::XSLTDialog
{
    Q_OBJECT

public:
    XSLTDialog(QWidget* parent = 0, const char* name = 0, bool modal = false, Qt::WindowFlags fl = 0);
    ~XSLTDialog();

public slots:
    virtual void cancelSlot();
    virtual void chooseRecentSlot();
    virtual void chooseSlot();
    virtual void chooseCommonSlot();
    virtual void okSlot();

protected slots:
    virtual void languageChange();

};

#endif // XSLTDIALOG_H

