#include <kdialog.h>
#include <klocale.h>

#ifndef UI_EXPORTDIALOGUI_H
#define UI_EXPORTDIALOGUI_H

#include <qvariant.h>


#include <Qt3Support/Q3ButtonGroup>
#include <Qt3Support/Q3MimeSourceFactory>
#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QCheckBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QHeaderView>
#include <QtGui/QLabel>
#include <QtGui/QRadioButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QVBoxLayout>
#include <QtGui/QWidget>
#include <kcombobox.h>
#include "kcombobox.h"
#include "klineedit.h"
#include "kpushbutton.h"
#include "kurlrequester.h"

QT_BEGIN_NAMESPACE

class Ui_ExportDialogUI
{
public:
    QVBoxLayout *vboxLayout;
    QHBoxLayout *hboxLayout;
    QLabel *textLabel1;
    KComboBox *comboBoxEncoding;
    QSpacerItem *Spacer2;
    Q3ButtonGroup *buttonGroup1;
    QVBoxLayout *vboxLayout1;
    QRadioButton *radioDocType1;
    QRadioButton *radioDocType2;
    Q3ButtonGroup *buttonGroupMode;
    QVBoxLayout *vboxLayout2;
    QRadioButton *radioModeLight;
    QRadioButton *radioModeBasic;
    QRadioButton *radioModeEnhanced;
    QHBoxLayout *hboxLayout1;
    QSpacerItem *spacer7;
    QVBoxLayout *vboxLayout3;
    QCheckBox *checkExternalCSS;
    KUrlRequester *KURL_ExternalCSS;
    QSpacerItem *Spacer1;

    void setupUi(QWidget *ExportDialogUI)
    {
        if (ExportDialogUI->objectName().isEmpty())
            ExportDialogUI->setObjectName(QString::fromUtf8("ExportDialogUI"));
        ExportDialogUI->resize(289, 300);
        vboxLayout = new QVBoxLayout(ExportDialogUI);
        vboxLayout->setSpacing(6);
        vboxLayout->setMargin(11);
        vboxLayout->setObjectName(QString::fromUtf8("vboxLayout"));
        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(6);
        hboxLayout->setObjectName(QString::fromUtf8("hboxLayout"));
        textLabel1 = new QLabel(ExportDialogUI);
        textLabel1->setObjectName(QString::fromUtf8("textLabel1"));
        textLabel1->setTextFormat(Qt::PlainText);
        textLabel1->setWordWrap(false);

        hboxLayout->addWidget(textLabel1);

        comboBoxEncoding = new KComboBox(ExportDialogUI);
        comboBoxEncoding->setObjectName(QString::fromUtf8("comboBoxEncoding"));
        comboBoxEncoding->setEditable(true);

        hboxLayout->addWidget(comboBoxEncoding);

        Spacer2 = new QSpacerItem(106, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        hboxLayout->addItem(Spacer2);


        vboxLayout->addLayout(hboxLayout);

        buttonGroup1 = new Q3ButtonGroup(ExportDialogUI);
        buttonGroup1->setObjectName(QString::fromUtf8("buttonGroup1"));
        buttonGroup1->setColumnLayout(0, Qt::Vertical);
        buttonGroup1->layout()->setSpacing(6);
        buttonGroup1->layout()->setMargin(11);
        vboxLayout1 = new QVBoxLayout();
        QBoxLayout *boxlayout = qobject_cast<QBoxLayout *>(buttonGroup1->layout());
        if (boxlayout)
            boxlayout->addLayout(vboxLayout1);
        vboxLayout1->setAlignment(Qt::AlignTop);
        vboxLayout1->setObjectName(QString::fromUtf8("vboxLayout1"));
        radioDocType1 = new QRadioButton(buttonGroup1);
        radioDocType1->setObjectName(QString::fromUtf8("radioDocType1"));
        radioDocType1->setFocusPolicy(Qt::NoFocus);
        radioDocType1->setChecked(false);

        vboxLayout1->addWidget(radioDocType1);

        radioDocType2 = new QRadioButton(buttonGroup1);
        radioDocType2->setObjectName(QString::fromUtf8("radioDocType2"));
        radioDocType2->setChecked(true);

        vboxLayout1->addWidget(radioDocType2);


        vboxLayout->addWidget(buttonGroup1);

        buttonGroupMode = new Q3ButtonGroup(ExportDialogUI);
        buttonGroupMode->setObjectName(QString::fromUtf8("buttonGroupMode"));
        buttonGroupMode->setColumnLayout(0, Qt::Vertical);
        buttonGroupMode->layout()->setSpacing(6);
        buttonGroupMode->layout()->setMargin(11);
        vboxLayout2 = new QVBoxLayout();
        QBoxLayout *boxlayout1 = qobject_cast<QBoxLayout *>(buttonGroupMode->layout());
        if (boxlayout1)
            boxlayout1->addLayout(vboxLayout2);
        vboxLayout2->setAlignment(Qt::AlignTop);
        vboxLayout2->setObjectName(QString::fromUtf8("vboxLayout2"));
        radioModeLight = new QRadioButton(buttonGroupMode);
        radioModeLight->setObjectName(QString::fromUtf8("radioModeLight"));
        radioModeLight->setEnabled(true);
        radioModeLight->setFocusPolicy(Qt::NoFocus);

        vboxLayout2->addWidget(radioModeLight);

        radioModeBasic = new QRadioButton(buttonGroupMode);
        radioModeBasic->setObjectName(QString::fromUtf8("radioModeBasic"));
        radioModeBasic->setEnabled(true);
        radioModeBasic->setFocusPolicy(Qt::NoFocus);
        radioModeBasic->setChecked(false);

        vboxLayout2->addWidget(radioModeBasic);

        radioModeEnhanced = new QRadioButton(buttonGroupMode);
        radioModeEnhanced->setObjectName(QString::fromUtf8("radioModeEnhanced"));
        radioModeEnhanced->setChecked(true);

        vboxLayout2->addWidget(radioModeEnhanced);

        hboxLayout1 = new QHBoxLayout();
        hboxLayout1->setSpacing(6);
        hboxLayout1->setObjectName(QString::fromUtf8("hboxLayout1"));
        spacer7 = new QSpacerItem(16, 20, QSizePolicy::Fixed, QSizePolicy::Minimum);

        hboxLayout1->addItem(spacer7);

        vboxLayout3 = new QVBoxLayout();
        vboxLayout3->setSpacing(6);
        vboxLayout3->setObjectName(QString::fromUtf8("vboxLayout3"));
        checkExternalCSS = new QCheckBox(buttonGroupMode);
        checkExternalCSS->setObjectName(QString::fromUtf8("checkExternalCSS"));

        vboxLayout3->addWidget(checkExternalCSS);

        KURL_ExternalCSS = new KUrlRequester(buttonGroupMode);
        KURL_ExternalCSS->setObjectName(QString::fromUtf8("KURL_ExternalCSS"));
        KURL_ExternalCSS->setEnabled(false);

        vboxLayout3->addWidget(KURL_ExternalCSS);


        hboxLayout1->addLayout(vboxLayout3);


        vboxLayout2->addLayout(hboxLayout1);


        vboxLayout->addWidget(buttonGroupMode);

        Spacer1 = new QSpacerItem(20, 90, QSizePolicy::Expanding, QSizePolicy::Minimum);

        vboxLayout->addItem(Spacer1);

#ifndef UI_QT_NO_SHORTCUT
        textLabel1->setBuddy(comboBoxEncoding);
#endif // QT_NO_SHORTCUT
        QWidget::setTabOrder(comboBoxEncoding, radioDocType1);
        QWidget::setTabOrder(radioDocType1, radioDocType2);
        QWidget::setTabOrder(radioDocType2, radioModeBasic);
        QWidget::setTabOrder(radioModeBasic, radioModeLight);
        QWidget::setTabOrder(radioModeLight, radioModeEnhanced);

        retranslateUi(ExportDialogUI);

        QMetaObject::connectSlotsByName(ExportDialogUI);
    } // setupUi

    void retranslateUi(QWidget *ExportDialogUI)
    {
        ExportDialogUI->setWindowTitle(tr2i18n("HTML Export Dialog", 0));
        textLabel1->setText(tr2i18n("E&ncoding:", 0));
        buttonGroup1->setTitle(tr2i18n("Document Type", 0));
        radioDocType1->setText(tr2i18n("&HTML 4.01", 0));
#ifndef UI_QT_NO_TOOLTIP
        radioDocType1->setProperty("toolTip", QVariant(tr2i18n("HTML 4.01 (For older HTML user agents) ", 0)));
#endif // QT_NO_TOOLTIP
        radioDocType2->setText(tr2i18n("&XHTML 1.0", 0));
#ifndef UI_QT_NO_TOOLTIP
        radioDocType2->setProperty("toolTip", QVariant(tr2i18n("XHTML 1.0", 0)));
#endif // QT_NO_TOOLTIP
        buttonGroupMode->setTitle(tr2i18n("Mode", 0));
        radioModeLight->setText(tr2i18n("L&ight: Convert to strict (X)HTML", 0));
#ifndef UI_QT_NO_TOOLTIP
        radioModeLight->setProperty("toolTip", QVariant(tr2i18n("Convert mainly the document structure (Recommended for exporting to browsers with limited capabilities)", 0)));
#endif // QT_NO_TOOLTIP
        radioModeBasic->setText(tr2i18n("&Basic: Convert to transitional (X)HTML", 0));
#ifndef UI_QT_NO_TOOLTIP
        radioModeBasic->setProperty("toolTip", QVariant(tr2i18n("Convert most of the document (Recommended for re-importing in KWord or for exporting to older browsers)", 0)));
#endif // QT_NO_TOOLTIP
        radioModeEnhanced->setText(tr2i18n("&Enhanced: Convert to (X)HTML with CSS", 0));
#ifndef UI_QT_NO_TOOLTIP
        radioModeEnhanced->setProperty("toolTip", QVariant(tr2i18n("Convert as much as possible of the KWord document (Recommended for exporting to other modern word processors or to modern browsers)", 0)));
#endif // QT_NO_TOOLTIP
        checkExternalCSS->setText(tr2i18n("Use external CSS sheet:", 0));
#ifndef UI_QT_NO_TOOLTIP
        KURL_ExternalCSS->setProperty("toolTip", QVariant(tr2i18n("Enter the location of the CSS file in this field", 0)));
#endif // QT_NO_TOOLTIP
        Q_UNUSED(ExportDialogUI);
    } // retranslateUi

};

namespace Ui {
    class ExportDialogUI: public Ui_ExportDialogUI {};
} // namespace Ui

QT_END_NAMESPACE

class ExportDialogUI : public QWidget, public Ui::ExportDialogUI
{
    Q_OBJECT

public:
    ExportDialogUI(QWidget* parent = 0, const char* name = 0, Qt::WindowFlags fl = 0);
    ~ExportDialogUI();

protected slots:
    virtual void languageChange();

};

#endif // EXPORTDIALOGUI_H

