#include <kdialog.h>
#include <klocale.h>

#ifndef UI_LATEXEXPORTDIA_H
#define UI_LATEXEXPORTDIA_H

#include <qvariant.h>


#include <Qt3Support/Q3ButtonGroup>
#include <Qt3Support/Q3GroupBox>
#include <Qt3Support/Q3MimeSourceFactory>
#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QCheckBox>
#include <QtGui/QComboBox>
#include <QtGui/QDialog>
#include <QtGui/QGridLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QHeaderView>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QRadioButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QTabWidget>
#include <QtGui/QWidget>
#include <k3listbox.h>
#include <kcombobox.h>
#include <knuminput.h>
#include "k3listbox.h"
#include "kcombobox.h"
#include "klineedit.h"
#include "knuminput.h"
#include "kpushbutton.h"
#include "kurlrequester.h"

QT_BEGIN_NAMESPACE

class Ui_LatexExportDia
{
public:
    QGridLayout *gridLayout;
    QTabWidget *_tab;
    QWidget *Widget2;
    KIntNumInput *defaultFontSize;
    Q3ButtonGroup *styleGroup;
    QRadioButton *kwordStyleButton;
    QRadioButton *latexStyleButton;
    Q3ButtonGroup *typeGroup;
    QRadioButton *fullDocButton;
    QRadioButton *embededButton;
    QLabel *TextLabel1_2;
    QLabel *TextLabel2;
    QLabel *defaultFontSizeTextZone;
    QComboBox *classComboBox;
    KComboBox *qualityComboBox;
    QWidget *Widget3;
    KUrlRequester *pathPictures;
    QCheckBox *pictureCheckBox;
    QLabel *TextLabel1;
    QWidget *tab;
    Q3ButtonGroup *ButtonGroup3;
    KComboBox *encodingComboBox;
    Q3GroupBox *GroupBox4;
    QPushButton *rmLanguageBtn;
    QPushButton *addLanguageBtn;
    K3ListBox *langUsedList;
    K3ListBox *languagesList;
    QWidget *tab1;
    QCheckBox *exportAuthor;
    QCheckBox *tableContents;
    Q3ButtonGroup *note;
    QRadioButton *RadioButton7;
    QRadioButton *RadioButton6;
    QRadioButton *RadioButton5;
    QHBoxLayout *hboxLayout;
    QPushButton *buttonHelp;
    QSpacerItem *Horizontal_Spacing;
    QPushButton *buttonOk;
    QPushButton *buttonCancel;

    void setupUi(QDialog *LatexExportDia)
    {
        if (LatexExportDia->objectName().isEmpty())
            LatexExportDia->setObjectName(QString::fromUtf8("LatexExportDia"));
        LatexExportDia->resize(471, 364);
        LatexExportDia->setSizeGripEnabled(true);
        gridLayout = new QGridLayout(LatexExportDia);
        gridLayout->setSpacing(6);
        gridLayout->setMargin(11);
        gridLayout->setObjectName(QString::fromUtf8("gridLayout"));
        _tab = new QTabWidget(LatexExportDia);
        _tab->setObjectName(QString::fromUtf8("_tab"));
        _tab->setEnabled(true);
        Widget2 = new QWidget();
        Widget2->setObjectName(QString::fromUtf8("Widget2"));
        defaultFontSize = new KIntNumInput(Widget2);
        defaultFontSize->setObjectName(QString::fromUtf8("defaultFontSize"));
        defaultFontSize->setGeometry(QRect(241, 236, 125, 29));
        defaultFontSize->setValue(12);
        defaultFontSize->setMinimum(0);
        defaultFontSize->setMaximum(1000);
        styleGroup = new Q3ButtonGroup(Widget2);
        styleGroup->setObjectName(QString::fromUtf8("styleGroup"));
        styleGroup->setGeometry(QRect(13, 9, 378, 73));
        kwordStyleButton = new QRadioButton(styleGroup);
        kwordStyleButton->setObjectName(QString::fromUtf8("kwordStyleButton"));
        kwordStyleButton->setGeometry(QRect(11, 43, 354, 23));
        kwordStyleButton->setChecked(true);
        latexStyleButton = new QRadioButton(styleGroup);
        latexStyleButton->setObjectName(QString::fromUtf8("latexStyleButton"));
        latexStyleButton->setGeometry(QRect(11, 20, 354, 23));
        typeGroup = new Q3ButtonGroup(Widget2);
        typeGroup->setObjectName(QString::fromUtf8("typeGroup"));
        typeGroup->setGeometry(QRect(12, 86, 378, 75));
        fullDocButton = new QRadioButton(typeGroup);
        fullDocButton->setObjectName(QString::fromUtf8("fullDocButton"));
        fullDocButton->setGeometry(QRect(14, 21, 349, 23));
        fullDocButton->setChecked(true);
        embededButton = new QRadioButton(typeGroup);
        embededButton->setObjectName(QString::fromUtf8("embededButton"));
        embededButton->setGeometry(QRect(14, 45, 351, 23));
        TextLabel1_2 = new QLabel(Widget2);
        TextLabel1_2->setObjectName(QString::fromUtf8("TextLabel1_2"));
        TextLabel1_2->setGeometry(QRect(38, 174, 187, 18));
        TextLabel1_2->setWordWrap(false);
        TextLabel2 = new QLabel(Widget2);
        TextLabel2->setObjectName(QString::fromUtf8("TextLabel2"));
        TextLabel2->setGeometry(QRect(39, 208, 186, 18));
        TextLabel2->setWordWrap(false);
        defaultFontSizeTextZone = new QLabel(Widget2);
        defaultFontSizeTextZone->setObjectName(QString::fromUtf8("defaultFontSizeTextZone"));
        defaultFontSizeTextZone->setGeometry(QRect(39, 241, 186, 18));
        defaultFontSizeTextZone->setWordWrap(false);
        classComboBox = new QComboBox(Widget2);
        classComboBox->setObjectName(QString::fromUtf8("classComboBox"));
        classComboBox->setGeometry(QRect(240, 168, 125, 27));
        qualityComboBox = new KComboBox(Widget2);
        qualityComboBox->setObjectName(QString::fromUtf8("qualityComboBox"));
        qualityComboBox->setGeometry(QRect(241, 201, 125, 28));
        _tab->addTab(Widget2, QString());
        Widget3 = new QWidget();
        Widget3->setObjectName(QString::fromUtf8("Widget3"));
        pathPictures = new KUrlRequester(Widget3);
        pathPictures->setObjectName(QString::fromUtf8("pathPictures"));
        pathPictures->setGeometry(QRect(22, 80, 263, 42));
        pictureCheckBox = new QCheckBox(Widget3);
        pictureCheckBox->setObjectName(QString::fromUtf8("pictureCheckBox"));
        pictureCheckBox->setGeometry(QRect(21, 21, 262, 23));
        pictureCheckBox->setChecked(true);
        TextLabel1 = new QLabel(Widget3);
        TextLabel1->setObjectName(QString::fromUtf8("TextLabel1"));
        TextLabel1->setGeometry(QRect(24, 58, 255, 18));
        TextLabel1->setWordWrap(false);
        _tab->addTab(Widget3, QString());
        tab = new QWidget();
        tab->setObjectName(QString::fromUtf8("tab"));
        ButtonGroup3 = new Q3ButtonGroup(tab);
        ButtonGroup3->setObjectName(QString::fromUtf8("ButtonGroup3"));
        ButtonGroup3->setGeometry(QRect(18, 17, 359, 73));
        encodingComboBox = new KComboBox(ButtonGroup3);
        encodingComboBox->setObjectName(QString::fromUtf8("encodingComboBox"));
        encodingComboBox->setGeometry(QRect(25, 31, 157, 26));
        GroupBox4 = new Q3GroupBox(tab);
        GroupBox4->setObjectName(QString::fromUtf8("GroupBox4"));
        GroupBox4->setEnabled(true);
        GroupBox4->setGeometry(QRect(19, 102, 359, 150));
        rmLanguageBtn = new QPushButton(GroupBox4);
        rmLanguageBtn->setObjectName(QString::fromUtf8("rmLanguageBtn"));
        rmLanguageBtn->setGeometry(QRect(147, 83, 92, 29));
        addLanguageBtn = new QPushButton(GroupBox4);
        addLanguageBtn->setObjectName(QString::fromUtf8("addLanguageBtn"));
        addLanguageBtn->setGeometry(QRect(147, 48, 92, 29));
        langUsedList = new K3ListBox(GroupBox4);
        langUsedList->setObjectName(QString::fromUtf8("langUsedList"));
        langUsedList->setGeometry(QRect(246, 30, 96, 101));
        languagesList = new K3ListBox(GroupBox4);
        languagesList->setObjectName(QString::fromUtf8("languagesList"));
        languagesList->setGeometry(QRect(16, 30, 122, 105));
        _tab->addTab(tab, QString());
        tab1 = new QWidget();
        tab1->setObjectName(QString::fromUtf8("tab1"));
        exportAuthor = new QCheckBox(tab1);
        exportAuthor->setObjectName(QString::fromUtf8("exportAuthor"));
        exportAuthor->setEnabled(false);
        exportAuthor->setGeometry(QRect(26, 14, 376, 29));
        exportAuthor->setChecked(false);
        tableContents = new QCheckBox(tab1);
        tableContents->setObjectName(QString::fromUtf8("tableContents"));
        tableContents->setEnabled(false);
        tableContents->setGeometry(QRect(26, 49, 377, 39));
        note = new Q3ButtonGroup(tab1);
        note->setObjectName(QString::fromUtf8("note"));
        note->setEnabled(false);
        note->setGeometry(QRect(20, 91, 272, 103));
        RadioButton7 = new QRadioButton(note);
        RadioButton7->setObjectName(QString::fromUtf8("RadioButton7"));
        RadioButton7->setGeometry(QRect(16, 19, 251, 23));
        RadioButton6 = new QRadioButton(note);
        RadioButton6->setObjectName(QString::fromUtf8("RadioButton6"));
        RadioButton6->setGeometry(QRect(17, 64, 251, 23));
        RadioButton5 = new QRadioButton(note);
        RadioButton5->setObjectName(QString::fromUtf8("RadioButton5"));
        RadioButton5->setGeometry(QRect(17, 40, 248, 23));
        _tab->addTab(tab1, QString());

        gridLayout->addWidget(_tab, 0, 1, 1, 1);

        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(6);
        hboxLayout->setMargin(0);
        hboxLayout->setObjectName(QString::fromUtf8("hboxLayout"));
        buttonHelp = new QPushButton(LatexExportDia);
        buttonHelp->setObjectName(QString::fromUtf8("buttonHelp"));
        buttonHelp->setAutoDefault(true);

        hboxLayout->addWidget(buttonHelp);

        Horizontal_Spacing = new QSpacerItem(20, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);

        hboxLayout->addItem(Horizontal_Spacing);

        buttonOk = new QPushButton(LatexExportDia);
        buttonOk->setObjectName(QString::fromUtf8("buttonOk"));
        buttonOk->setAutoDefault(true);
        buttonOk->setDefault(true);

        hboxLayout->addWidget(buttonOk);

        buttonCancel = new QPushButton(LatexExportDia);
        buttonCancel->setObjectName(QString::fromUtf8("buttonCancel"));
        buttonCancel->setAutoDefault(true);

        hboxLayout->addWidget(buttonCancel);


        gridLayout->addLayout(hboxLayout, 1, 0, 1, 2);


        retranslateUi(LatexExportDia);
        QObject::connect(buttonOk, SIGNAL(clicked()), LatexExportDia, SLOT(accept()));
        QObject::connect(buttonCancel, SIGNAL(clicked()), LatexExportDia, SLOT(reject()));
        QObject::connect(addLanguageBtn, SIGNAL(clicked()), LatexExportDia, SLOT(addLanguage()));
        QObject::connect(rmLanguageBtn, SIGNAL(clicked()), LatexExportDia, SLOT(removeLanguage()));

        QMetaObject::connectSlotsByName(LatexExportDia);
    } // setupUi

    void retranslateUi(QDialog *LatexExportDia)
    {
        LatexExportDia->setWindowTitle(tr2i18n("Latex Export Filter Configuration", 0));
        styleGroup->setTitle(tr2i18n("Document Style", 0));
        kwordStyleButton->setText(tr2i18n("KWord style", 0));
        latexStyleButton->setText(tr2i18n("Latex style", 0));
        typeGroup->setTitle(tr2i18n("Document Type", 0));
        fullDocButton->setText(tr2i18n("Independent document", 0));
#ifndef UI_QT_NO_TOOLTIP
        fullDocButton->setProperty("toolTip", QVariant(tr2i18n("The document will be able to be compiled alone", 0)));
#endif // QT_NO_TOOLTIP
#ifndef UI_QT_NO_WHATSTHIS
        fullDocButton->setProperty("whatsThis", QVariant(tr2i18n("The document will be generated as a full latex document since all the include will be generated before the \\begin[document} and \\end{document} commands.", 0)));
#endif // QT_NO_WHATSTHIS
        embededButton->setText(tr2i18n("Document to include", 0));
#ifndef UI_QT_NO_TOOLTIP
        embededButton->setProperty("toolTip", QVariant(tr2i18n("Do not generate either the latex header or the document environment", 0)));
#endif // QT_NO_TOOLTIP
#ifndef UI_QT_NO_WHATSTHIS
        embededButton->setProperty("whatsThis", QVariant(tr2i18n("The document will be generated as a latex document which will have to be included in a main latex document. It will allow you to generate several little files for each chapter of your document.", 0)));
#endif // QT_NO_WHATSTHIS
        TextLabel1_2->setText(tr2i18n("Document class:", 0));
        TextLabel2->setText(tr2i18n("Quality:", 0));
        defaultFontSizeTextZone->setText(tr2i18n("Default font size:", 0));
        qualityComboBox->clear();
        qualityComboBox->insertItems(0, QStringList()
         << tr2i18n("Final", 0)
         << tr2i18n("Draft", 0)
        );
        _tab->setTabText(_tab->indexOf(Widget2), tr2i18n("Document", 0));
        pictureCheckBox->setText(tr2i18n("Convert the pictures", 0));
        TextLabel1->setText(tr2i18n("Pictures directory:", 0));
        _tab->setTabText(_tab->indexOf(Widget3), tr2i18n("Pictures", 0));
        ButtonGroup3->setTitle(tr2i18n("Encoding", 0));
        GroupBox4->setTitle(tr2i18n("Language", 0));
        rmLanguageBtn->setText(tr2i18n("Remove", 0));
        addLanguageBtn->setText(tr2i18n("Add", 0));
        _tab->setTabText(_tab->indexOf(tab), tr2i18n("Language", 0));
        exportAuthor->setText(tr2i18n("Export information about author", 0));
        tableContents->setText(tr2i18n("Add a table of content", 0));
        note->setTitle(tr2i18n("Notes", 0));
        RadioButton7->setText(tr2i18n("Don't export", 0));
        RadioButton6->setText(tr2i18n("Export notes in comments", 0));
        RadioButton5->setText(tr2i18n("Export notes in margin notes", 0));
        _tab->setTabText(_tab->indexOf(tab1), tr2i18n("Contents", 0));
        buttonHelp->setText(tr2i18n("&Help", 0));
        buttonHelp->setShortcut(tr2i18n("F1", 0));
        buttonOk->setText(tr2i18n("&OK", 0));
        buttonCancel->setText(tr2i18n("&Cancel", 0));
        Q_UNUSED(LatexExportDia);
    } // retranslateUi

};

namespace Ui {
    class LatexExportDia: public Ui_LatexExportDia {};
} // namespace Ui

QT_END_NAMESPACE

class LatexExportDia : public QDialog, public Ui::LatexExportDia
{
    Q_OBJECT

public:
    LatexExportDia(QWidget* parent = 0, const char* name = 0, bool modal = false, Qt::WindowFlags fl = 0);
    ~LatexExportDia();

public slots:
    virtual void addLanguage();
    virtual void removeLanguage();

protected slots:
    virtual void languageChange();

};

#endif // LATEXEXPORTDIA_H

