// This file was automatically generated from records.xml
#include "records.h"
#include <vector>
#include <iomanip>

namespace Swinder {

// ========== BackupRecord ==========

const unsigned BackupRecord::id = 0x0040;

class BackupRecord::Private
{
public:
    bool backupEnabled;
};

BackupRecord::BackupRecord()
    : d(new Private)
{
    setBackupEnabled(false);
}

BackupRecord::~BackupRecord()
{
    delete d;
}

BackupRecord::BackupRecord( const BackupRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

BackupRecord& BackupRecord::operator=( const BackupRecord& record )
{
    *d = *record.d;
    return *this;
}

bool BackupRecord::isBackupEnabled() const
{
    return d->backupEnabled;
}

void BackupRecord::setBackupEnabled(bool backupEnabled )
{
    d->backupEnabled = backupEnabled;
}

void BackupRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 2) {
        setIsValid(false);
        return;
    }
    setBackupEnabled(readU16(data) != 0);
}

void BackupRecord::dump( std::ostream& out ) const
{
    out << "Backup" << std::endl;
    out << "      BackupEnabled : " << isBackupEnabled() << std::endl;
}

static Record* createBackupRecord()
{
    return new BackupRecord();
}

// ========== EOFRecord ==========

const unsigned EOFRecord::id = 0x000A;

class EOFRecord::Private
{
public:
};

EOFRecord::EOFRecord()
    : d(new Private)
{
}

EOFRecord::~EOFRecord()
{
    delete d;
}

EOFRecord::EOFRecord( const EOFRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

EOFRecord& EOFRecord::operator=( const EOFRecord& record )
{
    *d = *record.d;
    return *this;
}

void EOFRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
}

void EOFRecord::dump( std::ostream& out ) const
{
    out << "EOF" << std::endl;
}

static Record* createEOFRecord()
{
    return new EOFRecord();
}

// ========== BlankRecord ==========

const unsigned BlankRecord::id = 0x0201;

class BlankRecord::Private
{
public:
    unsigned column;
    unsigned row;
    unsigned xfIndex;
};

BlankRecord::BlankRecord()
    : d(new Private)
{
    setColumn(0);
    setRow(0);
    setXfIndex(0);
}

BlankRecord::~BlankRecord()
{
    delete d;
}

BlankRecord::BlankRecord( const BlankRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

BlankRecord& BlankRecord::operator=( const BlankRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned BlankRecord::column() const
{
    return d->column;
}

void BlankRecord::setColumn(unsigned column )
{
    d->column = column;
}

unsigned BlankRecord::row() const
{
    return d->row;
}

void BlankRecord::setRow(unsigned row )
{
    d->row = row;
}

unsigned BlankRecord::xfIndex() const
{
    return d->xfIndex;
}

void BlankRecord::setXfIndex(unsigned xfIndex )
{
    d->xfIndex = xfIndex;
}

void BlankRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 6) {
        setIsValid(false);
        return;
    }
    setRow(readU16(data));
    setColumn(readU16(data + 2));
    setXfIndex(readU16(data + 4));
}

void BlankRecord::dump( std::ostream& out ) const
{
    out << "Blank" << std::endl;
    out << "                Row : " << row() << std::endl;
    out << "             Column : " << column() << std::endl;
    out << "            XfIndex : " << xfIndex() << std::endl;
}

static Record* createBlankRecord()
{
    return new BlankRecord();
}

// ========== BoolErrRecord ==========

const unsigned BoolErrRecord::id = 0x0205;

class BoolErrRecord::Private
{
public:
    unsigned column;
    bool error;
    unsigned row;
    unsigned value;
    unsigned xfIndex;
};

BoolErrRecord::BoolErrRecord()
    : d(new Private)
{
    setColumn(0);
    setError(false);
    setRow(0);
    setValue(0);
    setXfIndex(0);
}

BoolErrRecord::~BoolErrRecord()
{
    delete d;
}

BoolErrRecord::BoolErrRecord( const BoolErrRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

BoolErrRecord& BoolErrRecord::operator=( const BoolErrRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned BoolErrRecord::column() const
{
    return d->column;
}

void BoolErrRecord::setColumn(unsigned column )
{
    d->column = column;
}

bool BoolErrRecord::isError() const
{
    return d->error;
}

void BoolErrRecord::setError(bool error )
{
    d->error = error;
}

unsigned BoolErrRecord::row() const
{
    return d->row;
}

void BoolErrRecord::setRow(unsigned row )
{
    d->row = row;
}

unsigned BoolErrRecord::value() const
{
    return d->value;
}

void BoolErrRecord::setValue(unsigned value )
{
    d->value = value;
}

unsigned BoolErrRecord::xfIndex() const
{
    return d->xfIndex;
}

void BoolErrRecord::setXfIndex(unsigned xfIndex )
{
    d->xfIndex = xfIndex;
}

Value BoolErrRecord::asValue() const
{
    return isError() ? errorAsValue(value()) : Value(value() ? true : false);
}

void BoolErrRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 8) {
        setIsValid(false);
        return;
    }
    setRow(readU16(data));
    setColumn(readU16(data + 2));
    setXfIndex(readU16(data + 4));
    setValue(readU8(data + 6));
    setError(readU8(data + 7) != 0);
}

void BoolErrRecord::dump( std::ostream& out ) const
{
    out << "BoolErr" << std::endl;
    out << "                Row : " << row() << std::endl;
    out << "             Column : " << column() << std::endl;
    out << "            XfIndex : " << xfIndex() << std::endl;
    out << "              Value : " << value() << std::endl;
    out << "              Error : " << isError() << std::endl;
}

static Record* createBoolErrRecord()
{
    return new BoolErrRecord();
}

// ========== LeftMarginRecord ==========

const unsigned LeftMarginRecord::id = 0x0026;

class LeftMarginRecord::Private
{
public:
    double leftMargin;
};

LeftMarginRecord::LeftMarginRecord()
    : d(new Private)
{
}

LeftMarginRecord::~LeftMarginRecord()
{
    delete d;
}

LeftMarginRecord::LeftMarginRecord( const LeftMarginRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

LeftMarginRecord& LeftMarginRecord::operator=( const LeftMarginRecord& record )
{
    *d = *record.d;
    return *this;
}

double LeftMarginRecord::leftMargin() const
{
    return d->leftMargin;
}

void LeftMarginRecord::setLeftMargin(double leftMargin )
{
    d->leftMargin = leftMargin;
}

void LeftMarginRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 8) {
        setIsValid(false);
        return;
    }
    setLeftMargin(readFloat64(data));
}

void LeftMarginRecord::dump( std::ostream& out ) const
{
    out << "LeftMargin" << std::endl;
    out << "         LeftMargin : " << leftMargin() << std::endl;
}

static Record* createLeftMarginRecord()
{
    return new LeftMarginRecord();
}

// ========== RightMarginRecord ==========

const unsigned RightMarginRecord::id = 0x0027;

class RightMarginRecord::Private
{
public:
    double rightMargin;
};

RightMarginRecord::RightMarginRecord()
    : d(new Private)
{
}

RightMarginRecord::~RightMarginRecord()
{
    delete d;
}

RightMarginRecord::RightMarginRecord( const RightMarginRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

RightMarginRecord& RightMarginRecord::operator=( const RightMarginRecord& record )
{
    *d = *record.d;
    return *this;
}

double RightMarginRecord::rightMargin() const
{
    return d->rightMargin;
}

void RightMarginRecord::setRightMargin(double rightMargin )
{
    d->rightMargin = rightMargin;
}

void RightMarginRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 8) {
        setIsValid(false);
        return;
    }
    setRightMargin(readFloat64(data));
}

void RightMarginRecord::dump( std::ostream& out ) const
{
    out << "RightMargin" << std::endl;
    out << "        RightMargin : " << rightMargin() << std::endl;
}

static Record* createRightMarginRecord()
{
    return new RightMarginRecord();
}

// ========== TopMarginRecord ==========

const unsigned TopMarginRecord::id = 0x0028;

class TopMarginRecord::Private
{
public:
    double topMargin;
};

TopMarginRecord::TopMarginRecord()
    : d(new Private)
{
}

TopMarginRecord::~TopMarginRecord()
{
    delete d;
}

TopMarginRecord::TopMarginRecord( const TopMarginRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

TopMarginRecord& TopMarginRecord::operator=( const TopMarginRecord& record )
{
    *d = *record.d;
    return *this;
}

double TopMarginRecord::topMargin() const
{
    return d->topMargin;
}

void TopMarginRecord::setTopMargin(double topMargin )
{
    d->topMargin = topMargin;
}

void TopMarginRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 8) {
        setIsValid(false);
        return;
    }
    setTopMargin(readFloat64(data));
}

void TopMarginRecord::dump( std::ostream& out ) const
{
    out << "TopMargin" << std::endl;
    out << "          TopMargin : " << topMargin() << std::endl;
}

static Record* createTopMarginRecord()
{
    return new TopMarginRecord();
}

// ========== BottomMarginRecord ==========

const unsigned BottomMarginRecord::id = 0x0029;

class BottomMarginRecord::Private
{
public:
    double bottomMargin;
};

BottomMarginRecord::BottomMarginRecord()
    : d(new Private)
{
}

BottomMarginRecord::~BottomMarginRecord()
{
    delete d;
}

BottomMarginRecord::BottomMarginRecord( const BottomMarginRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

BottomMarginRecord& BottomMarginRecord::operator=( const BottomMarginRecord& record )
{
    *d = *record.d;
    return *this;
}

double BottomMarginRecord::bottomMargin() const
{
    return d->bottomMargin;
}

void BottomMarginRecord::setBottomMargin(double bottomMargin )
{
    d->bottomMargin = bottomMargin;
}

void BottomMarginRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 8) {
        setIsValid(false);
        return;
    }
    setBottomMargin(readFloat64(data));
}

void BottomMarginRecord::dump( std::ostream& out ) const
{
    out << "BottomMargin" << std::endl;
    out << "       BottomMargin : " << bottomMargin() << std::endl;
}

static Record* createBottomMarginRecord()
{
    return new BottomMarginRecord();
}

// ========== BoundSheetRecord ==========

const unsigned BoundSheetRecord::id = 0x0085;

class BoundSheetRecord::Private
{
public:
    unsigned bofPosition;
    UString sheetName;
    SheetState sheetState;
    SheetType sheetType;
};

BoundSheetRecord::BoundSheetRecord()
    : d(new Private)
{
    setBofPosition(0);
}

BoundSheetRecord::~BoundSheetRecord()
{
    delete d;
}

BoundSheetRecord::BoundSheetRecord( const BoundSheetRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

BoundSheetRecord& BoundSheetRecord::operator=( const BoundSheetRecord& record )
{
    *d = *record.d;
    return *this;
}

UString BoundSheetRecord::sheetStateToString(SheetState sheetState)
{
    switch (sheetState) {
        case Visible: return UString("Visible");
        case Hidden: return UString("Hidden");
        case StrongHidden: return UString("StrongHidden");
        default: return UString("Unknown: ") + UString::from(sheetState);
    }
}

UString BoundSheetRecord::sheetTypeToString(SheetType sheetType)
{
    switch (sheetType) {
        case Worksheet: return UString("Worksheet");
        case Chart: return UString("Chart");
        case VBModule: return UString("VBModule");
        default: return UString("Unknown: ") + UString::from(sheetType);
    }
}

unsigned BoundSheetRecord::bofPosition() const
{
    return d->bofPosition;
}

void BoundSheetRecord::setBofPosition(unsigned bofPosition )
{
    d->bofPosition = bofPosition;
}

UString BoundSheetRecord::sheetName() const
{
    return d->sheetName;
}

void BoundSheetRecord::setSheetName(UString sheetName )
{
    d->sheetName = sheetName;
}

BoundSheetRecord::SheetState BoundSheetRecord::sheetState() const
{
    return d->sheetState;
}

void BoundSheetRecord::setSheetState(SheetState sheetState )
{
    d->sheetState = sheetState;
}

BoundSheetRecord::SheetType BoundSheetRecord::sheetType() const
{
    return d->sheetType;
}

void BoundSheetRecord::setSheetType(SheetType sheetType )
{
    d->sheetType = sheetType;
}

void BoundSheetRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    bool stringLengthError = false;
    unsigned stringSize;
    if (size < 7) {
        setIsValid(false);
        return;
    }
    setBofPosition(readU32(data));
    setSheetState(static_cast<SheetState>(readU8(data + 4)));
    setSheetType(static_cast<SheetType>(readU8(data + 5)));
    unsigned sheetNameLength = readU8(data + 6);
    curOffset = 7;
    if (version() < Excel97) {
        setSheetName(readByteString(data + curOffset, sheetNameLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
    if (version() >= Excel97) {
        setSheetName(readUnicodeString(data + curOffset, sheetNameLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
}

void BoundSheetRecord::dump( std::ostream& out ) const
{
    out << "BoundSheet" << std::endl;
    out << "        BofPosition : " << bofPosition() << std::endl;
    out << "         SheetState : " << sheetStateToString(sheetState()) << std::endl;
    out << "          SheetType : " << sheetTypeToString(sheetType()) << std::endl;
    if (version() < Excel97) {
        out << "          SheetName : " << sheetName() << std::endl;
    }
    if (version() >= Excel97) {
        out << "          SheetName : " << sheetName() << std::endl;
    }
}

static Record* createBoundSheetRecord()
{
    return new BoundSheetRecord();
}

// ========== CalcModeRecord ==========

const unsigned CalcModeRecord::id = 0x000D;

class CalcModeRecord::Private
{
public:
    CalcMode calcMode;
};

CalcModeRecord::CalcModeRecord()
    : d(new Private)
{
}

CalcModeRecord::~CalcModeRecord()
{
    delete d;
}

CalcModeRecord::CalcModeRecord( const CalcModeRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

CalcModeRecord& CalcModeRecord::operator=( const CalcModeRecord& record )
{
    *d = *record.d;
    return *this;
}

UString CalcModeRecord::calcModeToString(CalcMode calcMode)
{
    switch (calcMode) {
        case Manual: return UString("Manual");
        case Automatic: return UString("Automatic");
        case SemiAutomatic: return UString("SemiAutomatic");
        default: return UString("Unknown: ") + UString::from(calcMode);
    }
}

CalcModeRecord::CalcMode CalcModeRecord::calcMode() const
{
    return d->calcMode;
}

void CalcModeRecord::setCalcMode(CalcMode calcMode )
{
    d->calcMode = calcMode;
}

void CalcModeRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 2) {
        setIsValid(false);
        return;
    }
    setCalcMode(static_cast<CalcMode>(readS16(data)));
}

void CalcModeRecord::dump( std::ostream& out ) const
{
    out << "CalcMode" << std::endl;
    out << "           CalcMode : " << calcModeToString(calcMode()) << std::endl;
}

static Record* createCalcModeRecord()
{
    return new CalcModeRecord();
}

// ========== ColInfoRecord ==========

const unsigned ColInfoRecord::id = 0x007D;

class ColInfoRecord::Private
{
public:
    bool collapsed;
    unsigned firstColumn;
    bool hidden;
    unsigned lastColumn;
    unsigned outlineLevel;
    unsigned width;
    unsigned xfIndex;
};

ColInfoRecord::ColInfoRecord()
    : d(new Private)
{
    setCollapsed(false);
    setFirstColumn(0);
    setHidden(false);
    setLastColumn(0);
    setOutlineLevel(0);
    setWidth(0);
    setXfIndex(0);
}

ColInfoRecord::~ColInfoRecord()
{
    delete d;
}

ColInfoRecord::ColInfoRecord( const ColInfoRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

ColInfoRecord& ColInfoRecord::operator=( const ColInfoRecord& record )
{
    *d = *record.d;
    return *this;
}

bool ColInfoRecord::isCollapsed() const
{
    return d->collapsed;
}

void ColInfoRecord::setCollapsed(bool collapsed )
{
    d->collapsed = collapsed;
}

unsigned ColInfoRecord::firstColumn() const
{
    return d->firstColumn;
}

void ColInfoRecord::setFirstColumn(unsigned firstColumn )
{
    d->firstColumn = firstColumn;
}

bool ColInfoRecord::isHidden() const
{
    return d->hidden;
}

void ColInfoRecord::setHidden(bool hidden )
{
    d->hidden = hidden;
}

unsigned ColInfoRecord::lastColumn() const
{
    return d->lastColumn;
}

void ColInfoRecord::setLastColumn(unsigned lastColumn )
{
    d->lastColumn = lastColumn;
}

unsigned ColInfoRecord::outlineLevel() const
{
    return d->outlineLevel;
}

void ColInfoRecord::setOutlineLevel(unsigned outlineLevel )
{
    d->outlineLevel = outlineLevel;
}

unsigned ColInfoRecord::width() const
{
    return d->width;
}

void ColInfoRecord::setWidth(unsigned width )
{
    d->width = width;
}

unsigned ColInfoRecord::xfIndex() const
{
    return d->xfIndex;
}

void ColInfoRecord::setXfIndex(unsigned xfIndex )
{
    d->xfIndex = xfIndex;
}

void ColInfoRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 12) {
        setIsValid(false);
        return;
    }
    setFirstColumn(readU16(data));
    setLastColumn(readU16(data + 2));
    setWidth(readU16(data + 4));
    setXfIndex(readU16(data + 6));
    setHidden((readU8(data + 8)) & 0x1 != 0);
    setOutlineLevel((readU8(data + 9)) & 0x7);
    setCollapsed((readU8(data + 9) >> 4) & 0x1 != 0);
}

void ColInfoRecord::dump( std::ostream& out ) const
{
    out << "ColInfo" << std::endl;
    out << "        FirstColumn : " << firstColumn() << std::endl;
    out << "         LastColumn : " << lastColumn() << std::endl;
    out << "              Width : " << width() << std::endl;
    out << "            XfIndex : " << xfIndex() << std::endl;
    out << "             Hidden : " << isHidden() << std::endl;
    out << "       OutlineLevel : " << outlineLevel() << std::endl;
    out << "          Collapsed : " << isCollapsed() << std::endl;
}

static Record* createColInfoRecord()
{
    return new ColInfoRecord();
}

// ========== DataTableRecord ==========

const unsigned DataTableRecord::id = 0x0236;

class DataTableRecord::Private
{
public:
    bool alwaysCalc;
    unsigned firstColumn;
    unsigned firstRow;
    unsigned inputColumn1;
    unsigned inputColumn2;
    unsigned inputRow1;
    unsigned inputRow2;
    unsigned lastColumn;
    unsigned lastRow;
    bool rowColTable;
    bool rowInput;
};

DataTableRecord::DataTableRecord()
    : d(new Private)
{
    setAlwaysCalc(false);
    setFirstColumn(0);
    setFirstRow(0);
    setInputColumn1(0);
    setInputColumn2(0);
    setInputRow1(0);
    setInputRow2(0);
    setLastColumn(0);
    setLastRow(0);
    setRowColTable(false);
    setRowInput(false);
}

DataTableRecord::~DataTableRecord()
{
    delete d;
}

DataTableRecord::DataTableRecord( const DataTableRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

DataTableRecord& DataTableRecord::operator=( const DataTableRecord& record )
{
    *d = *record.d;
    return *this;
}

UString DataTableRecord::directionToString(Direction direction)
{
    switch (direction) {
        case InputRow: return UString("InputRow");
        case InputColumn: return UString("InputColumn");
        case Input2D: return UString("Input2D");
        default: return UString("Unknown: ") + UString::from(direction);
    }
}

bool DataTableRecord::isAlwaysCalc() const
{
    return d->alwaysCalc;
}

void DataTableRecord::setAlwaysCalc(bool alwaysCalc )
{
    d->alwaysCalc = alwaysCalc;
}

unsigned DataTableRecord::firstColumn() const
{
    return d->firstColumn;
}

void DataTableRecord::setFirstColumn(unsigned firstColumn )
{
    d->firstColumn = firstColumn;
}

unsigned DataTableRecord::firstRow() const
{
    return d->firstRow;
}

void DataTableRecord::setFirstRow(unsigned firstRow )
{
    d->firstRow = firstRow;
}

unsigned DataTableRecord::inputColumn1() const
{
    return d->inputColumn1;
}

void DataTableRecord::setInputColumn1(unsigned inputColumn1 )
{
    d->inputColumn1 = inputColumn1;
}

unsigned DataTableRecord::inputColumn2() const
{
    return d->inputColumn2;
}

void DataTableRecord::setInputColumn2(unsigned inputColumn2 )
{
    d->inputColumn2 = inputColumn2;
}

unsigned DataTableRecord::inputRow1() const
{
    return d->inputRow1;
}

void DataTableRecord::setInputRow1(unsigned inputRow1 )
{
    d->inputRow1 = inputRow1;
}

unsigned DataTableRecord::inputRow2() const
{
    return d->inputRow2;
}

void DataTableRecord::setInputRow2(unsigned inputRow2 )
{
    d->inputRow2 = inputRow2;
}

unsigned DataTableRecord::lastColumn() const
{
    return d->lastColumn;
}

void DataTableRecord::setLastColumn(unsigned lastColumn )
{
    d->lastColumn = lastColumn;
}

unsigned DataTableRecord::lastRow() const
{
    return d->lastRow;
}

void DataTableRecord::setLastRow(unsigned lastRow )
{
    d->lastRow = lastRow;
}

bool DataTableRecord::isRowColTable() const
{
    return d->rowColTable;
}

void DataTableRecord::setRowColTable(bool rowColTable )
{
    d->rowColTable = rowColTable;
}

bool DataTableRecord::isRowInput() const
{
    return d->rowInput;
}

void DataTableRecord::setRowInput(bool rowInput )
{
    d->rowInput = rowInput;
}

DataTableRecord::Direction DataTableRecord::direction() const
{
    return isRowColTable() ? Input2D : isRowInput() ? InputRow : InputColumn;
}

void DataTableRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 16) {
        setIsValid(false);
        return;
    }
    setFirstRow(readU16(data));
    setLastRow(readU16(data + 2));
    setFirstColumn(readU8(data + 4));
    setLastColumn(readU8(data + 5));
    setAlwaysCalc((readU8(data + 6)) & 0x1 != 0);
    setRowInput((readU8(data + 6) >> 2) & 0x1 != 0);
    setRowColTable((readU8(data + 6) >> 3) & 0x1 != 0);
    setInputRow1(readU16(data + 8));
    setInputColumn1(readU16(data + 10));
    setInputRow2(readU16(data + 12));
    setInputColumn2(readU16(data + 14));
}

void DataTableRecord::dump( std::ostream& out ) const
{
    out << "DataTable" << std::endl;
    out << "           FirstRow : " << firstRow() << std::endl;
    out << "            LastRow : " << lastRow() << std::endl;
    out << "        FirstColumn : " << firstColumn() << std::endl;
    out << "         LastColumn : " << lastColumn() << std::endl;
    out << "         AlwaysCalc : " << isAlwaysCalc() << std::endl;
    out << "           RowInput : " << isRowInput() << std::endl;
    out << "        RowColTable : " << isRowColTable() << std::endl;
    out << "          InputRow1 : " << inputRow1() << std::endl;
    out << "       InputColumn1 : " << inputColumn1() << std::endl;
    out << "          InputRow2 : " << inputRow2() << std::endl;
    out << "       InputColumn2 : " << inputColumn2() << std::endl;
}

static Record* createDataTableRecord()
{
    return new DataTableRecord();
}

// ========== DateModeRecord ==========

const unsigned DateModeRecord::id = 0x0022;

class DateModeRecord::Private
{
public:
    bool base1904;
};

DateModeRecord::DateModeRecord()
    : d(new Private)
{
    setBase1904(false);
}

DateModeRecord::~DateModeRecord()
{
    delete d;
}

DateModeRecord::DateModeRecord( const DateModeRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

DateModeRecord& DateModeRecord::operator=( const DateModeRecord& record )
{
    *d = *record.d;
    return *this;
}

bool DateModeRecord::isBase1904() const
{
    return d->base1904;
}

void DateModeRecord::setBase1904(bool base1904 )
{
    d->base1904 = base1904;
}

void DateModeRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 2) {
        setIsValid(false);
        return;
    }
    setBase1904(readU16(data) != 0);
}

void DateModeRecord::dump( std::ostream& out ) const
{
    out << "DateMode" << std::endl;
    out << "           Base1904 : " << isBase1904() << std::endl;
}

static Record* createDateModeRecord()
{
    return new DateModeRecord();
}

// ========== DimensionRecord ==========

const unsigned DimensionRecord::id = 0x0200;

class DimensionRecord::Private
{
public:
    unsigned firstColumn;
    unsigned firstRow;
    unsigned lastColumnPlus1;
    unsigned lastRowPlus1;
};

DimensionRecord::DimensionRecord()
    : d(new Private)
{
    setFirstColumn(0);
    setFirstRow(0);
    setLastColumnPlus1(0);
    setLastRowPlus1(0);
}

DimensionRecord::~DimensionRecord()
{
    delete d;
}

DimensionRecord::DimensionRecord( const DimensionRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

DimensionRecord& DimensionRecord::operator=( const DimensionRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned DimensionRecord::firstColumn() const
{
    return d->firstColumn;
}

void DimensionRecord::setFirstColumn(unsigned firstColumn )
{
    d->firstColumn = firstColumn;
}

unsigned DimensionRecord::firstRow() const
{
    return d->firstRow;
}

void DimensionRecord::setFirstRow(unsigned firstRow )
{
    d->firstRow = firstRow;
}

unsigned DimensionRecord::lastColumnPlus1() const
{
    return d->lastColumnPlus1;
}

void DimensionRecord::setLastColumnPlus1(unsigned lastColumnPlus1 )
{
    d->lastColumnPlus1 = lastColumnPlus1;
}

unsigned DimensionRecord::lastRowPlus1() const
{
    return d->lastRowPlus1;
}

void DimensionRecord::setLastRowPlus1(unsigned lastRowPlus1 )
{
    d->lastRowPlus1 = lastRowPlus1;
}

void DimensionRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    curOffset = 0;
    if (version() < Excel97) {
        if (size < curOffset + 4) {
            setIsValid(false);
            return;
        }
        setFirstRow(readU16(data + curOffset));
        setLastRowPlus1(readU16(data + curOffset + 2));
        curOffset += 4;
    }
    if (version() >= Excel97) {
        if (size < curOffset + 8) {
            setIsValid(false);
            return;
        }
        setFirstRow(readU32(data + curOffset));
        setLastRowPlus1(readU32(data + curOffset + 4));
        curOffset += 8;
    }
    if (size < curOffset + 6) {
        setIsValid(false);
        return;
    }
    setFirstColumn(readU16(data + curOffset));
    setLastColumnPlus1(readU16(data + curOffset + 2));
}

void DimensionRecord::dump( std::ostream& out ) const
{
    out << "Dimension" << std::endl;
    if (version() < Excel97) {
        out << "           FirstRow : " << firstRow() << std::endl;
        out << "       LastRowPlus1 : " << lastRowPlus1() << std::endl;
    }
    if (version() >= Excel97) {
        out << "           FirstRow : " << firstRow() << std::endl;
        out << "       LastRowPlus1 : " << lastRowPlus1() << std::endl;
    }
    out << "        FirstColumn : " << firstColumn() << std::endl;
    out << "    LastColumnPlus1 : " << lastColumnPlus1() << std::endl;
}

static Record* createDimensionRecord()
{
    return new DimensionRecord();
}

// ========== ExternSheetRecord ==========

const unsigned ExternSheetRecord::id = 0x0017;

class ExternSheetRecord::Private
{
public:
    std::vector<unsigned> bookRef;
    std::vector<unsigned> firstSheetRef;
    std::vector<unsigned> lastSheetRef;
    unsigned refCount;
};

ExternSheetRecord::ExternSheetRecord()
    : d(new Private)
{
    setRefCount(0);
}

ExternSheetRecord::~ExternSheetRecord()
{
    delete d;
}

ExternSheetRecord::ExternSheetRecord( const ExternSheetRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

ExternSheetRecord& ExternSheetRecord::operator=( const ExternSheetRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned ExternSheetRecord::bookRef( unsigned index ) const
{
    return d->bookRef[index];
}

void ExternSheetRecord::setBookRef( unsigned index, unsigned bookRef )
{
    d->bookRef[index] = bookRef;
}

unsigned ExternSheetRecord::firstSheetRef( unsigned index ) const
{
    return d->firstSheetRef[index];
}

void ExternSheetRecord::setFirstSheetRef( unsigned index, unsigned firstSheetRef )
{
    d->firstSheetRef[index] = firstSheetRef;
}

unsigned ExternSheetRecord::lastSheetRef( unsigned index ) const
{
    return d->lastSheetRef[index];
}

void ExternSheetRecord::setLastSheetRef( unsigned index, unsigned lastSheetRef )
{
    d->lastSheetRef[index] = lastSheetRef;
}

unsigned ExternSheetRecord::refCount() const
{
    return d->refCount;
}

void ExternSheetRecord::setRefCount(unsigned refCount )
{
    d->refCount = refCount;
    d->bookRef.resize(refCount);
    d->firstSheetRef.resize(refCount);
    d->lastSheetRef.resize(refCount);
}

void ExternSheetRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    curOffset = 0;
    if (version() >= Excel97) {
        if (size < curOffset + 2) {
            setIsValid(false);
            return;
        }
        setRefCount(readU16(data + curOffset));
        curOffset += 2;
        for (unsigned i = 0, endi = refCount(); i < endi; ++i) {
            if (size < curOffset + 6) {
                setIsValid(false);
                return;
            }
            setBookRef(i, readU16(data + curOffset));
            setFirstSheetRef(i, readU16(data + curOffset + 2));
            setLastSheetRef(i, readU16(data + curOffset + 4));
            curOffset += 6;
        }
    }
}

void ExternSheetRecord::dump( std::ostream& out ) const
{
    out << "ExternSheet" << std::endl;
    if (version() >= Excel97) {
        out << "           RefCount : " << refCount() << std::endl;
        for (unsigned i = 0, endi = refCount(); i < endi; ++i) {
            out << "        BookRef " << std::setw(3) << i <<" : " << bookRef(i) << std::endl;
            out << "  FirstSheetRef " << std::setw(3) << i <<" : " << firstSheetRef(i) << std::endl;
            out << "   LastSheetRef " << std::setw(3) << i <<" : " << lastSheetRef(i) << std::endl;
        }
    }
}

static Record* createExternSheetRecord()
{
    return new ExternSheetRecord();
}

// ========== FontRecord ==========

const unsigned FontRecord::id = 0x0031;

class FontRecord::Private
{
public:
    unsigned characterSet;
    unsigned colorIndex;
    bool condensed;
    Escapement escapement;
    bool extended;
    FontFamily fontFamily;
    UString fontName;
    unsigned fontWeight;
    unsigned height;
    bool italic;
    bool outline;
    bool shadow;
    bool strikeout;
    Underline underline;
};

FontRecord::FontRecord()
    : d(new Private)
{
    setCharacterSet(0);
    setColorIndex(0);
    setCondensed(false);
    setExtended(false);
    setFontWeight(0);
    setHeight(0);
    setItalic(false);
    setOutline(false);
    setShadow(false);
    setStrikeout(false);
}

FontRecord::~FontRecord()
{
    delete d;
}

FontRecord::FontRecord( const FontRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

FontRecord& FontRecord::operator=( const FontRecord& record )
{
    *d = *record.d;
    return *this;
}

UString FontRecord::escapementToString(Escapement escapement)
{
    switch (escapement) {
        case Normal: return UString("Normal");
        case Superscript: return UString("Superscript");
        case Subscript: return UString("Subscript");
        default: return UString("Unknown: ") + UString::from(escapement);
    }
}

UString FontRecord::underlineToString(Underline underline)
{
    switch (underline) {
        case None: return UString("None");
        case Single: return UString("Single");
        case Double: return UString("Double");
        case SingleAccounting: return UString("SingleAccounting");
        case DoubleAccounting: return UString("DoubleAccounting");
        default: return UString("Unknown: ") + UString::from(underline);
    }
}

UString FontRecord::fontFamilyToString(FontFamily fontFamily)
{
    switch (fontFamily) {
        case Unknown: return UString("Unknown");
        case Roman: return UString("Roman");
        case Swiss: return UString("Swiss");
        case Modern: return UString("Modern");
        case Script: return UString("Script");
        case Decorative: return UString("Decorative");
        default: return UString("Unknown: ") + UString::from(fontFamily);
    }
}

unsigned FontRecord::characterSet() const
{
    return d->characterSet;
}

void FontRecord::setCharacterSet(unsigned characterSet )
{
    d->characterSet = characterSet;
}

unsigned FontRecord::colorIndex() const
{
    return d->colorIndex;
}

void FontRecord::setColorIndex(unsigned colorIndex )
{
    d->colorIndex = colorIndex;
}

bool FontRecord::isCondensed() const
{
    return d->condensed;
}

void FontRecord::setCondensed(bool condensed )
{
    d->condensed = condensed;
}

FontRecord::Escapement FontRecord::escapement() const
{
    return d->escapement;
}

void FontRecord::setEscapement(Escapement escapement )
{
    d->escapement = escapement;
}

bool FontRecord::isExtended() const
{
    return d->extended;
}

void FontRecord::setExtended(bool extended )
{
    d->extended = extended;
}

FontRecord::FontFamily FontRecord::fontFamily() const
{
    return d->fontFamily;
}

void FontRecord::setFontFamily(FontFamily fontFamily )
{
    d->fontFamily = fontFamily;
}

UString FontRecord::fontName() const
{
    return d->fontName;
}

void FontRecord::setFontName(UString fontName )
{
    d->fontName = fontName;
}

unsigned FontRecord::fontWeight() const
{
    return d->fontWeight;
}

void FontRecord::setFontWeight(unsigned fontWeight )
{
    d->fontWeight = fontWeight;
}

unsigned FontRecord::height() const
{
    return d->height;
}

void FontRecord::setHeight(unsigned height )
{
    d->height = height;
}

bool FontRecord::isItalic() const
{
    return d->italic;
}

void FontRecord::setItalic(bool italic )
{
    d->italic = italic;
}

bool FontRecord::isOutline() const
{
    return d->outline;
}

void FontRecord::setOutline(bool outline )
{
    d->outline = outline;
}

bool FontRecord::isShadow() const
{
    return d->shadow;
}

void FontRecord::setShadow(bool shadow )
{
    d->shadow = shadow;
}

bool FontRecord::isStrikeout() const
{
    return d->strikeout;
}

void FontRecord::setStrikeout(bool strikeout )
{
    d->strikeout = strikeout;
}

FontRecord::Underline FontRecord::underline() const
{
    return d->underline;
}

void FontRecord::setUnderline(Underline underline )
{
    d->underline = underline;
}

void FontRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    bool stringLengthError = false;
    unsigned stringSize;
    if (size < 14) {
        setIsValid(false);
        return;
    }
    setHeight(readU16(data));
    setItalic((readU8(data + 2) >> 1) & 0x1 != 0);
    setStrikeout((readU8(data + 2) >> 3) & 0x1 != 0);
    setOutline((readU8(data + 2) >> 4) & 0x1 != 0);
    setShadow((readU8(data + 2) >> 5) & 0x1 != 0);
    setCondensed((readU8(data + 2) >> 6) & 0x1 != 0);
    setExtended((readU8(data + 2) >> 7) & 0x1 != 0);
    setColorIndex(readU16(data + 3));
    setFontWeight(readU16(data + 5));
    setEscapement(static_cast<Escapement>(readU16(data + 7)));
    setUnderline(static_cast<Underline>(readU8(data + 9)));
    setFontFamily(static_cast<FontFamily>(readU8(data + 10)));
    setCharacterSet(readU8(data + 11));
    unsigned fontNameLength = readU8(data + 13);
    curOffset = 14;
    if (version() < Excel97) {
        setFontName(readByteString(data + curOffset, fontNameLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
    if (version() >= Excel97) {
        setFontName(readUnicodeString(data + curOffset, fontNameLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
}

void FontRecord::dump( std::ostream& out ) const
{
    out << "Font" << std::endl;
    out << "             Height : " << height() << std::endl;
    out << "             Italic : " << isItalic() << std::endl;
    out << "          Strikeout : " << isStrikeout() << std::endl;
    out << "            Outline : " << isOutline() << std::endl;
    out << "             Shadow : " << isShadow() << std::endl;
    out << "          Condensed : " << isCondensed() << std::endl;
    out << "           Extended : " << isExtended() << std::endl;
    out << "         ColorIndex : " << colorIndex() << std::endl;
    out << "         FontWeight : " << fontWeight() << std::endl;
    out << "         Escapement : " << escapementToString(escapement()) << std::endl;
    out << "          Underline : " << underlineToString(underline()) << std::endl;
    out << "         FontFamily : " << fontFamilyToString(fontFamily()) << std::endl;
    out << "       CharacterSet : " << characterSet() << std::endl;
    if (version() < Excel97) {
        out << "           FontName : " << fontName() << std::endl;
    }
    if (version() >= Excel97) {
        out << "           FontName : " << fontName() << std::endl;
    }
}

static Record* createFontRecord()
{
    return new FontRecord();
}

// ========== HeaderRecord ==========

const unsigned HeaderRecord::id = 0x0014;

class HeaderRecord::Private
{
public:
    UString header;
};

HeaderRecord::HeaderRecord()
    : d(new Private)
{
}

HeaderRecord::~HeaderRecord()
{
    delete d;
}

HeaderRecord::HeaderRecord( const HeaderRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

HeaderRecord& HeaderRecord::operator=( const HeaderRecord& record )
{
    *d = *record.d;
    return *this;
}

UString HeaderRecord::header() const
{
    return d->header;
}

void HeaderRecord::setHeader(UString header )
{
    d->header = header;
}

void HeaderRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    bool stringLengthError = false;
    unsigned stringSize;
    curOffset = 0;
    if (version() < Excel97) {
        if (size < curOffset + 1) {
            setIsValid(false);
            return;
        }
        unsigned headerLength = readU8(data + curOffset);
        curOffset += 1;
        setHeader(readByteString(data + curOffset, headerLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
    if (version() >= Excel97) {
        if (size < curOffset + 2) {
            setIsValid(false);
            return;
        }
        unsigned headerLength = readU16(data + curOffset);
        curOffset += 2;
        setHeader(readUnicodeString(data + curOffset, headerLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
}

void HeaderRecord::dump( std::ostream& out ) const
{
    out << "Header" << std::endl;
    if (version() < Excel97) {
        out << "             Header : " << header() << std::endl;
    }
    if (version() >= Excel97) {
        out << "             Header : " << header() << std::endl;
    }
}

static Record* createHeaderRecord()
{
    return new HeaderRecord();
}

// ========== FooterRecord ==========

const unsigned FooterRecord::id = 0x0015;

class FooterRecord::Private
{
public:
    UString footer;
};

FooterRecord::FooterRecord()
    : d(new Private)
{
}

FooterRecord::~FooterRecord()
{
    delete d;
}

FooterRecord::FooterRecord( const FooterRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

FooterRecord& FooterRecord::operator=( const FooterRecord& record )
{
    *d = *record.d;
    return *this;
}

UString FooterRecord::footer() const
{
    return d->footer;
}

void FooterRecord::setFooter(UString footer )
{
    d->footer = footer;
}

void FooterRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    bool stringLengthError = false;
    unsigned stringSize;
    curOffset = 0;
    if (version() < Excel97) {
        if (size < curOffset + 1) {
            setIsValid(false);
            return;
        }
        unsigned footerLength = readU8(data + curOffset);
        curOffset += 1;
        setFooter(readByteString(data + curOffset, footerLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
    if (version() >= Excel97) {
        if (size < curOffset + 2) {
            setIsValid(false);
            return;
        }
        unsigned footerLength = readU16(data + curOffset);
        curOffset += 2;
        setFooter(readUnicodeString(data + curOffset, footerLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
}

void FooterRecord::dump( std::ostream& out ) const
{
    out << "Footer" << std::endl;
    if (version() < Excel97) {
        out << "             Footer : " << footer() << std::endl;
    }
    if (version() >= Excel97) {
        out << "             Footer : " << footer() << std::endl;
    }
}

static Record* createFooterRecord()
{
    return new FooterRecord();
}

// ========== FormatRecord ==========

const unsigned FormatRecord::id = 0x041E;

class FormatRecord::Private
{
public:
    UString formatString;
    unsigned index;
};

FormatRecord::FormatRecord()
    : d(new Private)
{
    setIndex(0);
}

FormatRecord::~FormatRecord()
{
    delete d;
}

FormatRecord::FormatRecord( const FormatRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

FormatRecord& FormatRecord::operator=( const FormatRecord& record )
{
    *d = *record.d;
    return *this;
}

UString FormatRecord::formatString() const
{
    return d->formatString;
}

void FormatRecord::setFormatString(UString formatString )
{
    d->formatString = formatString;
}

unsigned FormatRecord::index() const
{
    return d->index;
}

void FormatRecord::setIndex(unsigned index )
{
    d->index = index;
}

void FormatRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    bool stringLengthError = false;
    unsigned stringSize;
    if (size < 2) {
        setIsValid(false);
        return;
    }
    setIndex(readU16(data));
    curOffset = 2;
    if (version() < Excel97) {
        if (size < curOffset + 1) {
            setIsValid(false);
            return;
        }
        unsigned formatStringLength = readU8(data + curOffset);
        curOffset += 1;
        setFormatString(readByteString(data + curOffset, formatStringLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
    if (version() >= Excel97) {
        if (size < curOffset + 2) {
            setIsValid(false);
            return;
        }
        unsigned formatStringLength = readU16(data + curOffset);
        curOffset += 2;
        setFormatString(readUnicodeString(data + curOffset, formatStringLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
}

void FormatRecord::dump( std::ostream& out ) const
{
    out << "Format" << std::endl;
    out << "              Index : " << index() << std::endl;
    if (version() < Excel97) {
        out << "       FormatString : " << formatString() << std::endl;
    }
    if (version() >= Excel97) {
        out << "       FormatString : " << formatString() << std::endl;
    }
}

static Record* createFormatRecord()
{
    return new FormatRecord();
}

// ========== LabelRecord ==========

const unsigned LabelRecord::id = 0x0204;

class LabelRecord::Private
{
public:
    unsigned column;
    UString label;
    unsigned row;
    unsigned xfIndex;
};

LabelRecord::LabelRecord()
    : d(new Private)
{
    setColumn(0);
    setRow(0);
    setXfIndex(0);
}

LabelRecord::~LabelRecord()
{
    delete d;
}

LabelRecord::LabelRecord( const LabelRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

LabelRecord& LabelRecord::operator=( const LabelRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned LabelRecord::column() const
{
    return d->column;
}

void LabelRecord::setColumn(unsigned column )
{
    d->column = column;
}

UString LabelRecord::label() const
{
    return d->label;
}

void LabelRecord::setLabel(UString label )
{
    d->label = label;
}

unsigned LabelRecord::row() const
{
    return d->row;
}

void LabelRecord::setRow(unsigned row )
{
    d->row = row;
}

unsigned LabelRecord::xfIndex() const
{
    return d->xfIndex;
}

void LabelRecord::setXfIndex(unsigned xfIndex )
{
    d->xfIndex = xfIndex;
}

void LabelRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    bool stringLengthError = false;
    unsigned stringSize;
    if (size < 8) {
        setIsValid(false);
        return;
    }
    setRow(readU16(data));
    setColumn(readU16(data + 2));
    setXfIndex(readU16(data + 4));
    unsigned labelLength = readU16(data + 6);
    curOffset = 8;
    if (version() < Excel97) {
        setLabel(readByteString(data + curOffset, labelLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
    if (version() >= Excel97) {
        setLabel(readUnicodeString(data + curOffset, labelLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
}

void LabelRecord::dump( std::ostream& out ) const
{
    out << "Label" << std::endl;
    out << "                Row : " << row() << std::endl;
    out << "             Column : " << column() << std::endl;
    out << "            XfIndex : " << xfIndex() << std::endl;
    if (version() < Excel97) {
        out << "              Label : " << label() << std::endl;
    }
    if (version() >= Excel97) {
        out << "              Label : " << label() << std::endl;
    }
}

static Record* createLabelRecord()
{
    return new LabelRecord();
}

// ========== LabelSSTRecord ==========

const unsigned LabelSSTRecord::id = 0x00FD;

class LabelSSTRecord::Private
{
public:
    unsigned column;
    unsigned row;
    unsigned sstIndex;
    unsigned xfIndex;
};

LabelSSTRecord::LabelSSTRecord()
    : d(new Private)
{
    setColumn(0);
    setRow(0);
    setSstIndex(0);
    setXfIndex(0);
}

LabelSSTRecord::~LabelSSTRecord()
{
    delete d;
}

LabelSSTRecord::LabelSSTRecord( const LabelSSTRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

LabelSSTRecord& LabelSSTRecord::operator=( const LabelSSTRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned LabelSSTRecord::column() const
{
    return d->column;
}

void LabelSSTRecord::setColumn(unsigned column )
{
    d->column = column;
}

unsigned LabelSSTRecord::row() const
{
    return d->row;
}

void LabelSSTRecord::setRow(unsigned row )
{
    d->row = row;
}

unsigned LabelSSTRecord::sstIndex() const
{
    return d->sstIndex;
}

void LabelSSTRecord::setSstIndex(unsigned sstIndex )
{
    d->sstIndex = sstIndex;
}

unsigned LabelSSTRecord::xfIndex() const
{
    return d->xfIndex;
}

void LabelSSTRecord::setXfIndex(unsigned xfIndex )
{
    d->xfIndex = xfIndex;
}

void LabelSSTRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 10) {
        setIsValid(false);
        return;
    }
    setRow(readU16(data));
    setColumn(readU16(data + 2));
    setXfIndex(readU16(data + 4));
    setSstIndex(readU32(data + 6));
}

void LabelSSTRecord::dump( std::ostream& out ) const
{
    out << "LabelSST" << std::endl;
    out << "                Row : " << row() << std::endl;
    out << "             Column : " << column() << std::endl;
    out << "            XfIndex : " << xfIndex() << std::endl;
    out << "           SstIndex : " << sstIndex() << std::endl;
}

static Record* createLabelSSTRecord()
{
    return new LabelSSTRecord();
}

// ========== MergedCellsRecord ==========

const unsigned MergedCellsRecord::id = 0x00E5;

class MergedCellsRecord::Private
{
public:
    unsigned count;
    std::vector<unsigned> firstColumn;
    std::vector<unsigned> firstRow;
    std::vector<unsigned> lastColumn;
    std::vector<unsigned> lastRow;
};

MergedCellsRecord::MergedCellsRecord()
    : d(new Private)
{
    setCount(0);
}

MergedCellsRecord::~MergedCellsRecord()
{
    delete d;
}

MergedCellsRecord::MergedCellsRecord( const MergedCellsRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

MergedCellsRecord& MergedCellsRecord::operator=( const MergedCellsRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned MergedCellsRecord::count() const
{
    return d->count;
}

void MergedCellsRecord::setCount(unsigned count )
{
    d->count = count;
    d->firstRow.resize(count);
    d->lastRow.resize(count);
    d->firstColumn.resize(count);
    d->lastColumn.resize(count);
}

unsigned MergedCellsRecord::firstColumn( unsigned index ) const
{
    return d->firstColumn[index];
}

void MergedCellsRecord::setFirstColumn( unsigned index, unsigned firstColumn )
{
    d->firstColumn[index] = firstColumn;
}

unsigned MergedCellsRecord::firstRow( unsigned index ) const
{
    return d->firstRow[index];
}

void MergedCellsRecord::setFirstRow( unsigned index, unsigned firstRow )
{
    d->firstRow[index] = firstRow;
}

unsigned MergedCellsRecord::lastColumn( unsigned index ) const
{
    return d->lastColumn[index];
}

void MergedCellsRecord::setLastColumn( unsigned index, unsigned lastColumn )
{
    d->lastColumn[index] = lastColumn;
}

unsigned MergedCellsRecord::lastRow( unsigned index ) const
{
    return d->lastRow[index];
}

void MergedCellsRecord::setLastRow( unsigned index, unsigned lastRow )
{
    d->lastRow[index] = lastRow;
}

void MergedCellsRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    if (size < 2) {
        setIsValid(false);
        return;
    }
    setCount(readU16(data));
    curOffset = 2;
    for (unsigned i = 0, endi = count(); i < endi; ++i) {
        if (size < curOffset + 8) {
            setIsValid(false);
            return;
        }
        setFirstRow(i, readU16(data + curOffset));
        setLastRow(i, readU16(data + curOffset + 2));
        setFirstColumn(i, readU16(data + curOffset + 4));
        setLastColumn(i, readU16(data + curOffset + 6));
        curOffset += 8;
    }
}

void MergedCellsRecord::dump( std::ostream& out ) const
{
    out << "MergedCells" << std::endl;
    out << "              Count : " << count() << std::endl;
    for (unsigned i = 0, endi = count(); i < endi; ++i) {
        out << "       FirstRow " << std::setw(3) << i <<" : " << firstRow(i) << std::endl;
        out << "        LastRow " << std::setw(3) << i <<" : " << lastRow(i) << std::endl;
        out << "    FirstColumn " << std::setw(3) << i <<" : " << firstColumn(i) << std::endl;
        out << "     LastColumn " << std::setw(3) << i <<" : " << lastColumn(i) << std::endl;
    }
}

static Record* createMergedCellsRecord()
{
    return new MergedCellsRecord();
}

// ========== MulBlankRecord ==========

const unsigned MulBlankRecord::id = 0x00BE;

class MulBlankRecord::Private
{
public:
    unsigned firstColumn;
    unsigned lastColumn;
    unsigned row;
    std::vector<unsigned> xfIndex;
};

MulBlankRecord::MulBlankRecord()
    : d(new Private)
{
    setFirstColumn(0);
    setLastColumn(0);
    setRow(0);
}

MulBlankRecord::~MulBlankRecord()
{
    delete d;
}

MulBlankRecord::MulBlankRecord( const MulBlankRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

MulBlankRecord& MulBlankRecord::operator=( const MulBlankRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned MulBlankRecord::firstColumn() const
{
    return d->firstColumn;
}

void MulBlankRecord::setFirstColumn(unsigned firstColumn )
{
    d->firstColumn = firstColumn;
}

unsigned MulBlankRecord::lastColumn() const
{
    return d->lastColumn;
}

void MulBlankRecord::setLastColumn(unsigned lastColumn )
{
    d->lastColumn = lastColumn;
}

unsigned MulBlankRecord::row() const
{
    return d->row;
}

void MulBlankRecord::setRow(unsigned row )
{
    d->row = row;
}

unsigned MulBlankRecord::xfIndex( unsigned index ) const
{
    return d->xfIndex[index];
}

void MulBlankRecord::setXfIndex( unsigned index, unsigned xfIndex )
{
    d->xfIndex[index] = xfIndex;
}

void MulBlankRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    if (size < 4) {
        setIsValid(false);
        return;
    }
    setRow(readU16(data));
    setFirstColumn(readU16(data + 2));
    curOffset = 4;
    d->xfIndex.resize((size-6)/2);
    for (unsigned i = 0, endi = (size-6)/2; i < endi; ++i) {
        if (size < curOffset + 2) {
            setIsValid(false);
            return;
        }
        setXfIndex(i, readU16(data + curOffset));
        curOffset += 2;
    }
    if (size < curOffset + 2) {
        setIsValid(false);
        return;
    }
    setLastColumn(readU16(data + curOffset));
}

void MulBlankRecord::dump( std::ostream& out ) const
{
    out << "MulBlank" << std::endl;
    out << "                Row : " << row() << std::endl;
    out << "        FirstColumn : " << firstColumn() << std::endl;
    for (unsigned i = 0, endi = d->xfIndex.size(); i < endi; ++i) {
        out << "        XfIndex " << std::setw(3) << i <<" : " << xfIndex(i) << std::endl;
    }
    out << "         LastColumn : " << lastColumn() << std::endl;
}

static Record* createMulBlankRecord()
{
    return new MulBlankRecord();
}

// ========== NumberRecord ==========

const unsigned NumberRecord::id = 0x0203;

class NumberRecord::Private
{
public:
    unsigned column;
    double number;
    unsigned row;
    unsigned xfIndex;
};

NumberRecord::NumberRecord()
    : d(new Private)
{
    setColumn(0);
    setRow(0);
    setXfIndex(0);
}

NumberRecord::~NumberRecord()
{
    delete d;
}

NumberRecord::NumberRecord( const NumberRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

NumberRecord& NumberRecord::operator=( const NumberRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned NumberRecord::column() const
{
    return d->column;
}

void NumberRecord::setColumn(unsigned column )
{
    d->column = column;
}

double NumberRecord::number() const
{
    return d->number;
}

void NumberRecord::setNumber(double number )
{
    d->number = number;
}

unsigned NumberRecord::row() const
{
    return d->row;
}

void NumberRecord::setRow(unsigned row )
{
    d->row = row;
}

unsigned NumberRecord::xfIndex() const
{
    return d->xfIndex;
}

void NumberRecord::setXfIndex(unsigned xfIndex )
{
    d->xfIndex = xfIndex;
}

void NumberRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 14) {
        setIsValid(false);
        return;
    }
    setRow(readU16(data));
    setColumn(readU16(data + 2));
    setXfIndex(readU16(data + 4));
    setNumber(readFloat64(data + 6));
}

void NumberRecord::dump( std::ostream& out ) const
{
    out << "Number" << std::endl;
    out << "                Row : " << row() << std::endl;
    out << "             Column : " << column() << std::endl;
    out << "            XfIndex : " << xfIndex() << std::endl;
    out << "             Number : " << number() << std::endl;
}

static Record* createNumberRecord()
{
    return new NumberRecord();
}

// ========== PaletteRecord ==========

const unsigned PaletteRecord::id = 0x0092;

class PaletteRecord::Private
{
public:
    std::vector<unsigned> blue;
    unsigned count;
    std::vector<unsigned> green;
    std::vector<unsigned> red;
};

PaletteRecord::PaletteRecord()
    : d(new Private)
{
    setCount(0);
}

PaletteRecord::~PaletteRecord()
{
    delete d;
}

PaletteRecord::PaletteRecord( const PaletteRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

PaletteRecord& PaletteRecord::operator=( const PaletteRecord& record )
{
    *d = *record.d;
    return *this;
}

unsigned PaletteRecord::blue( unsigned index ) const
{
    return d->blue[index];
}

void PaletteRecord::setBlue( unsigned index, unsigned blue )
{
    d->blue[index] = blue;
}

unsigned PaletteRecord::count() const
{
    return d->count;
}

void PaletteRecord::setCount(unsigned count )
{
    d->count = count;
    d->red.resize(count);
    d->green.resize(count);
    d->blue.resize(count);
}

unsigned PaletteRecord::green( unsigned index ) const
{
    return d->green[index];
}

void PaletteRecord::setGreen( unsigned index, unsigned green )
{
    d->green[index] = green;
}

unsigned PaletteRecord::red( unsigned index ) const
{
    return d->red[index];
}

void PaletteRecord::setRed( unsigned index, unsigned red )
{
    d->red[index] = red;
}

void PaletteRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    if (size < 2) {
        setIsValid(false);
        return;
    }
    setCount(readU16(data));
    curOffset = 2;
    for (unsigned i = 0, endi = count(); i < endi; ++i) {
        if (size < curOffset + 4) {
            setIsValid(false);
            return;
        }
        setRed(i, readU8(data + curOffset));
        setGreen(i, readU8(data + curOffset + 1));
        setBlue(i, readU8(data + curOffset + 2));
        curOffset += 4;
    }
}

void PaletteRecord::dump( std::ostream& out ) const
{
    out << "Palette" << std::endl;
    out << "              Count : " << count() << std::endl;
    for (unsigned i = 0, endi = count(); i < endi; ++i) {
        out << "            Red " << std::setw(3) << i <<" : " << red(i) << std::endl;
        out << "          Green " << std::setw(3) << i <<" : " << green(i) << std::endl;
        out << "           Blue " << std::setw(3) << i <<" : " << blue(i) << std::endl;
    }
}

static Record* createPaletteRecord()
{
    return new PaletteRecord();
}

// ========== RowRecord ==========

const unsigned RowRecord::id = 0x0208;

class RowRecord::Private
{
public:
    bool collapsed;
    unsigned firstColumn;
    unsigned height;
    bool hidden;
    unsigned lastColumnPlus1;
    unsigned outlineLevel;
    unsigned row;
    unsigned xfIndex;
};

RowRecord::RowRecord()
    : d(new Private)
{
    setCollapsed(false);
    setFirstColumn(0);
    setHeight(0);
    setHidden(false);
    setLastColumnPlus1(0);
    setOutlineLevel(0);
    setRow(0);
    setXfIndex(0);
}

RowRecord::~RowRecord()
{
    delete d;
}

RowRecord::RowRecord( const RowRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

RowRecord& RowRecord::operator=( const RowRecord& record )
{
    *d = *record.d;
    return *this;
}

bool RowRecord::isCollapsed() const
{
    return d->collapsed;
}

void RowRecord::setCollapsed(bool collapsed )
{
    d->collapsed = collapsed;
}

unsigned RowRecord::firstColumn() const
{
    return d->firstColumn;
}

void RowRecord::setFirstColumn(unsigned firstColumn )
{
    d->firstColumn = firstColumn;
}

unsigned RowRecord::height() const
{
    return d->height;
}

void RowRecord::setHeight(unsigned height )
{
    d->height = height;
}

bool RowRecord::isHidden() const
{
    return d->hidden;
}

void RowRecord::setHidden(bool hidden )
{
    d->hidden = hidden;
}

unsigned RowRecord::lastColumnPlus1() const
{
    return d->lastColumnPlus1;
}

void RowRecord::setLastColumnPlus1(unsigned lastColumnPlus1 )
{
    d->lastColumnPlus1 = lastColumnPlus1;
}

unsigned RowRecord::outlineLevel() const
{
    return d->outlineLevel;
}

void RowRecord::setOutlineLevel(unsigned outlineLevel )
{
    d->outlineLevel = outlineLevel;
}

unsigned RowRecord::row() const
{
    return d->row;
}

void RowRecord::setRow(unsigned row )
{
    d->row = row;
}

unsigned RowRecord::xfIndex() const
{
    return d->xfIndex;
}

void RowRecord::setXfIndex(unsigned xfIndex )
{
    d->xfIndex = xfIndex;
}

void RowRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    if (size < 16) {
        setIsValid(false);
        return;
    }
    setRow(readU16(data));
    setFirstColumn(readU16(data + 2));
    setLastColumnPlus1(readU16(data + 4));
    setHeight(readU16(data + 6));
    setOutlineLevel((readU8(data + 12)) & 0x7);
    setCollapsed((readU8(data + 12) >> 4) & 0x1 != 0);
    setHidden((readU8(data + 12) >> 5) & 0x1 != 0);
    setXfIndex((readU16(data + 14)) & 0xfff);
}

void RowRecord::dump( std::ostream& out ) const
{
    out << "Row" << std::endl;
    out << "                Row : " << row() << std::endl;
    out << "        FirstColumn : " << firstColumn() << std::endl;
    out << "    LastColumnPlus1 : " << lastColumnPlus1() << std::endl;
    out << "             Height : " << height() << std::endl;
    out << "       OutlineLevel : " << outlineLevel() << std::endl;
    out << "          Collapsed : " << isCollapsed() << std::endl;
    out << "             Hidden : " << isHidden() << std::endl;
    out << "            XfIndex : " << xfIndex() << std::endl;
}

static Record* createRowRecord()
{
    return new RowRecord();
}

// ========== StringRecord ==========

const unsigned StringRecord::id = 0x0207;

class StringRecord::Private
{
public:
    UString ustring;
};

StringRecord::StringRecord()
    : d(new Private)
{
}

StringRecord::~StringRecord()
{
    delete d;
}

StringRecord::StringRecord( const StringRecord& record )
    : Record(record), d(new Private)
{
    *this = record;
}

StringRecord& StringRecord::operator=( const StringRecord& record )
{
    *d = *record.d;
    return *this;
}

UString StringRecord::ustring() const
{
    return d->ustring;
}

void StringRecord::setUstring(UString ustring )
{
    d->ustring = ustring;
}

Value StringRecord::value() const
{
    return Value(ustring());
}

void StringRecord::setData( unsigned size, const unsigned char* data, const unsigned int* )
{
    unsigned curOffset;
    bool stringLengthError = false;
    unsigned stringSize;
    if (size < 2) {
        setIsValid(false);
        return;
    }
    unsigned stringLength = readU16(data);
    curOffset = 2;
    if (version() < Excel97) {
        setUstring(readByteString(data + curOffset, stringLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
    if (version() >= Excel97) {
        setUstring(readUnicodeString(data + curOffset, stringLength, size - curOffset, &stringLengthError, &stringSize));
        if (stringLengthError) {
            setIsValid(false);
            return;
        }
        curOffset += stringSize;
    }
}

void StringRecord::dump( std::ostream& out ) const
{
    out << "String" << std::endl;
    if (version() < Excel97) {
        out << "            Ustring : " << ustring() << std::endl;
    }
    if (version() >= Excel97) {
        out << "            Ustring : " << ustring() << std::endl;
    }
}

static Record* createStringRecord()
{
    return new StringRecord();
}

void registerRecordClasses()
{
    RecordRegistry::registerRecordClass(BackupRecord::id, createBackupRecord);
    RecordRegistry::registerRecordClass(EOFRecord::id, createEOFRecord);
    RecordRegistry::registerRecordClass(BlankRecord::id, createBlankRecord);
    RecordRegistry::registerRecordClass(BoolErrRecord::id, createBoolErrRecord);
    RecordRegistry::registerRecordClass(LeftMarginRecord::id, createLeftMarginRecord);
    RecordRegistry::registerRecordClass(RightMarginRecord::id, createRightMarginRecord);
    RecordRegistry::registerRecordClass(TopMarginRecord::id, createTopMarginRecord);
    RecordRegistry::registerRecordClass(BottomMarginRecord::id, createBottomMarginRecord);
    RecordRegistry::registerRecordClass(BoundSheetRecord::id, createBoundSheetRecord);
    RecordRegistry::registerRecordClass(CalcModeRecord::id, createCalcModeRecord);
    RecordRegistry::registerRecordClass(ColInfoRecord::id, createColInfoRecord);
    RecordRegistry::registerRecordClass(DataTableRecord::id, createDataTableRecord);
    RecordRegistry::registerRecordClass(DateModeRecord::id, createDateModeRecord);
    RecordRegistry::registerRecordClass(DimensionRecord::id, createDimensionRecord);
    RecordRegistry::registerRecordClass(ExternSheetRecord::id, createExternSheetRecord);
    RecordRegistry::registerRecordClass(FontRecord::id, createFontRecord);
    RecordRegistry::registerRecordClass(HeaderRecord::id, createHeaderRecord);
    RecordRegistry::registerRecordClass(FooterRecord::id, createFooterRecord);
    RecordRegistry::registerRecordClass(FormatRecord::id, createFormatRecord);
    RecordRegistry::registerRecordClass(LabelRecord::id, createLabelRecord);
    RecordRegistry::registerRecordClass(LabelSSTRecord::id, createLabelSSTRecord);
    RecordRegistry::registerRecordClass(MergedCellsRecord::id, createMergedCellsRecord);
    RecordRegistry::registerRecordClass(MulBlankRecord::id, createMulBlankRecord);
    RecordRegistry::registerRecordClass(NumberRecord::id, createNumberRecord);
    RecordRegistry::registerRecordClass(PaletteRecord::id, createPaletteRecord);
    RecordRegistry::registerRecordClass(RowRecord::id, createRowRecord);
    RecordRegistry::registerRecordClass(StringRecord::id, createStringRecord);
}

} // namespace Swinder
