using GConf;

public class Settings: GLib.Object
{
	GConf.Client client;
	
	construct
	{
		client = GConf.Client.get_default();
	}
	
	public void set_value(string key, string value)
	{
		try
		{
			client.set_string("/apps/knots/" + key, (string)value);
		}
		catch (GLib.Error e)
		{
			print("%s\n", e.message);
		}
	}
	
	public void unset_value(string key)
	{
		try
		{
			client.unset("/apps/knots/" + key);
		}
		catch (GLib.Error e)
		{
			print("%s\n", e.message);
		}
	}
	
	public string? get_value(string key)
	{
		try
		{
			return client.get_string("/apps/knots/" + key);
		}
		catch (GLib.Error e)
		{
			print("%s\n", e.message);
			return null;
		}
	}
	
	public GConf.Client get_gconf()
	{
		return client;	
	}
	
	
	public string get_value_default_to(string key, string default_value)
	{
		string val = get_value(key);
		if (val == null)
			val = default_value;
		return val;
	}
}
