using GLib;
using Gtk;
using Pango;

public class Item : Gtk.Fixed
{
	Knots knots;
	HashTable fields;
	Gtk.Label label;
	string text;
	int item_type;
	public static int CATEGORY = 0;
	public static int TAG = 1;
	public static int VALUE = 2;
	public static int ITEM = 3;
	public static int DIR = 4;
	public static int VIRTUAL = 5;
	public static int SERVER = 6;
	public static int BUTTON = 7;
	EventBox eb;
	Gtk.Image image;
	private bool icon_view;
	private bool clicked;
	
	public Item(Knots knots, HashTable fields, bool icon_view) {
		this.knots = knots;
		this.fields = fields;
		this.icon_view = icon_view;
		init_widget();
	}
	
	public void set_clicked(bool clicked)
	{
		this.clicked = clicked;
	}
	
	public bool was_clicked()
	{
		return this.clicked;
	}
	
	public bool has_icon_view()
	{
		return this.icon_view;
	}
	
	public void init_widget()
	{
		string[] types = {"category", "tag", "value", "name", "dirname", "virtual", "server", "button"};
		for (int i = 0; i < types.length; i++)
		{
			if (fields.lookup(types[types.length - 1 - i]) != null)
			{
				text = (string)fields.lookup(types[types.length - 1 - i]);
				item_type = types.length - 1 - i;
				break;
			}
		}
		if (icon_view)
		{
			image = new Gtk.Image();
			load_image();
		}
	}
	
	public void create()
	{
		this.width_request = width();
		this.height_request = height();
		if (icon_view)
		{
			if (text.len() > 25)
				text = text.substring(0, 25);
			/*
			background = knots.get_common().get_item_background_image();
			background.width_request = width();
			background.height_request = height();
			this.put(background, 0, 0);
			*/
			eb = new EventBox();
			eb.width_request = 160;
			eb.height_request = 125;
			knots.change_background_color(eb, "#000000");
			this.put(eb, 0, 0);
			label = new Label(get_item_label());
			knots.change_foreground_color(label, "#eeeeee");
			label.set_justify(Gtk.Justification.CENTER);
			label.height_request = 15;
			label.width_request = 140;
			this.put(label, 10, 135);
			Pango.FontDescription f = label.get_pango_context().get_font_description();
			f.set_size(1024 * 10);
			label.modify_font(f);
			knots.change_background_color(this, "#000000");
			image.width_request = 140;
			image.height_request = 105;
			eb.add(image);
			knots.change_background_color(this, "#000000");
		}
		else
		{
			eb = new EventBox();
			eb.width_request = width();
			eb.height_request = height();
			knots.change_background_color(eb, "#111111");
			this.put(eb, 0, 0);
			label = new Label(get_item_label());
			label.set_justify(Gtk.Justification.LEFT);
			knots.change_foreground_color(label, "#eeeeee");
			eb.add(label);
			image = new Gtk.Image();
			knots.change_background_color(this, "#111111");
			
		}
	}
	
	public void new_width(int width)
	{
		var children = get_children();
		foreach (Gtk.Widget child in children)
		{
			child.width_request = width;
		}
		this.width_request = width;
	}
	
	
	public string get_item_attribute(string key)
	{
		return (string)fields.lookup(key);
	}
	
	public int get_item_type()
	{
		return item_type;
	}
	
	public string get_item_label()
	{
		return text;
	}
	
	public int get_item_id()
	{
		return get_item_attribute("id").to_int();
	}
	
	public string get_plot()
	{
		return get_item_attribute("info");
	}
	
	public Gtk.Image get_image()
	{
		return image;
	}
	
	public bool item_selected(Gdk.EventButton? eb, long press_seconds)
	{
		if (true)
		{
			if (get_item_type() == BUTTON)
			{
				highlight();
				this.queue_draw();
				if (get_item_id() == 1)
					knots.connect_server_automatically();
				else
				if (get_item_id() == 2)
					knots.connect_server_manually();
			}
			else
			if (get_item_type() == SERVER)
			{
				highlight();
				this.queue_draw();
				knots.get_connection().select_server(get_item_id());
				knots.get_browser().clear();
				knots.get_browser().browse();
				knots.get_playlist().update_playlists();
				knots.get_playlist().select_playlist(1);
				knots.get_playlist().set_update_need(true);
				knots.update_transcode_profiles();
			}
			else
			if (get_item_type() == DIR)
			{
				highlight();
				this.queue_draw();
				knots.get_browser().browse_by_path(get_item_attribute("dir"), false);
			}
			else
			if (get_item_type() == VIRTUAL)
			{
				highlight();
				this.queue_draw();
				knots.get_browser().show_virtual_category(get_item_attribute("search"), 1);
			}
			else
			if (get_item_type() != ITEM)
			{
				highlight();
				knots.get_browser().browsepaths[get_item_type()] = get_item_id();
				knots.get_browser().pages[get_item_type()] = 1;
				this.queue_draw();
				knots.get_browser().browse();
			}
			else
			{
				knots.get_info().show_info(this);
			}
		}
		return false;
	}
	
	public void highlight()
	{
		knots.change_foreground_color(label, "#FB8F00");
	}
	
	public void lowlight()
	{
		knots.change_foreground_color(label, "#ffffff");
	}
	
	public void load_image()
	{
		if (this.icon_view && get_item_attribute("mid") != null && get_item_attribute("mid") != "")
		{
			Gtk.Image img = knots.get_common().cached_image(get_item_attribute("mid"));
			if (img == null)
			{
				string url = (knots.get_connection().uses_ssl() ? "https" : "http") + "://" + knots.get_connection().address() + "/root/resource_file?type=screenshot&mid=" + get_item_attribute("mid") + "&mediatype=0";
				var session = new Soup.SessionSync ();
				var message = new Soup.Message ("GET", url);
				session.authenticate +=  (sess, msg, auth, retrying) => {
				    if (retrying)
				    {
					return;
				    }
				    knots.get_connection().authenticate();
				    auth.authenticate(knots.get_connection().username(),knots.get_connection().password());
				};
				message.got_body += (message) => {
					try
					{
						
						var filename = "/tmp/knots" + get_item_id().to_string();
						FileUtils.set_contents (filename, message.response_body.data, (int)message.response_body.length);
						Gtk.Image img2 = new Gtk.Image.from_file(filename);
						image.set_from_pixbuf(img2.get_pixbuf()); 
						FileUtils.unlink(filename);
						knots.get_common().cache_image(get_item_attribute("mid"), img2);
					}
					catch (GLib.Error e)
					{
						image.set_from_pixbuf(knots.get_common().get_default_item_image().get_pixbuf());
					}
				};
				session.send_message (message);
			}
			else
			{
				image.set_from_pixbuf(img.get_pixbuf());
			}
		}
		else
		{
			image.set_from_pixbuf(knots.get_common().get_default_item_image().get_pixbuf());
		}
	}
	
	public int width()
	{
		return icon_view ? 180 : knots.get_window().allocation.width;
		
	}
	
	public int height()
	{
		return icon_view ? 160 : 60;
	}
}
