using GLib;
using Gtk;
using Hildon;
using Gdk;
using Xml;
using GConf;
using Osso;
using ConIc;

public class Knots : Hildon.Program
{
	Progress progress;
	Common common;
	Settings settings;
        Hildon.StackableWindow window;
	bool fullscreen;
	Discovery discovery;
	public Osso.Context context;
	Notebook nb;
	public int ORIENTATION = 0;
	public int LANDSCAPE = 0;
	public int PORTRAIT = 1;
	private string version = Version.VERSION;
	public static bool visible;
	public static bool topmost;
	private int rotation;
	private bool updating_collection;
	ConIc.Connection con;
	private bool connected;
	private Hildon.Button profile;
	private Hildon.Button current_rotation;
	private Hildon.Button dynknots_auth_button;
	private Hildon.Button go_to_root;
	private Hildon.CheckButton icon_view;
	private Hildon.Button update_item;
	private HashTable<string,string> profileids;
	private int screen_width;
	private int screen_height;
	private bool show_debug;
	private Gtk.AboutDialog about;
	
	static int main (string[] args)
	{
                Gtk.init (ref args);
                Knots knots = new Knots ();
                knots.run();
                return 0;
        }
	
        public void run()
	{
		settings = new Settings();
		progress = new Progress(this);
		show_debug = get_settings().get_value_default_to("debug", "false") == "true";
		discovery = new Discovery(this);
		this.topmost = true;
		context = new Osso.Context("com.nokia.knots2", version, false, null);
		common = new Common(this);
		fullscreen = false;
		Gdk.threads_enter();
                window = new Hildon.StackableWindow ();
                add_window (window);
		Environment.set_application_name("Knots");
		window.key_release_event += (widget, event) => {
			return key_event(widget, event);
		};
		create_layout();
		create_menu();
		//window.check_resize += check_orientation;
		window.focus_in_event += do_focus_check;
		window.focus_out_event += do_focus_check;
		context.set_hw_display_event_callback(display_event, this);
		window.show_all ();
		get_browser().get_toolbar_button(5).hide();
		get_browser().get_toolbar().hide();
		window.destroy += clean_up;
		con = new ConIc.Connection();
		connect_server_automatically();
		int last_rotation = get_settings().get_value_default_to("rotation", "0").to_int();
		if (last_rotation != rotation)
		{
			set_rotation(last_rotation);
		}
		Gdk.Display.get_default().get_default_screen().size_changed += check_orientation;
                Gtk.main ();
		Gdk.threads_leave();
        }
	
	public Progress get_progress()
	{
		return progress;
	}
	
	public void set_title(string title)
	{
		window.set_title(title);
	}

	public ConIc.Connection get_conic()
	{
		return con;
	}

	
	public void create_layout()
	{
		nb = new Notebook();
		nb.show_border = false;
		nb.show_tabs = false;
		Browser browser = new Browser();
		browser.init(this);
		Info info = new Info();
		info.init(this);
		Player player = new Player();
		player.init(this);
		Playlist playlist = new Playlist();
		playlist.init(this);
		nb.append_page(browser, null);
		nb.append_page(info, null);
		nb.append_page(player, null);
		nb.append_page(playlist, null);
		change_background_color(window, "#000000");
		window.add(nb);
	}
	
	public void create_menu()
	{	
		Hildon.AppMenu menu = new Hildon.AppMenu();
		add_connect_menu(menu);
		add_root_menu(menu);
		add_iconview_menu(menu);
		add_clear_menu(menu);
		add_rotation_menu(menu);
		add_update_collection_menu(menu);
		add_profile_menu(menu);
		add_dynknots_menu(menu);
		add_about_menu(menu);
		/*
		
		add_sort_menu(menu);
		add_rotation_menu(menu);
		add_profile_menu(menu);
		add_iconview_menu(menu);
		add_clear_menu(menu);
		add_update_collection_menu(menu);
		add_about_menu(menu);
		*/
		menu.show_all();
		window.set_main_menu(menu);
		
	}
	
	public void add_connect_menu(Hildon.AppMenu menu)
	{
		Hildon.Button connect_automatically = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Connect automatically", "");
		connect_automatically.clicked += connect_server_automatically;
		Hildon.Button connect_manually = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Connect manually", "");
		connect_manually.clicked += connect_server_manually;
		menu.append(connect_automatically);
		menu.append(connect_manually);
		/*
		Gtk.Menu connect_menu = new Gtk.Menu();
		Gtk.MenuItem connect_automatically = new Gtk.MenuItem.with_label("Automatically");
		connect_automatically.activate += connect_server_automatically;
		Gtk.MenuItem connect_manually = new Gtk.MenuItem.with_label("Manually");
		connect_manually.activate += connect_server_manually;
		Gtk.MenuItem connect_menu_item = new Gtk.MenuItem.with_label("Connect");
		connect_menu.add(connect_automatically);
		connect_menu.add(connect_manually);
		connect_menu_item.set_submenu(connect_menu);
		menu.append(connect_menu_item);
		*/
	}
	
	public void add_root_menu(Hildon.AppMenu menu)
	{
		go_to_root = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Go to root", "");
		go_to_root.clicked += get_browser().go_to_root;
		menu.append(go_to_root);
	}
	/*
	public void add_aspect_menu(Gtk.Menu menu)
	{
		Gtk.Menu aspectmenu = new Gtk.Menu();
		string[] fields = {"none", "16:9", "4:3"};
		string current_aspect = get_settings().get_value_default_to("aspect", "none");
		for (int i = 0; i < fields.length; i++)
		{
			CheckMenuItem cmi = new CheckMenuItem.with_label(fields[i]);
			if (current_aspect == fields[i])
				cmi.active = true;
			cmi.draw_as_radio = true;
			aspectmenu.append(cmi);
			cmi.toggled += (w) => {
				if (w.draw_as_radio)
					get_player().change_aspect(w);
			};
		}
		Gtk.MenuItem aspect = new Gtk.MenuItem.with_label("Video aspect");
		aspect.set_submenu(aspectmenu);
		menu.append(aspect);
	}
	*/
	public void add_clear_menu(Hildon.AppMenu menu)
	{
		Hildon.Button clear_caches = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Clear cache", "");
		clear_caches.clicked += (w) => {
			get_common().clear_cache(2);
		};
		menu.append(clear_caches);
	}
	
	public void add_sort_menu(Gtk.Menu menu)
	{
		Gtk.Menu sortmenu = new Gtk.Menu();
		string[] fields = {"date added", "date modified", "name", "duration", "resume position", "path", "size", "views", "random"};
		string[] sorts = get_settings().get_value_default_to("sort", "0").split(",", 0);
		for (int i = 0; i < fields.length; i++)
		{
			CheckMenuItem cmi = new CheckMenuItem.with_label(fields[i]);
			sortmenu.append(cmi);
			cmi.toggled += (w) => {
				get_browser().change_sort(w);
			};
		}
		foreach(string token in sorts)
		{
			get_browser().select_sortable(sortmenu, token.to_int(), true);
		}
		Gtk.MenuItem sort = new Gtk.MenuItem.with_label("Sort items by");
		sort.set_submenu(sortmenu);
		menu.append(sort);
	}
	
	public void add_profile_menu(Hildon.AppMenu menu)
	{
		profile = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Transcoding profile", "");
		profile.clicked += change_transcoding_profile;
		menu.append(profile);
	}
	
	public void add_iconview_menu(Hildon.AppMenu menu)
	{
		icon_view = new Hildon.CheckButton(SizeType.FINGER_HEIGHT);
		icon_view.set_alignment((float)0.5, (float)0.5);
		icon_view.set_label("Show icons");
		bool active = get_settings().get_value_default_to("icon_view", "true") == "true";
		icon_view.set_active(active);
		get_browser().set_icon_view(active);
		icon_view.toggled += (w) => {
			get_browser().set_icon_view(((Hildon.CheckButton)w).get_active());
			get_browser().browse();
		};
		menu.append(icon_view);
	}
	
	public void disable_menus(bool disable)
	{
		if (disable)
		{
			profile.hide();
			go_to_root.hide();
			icon_view.hide();
			update_item.hide();
		}
		else
		{
			profile.show();
			go_to_root.show();
			icon_view.show();
			update_item.show();
		}
	}
	
	public void update_transcode_profiles()
	{
		bool selected_profile = false;
		string current_profile = get_settings().get_value_default_to("transcoding_profile", "6");
		profileids = new HashTable<string,string>(str_hash, str_equal);
		get_connection().set_url_cache(false);
		XMList list = new XMList(get_connection().fetch("/external/transcoding_profiles"));
		foreach(HashTable ht in list.items())
		{
			string profile_id = (string)ht.lookup("id");
			if (profile_id == current_profile)
				selected_profile = true;
		}
		if (!selected_profile)
		{
			current_profile = "2";
			get_settings().set_value("transcoding_profile", current_profile);
		}
		foreach(HashTable ht in list.items())
		{
			string profile_name = (string)ht.lookup("name");
			string profile_id = (string)ht.lookup("id");
			profileids.insert(profile_name, profile_id);
			if (profile_id == current_profile)
			{
				profile.set_value(profile_name);
			}
		}
		disable_menus(false);
	}
	
	public void change_transcoding_profile()
	{
		var dialog = new PickerDialog (window);
		gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
		dialog.set_title ("Select transcoding profile");
		ListStore profilenames = new ListStore (1, typeof (string));
		TreeIter iter;
		GLib.List pnames = profileids.get_keys();
		int selected = 0;
		for (int i = 0; i < pnames.length(); i++) {
			string pname = (string)pnames.nth_data(i);
			profilenames.append (out iter);
			profilenames.set_value (iter, 0, pname);
			if (profile.get_value() == pname)
				selected = i;
		}

		var selector = new TouchSelector ();
		selector.append_text_column (profilenames, true);
		dialog.set_selector (selector);
		selector.set_active(0, selected);
		var res = dialog.run ();
		if (res == ResponseType.OK)
		{
			string new_profile = (string)pnames.nth_data(selector.get_active(0));
			string new_profile_id = (string)profileids.lookup(new_profile);
			get_settings().set_value("transcoding_profile", new_profile_id);
			profile.set_value(new_profile);
		}
		dialog.destroy ();
	}
	
	public void add_rotation_menu(Hildon.AppMenu menu)
	{
		current_rotation = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Rotation", get_rotation() == 0 ? "Landscape" : "Portrait");
		current_rotation.clicked += (w) => {
			set_rotation(get_rotation() == 0 ? 1 : 0);
			get_settings().set_value("rotation", get_rotation() == 0 ? "1" : "0");
		};
		menu.append(current_rotation);
	}
	
	public void add_update_collection_menu(Hildon.AppMenu menu)
	{
		update_item = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Update collection", "");
		updating_collection = false;
		update_item.clicked += () => {
			if (!updating_collection && get_connection().connected())
			{
				MessageDialog dialog = new MessageDialog.with_markup(null, 0, Gtk.MessageType.QUESTION, Gtk.ButtonsType.OK_CANCEL, "Update collection?");
				dialog.set_image(new Gtk.Image.from_file("/usr/share/knots/knots_button_playlist.png"));
				gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
				var response = dialog.run();
				if (response == ResponseType.OK)
				{
					alert("Updating collection");
					update_item.set_value("Updating");
					try
					{
						Thread.create(update_collection, true);
					}
					catch (GLib.Error e)
					{
					
					}
				}
				dialog.destroy();
			}
		};
		menu.append(update_item);
	}
	
	public void* update_collection()
	{
		updating_collection = true;
		get_connection().set_url_cache(false);
		get_connection().fetch("/root/update_collection");
		updating_collection = false;
		GLib.Idle.add(stop_collection_update);
		return null;
	}
	
	public bool stop_collection_update()
	{
		update_item.set_value("");
		return false;
	}
	
	public void add_about_menu(Hildon.AppMenu menu)
	{
		Hildon.Button about_item = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "About", "");
		about_item.clicked += show_about;
		menu.append(about_item);	
	}
	
	public void show_about()
	{
		if (about == null)
		{
			Gtk.AboutDialog about = new Gtk.AboutDialog();
			gtk_window_set_portrait_flags(about, Hildon.PortraitFlags.SUPPORT);
			about.version = get_version();
			about.copyright = "Copyright © 2009 Janne Mäkinen";
			about.wrap_license = true;
			about.website = "http://wiki.maemo.org/Knots2";
			about.set_authors({"Janne Mäkinen <janne.makinen@surffi.fi>"});
			about.set_artists({"Human-O2 IconsSet", "Oliver Scholtz"});
			try
			{
				about.logo = new Gdk.Pixbuf.from_file("/usr/share/icons/hicolor/scalable/apps/knots2.png");
			}
			catch (GLib.Error e)
			{
				print("%s\n", e.message);
			}
			about.response += () => { about.hide(); };
			about.show_all();
		}
		else
		{
			about.show_all();
		}
	}
	
	public void toggle_fullscreen()
	{
		fullscreen = !fullscreen;
		if (fullscreen)
			window.fullscreen();
		else
			window.unfullscreen();
	}

	public static void display_event(Osso.DisplayState state, void* data)
	{
		Knots knots = (Knots)data;
		if (state == Osso.DisplayState.ON)
			visible = true;
		else
		if (state == Osso.DisplayState.OFF)
			visible = false;
		for (int i = 0; i < knots.get_notebook().get_n_pages(); i++)
		{
			((PageWidget)knots.get_notebook().get_nth_page(i)).display_state_changed(state);
		}
	}

	public Settings get_settings()
	{
		return settings;
	}
	
	public bool is_visible()
	{
		return visible && topmost;
	}
	
	public void set_rotation(int i)
	{
		if (i == 0)
			gtk_window_set_portrait_flags(window, Hildon.PortraitFlags.SUPPORT);
		else
			gtk_window_set_portrait_flags(window, Hildon.PortraitFlags.REQUEST);
		current_rotation.set_value(i == 0 ? "Landscape" : "Portrait");
	}
	
	public bool is_fullscreen()
	{
		return this.fullscreen;
	}
	
	public int get_rotation()
	{
		return this.ORIENTATION;
	}
	
	public Hildon.Window get_window()
	{
		return window;
	}
	
	public string get_version()
	{
		return version;
	}
	
	public bool check_topmost()
	{
		if (window.get_is_topmost() != topmost)
		{
			topmost = window.get_is_topmost();
			for (int i = 0; i < get_notebook().get_n_pages(); i++)
			{
				((PageWidget)get_notebook().get_nth_page(i)).window_state_changed(topmost);
			}
			
		}
		return false;
	}
	
	public void add_dynknots_menu(Hildon.AppMenu menu)
	{
		dynknots_auth_button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Remote discovery", get_settings().get_value("dynknots_key") != null ? "Enabled" : "Disabled");
		dynknots_auth_button.clicked += (w) => {
			dynknots_auth();
		};
		menu.append(dynknots_auth_button);
	}
	
	public void dynknots_auth()
	{
		Hildon.LoginDialog login = new LoginDialog(get_window());
		login.set_message("Login with your remote discovery credentials.\nAccount can be created in server settings.");
		var response = login.run();
		if (response == ResponseType.OK)
		{
			string username = login.get_username();
			string password = login.get_password();
			string key = get_connection().fetch_from_address("/knots2/dynknots.php?action=login&username=" + username + "&password=" + password, "nakkiboso.com");
			if (key != null && key.strip().length == 16)
			{
				get_settings().set_value("dynknots_key", key.strip());
				alert("Authentication successful");
				dynknots_auth_button.set_value("Enabled");
			}
			else
			{
				get_settings().unset_value("dynknots_key");
				alert("Authentication failed");
				dynknots_auth_button.set_value("Disabled");
			}
		}
		login.destroy();
	}
	
	public bool do_focus_check(EventFocus event)
	{
		GLib.Timeout.add(200, check_topmost);
		return false;
	}
	
	public void check_orientation()
	{
		screen_width = window.get_screen().get_width();
		screen_height = window.get_screen().get_height();
		int new_orientation =  screen_width > screen_height ? LANDSCAPE : PORTRAIT;
		if (new_orientation != ORIENTATION)
		{
			ORIENTATION = new_orientation;
			for (int i = 0; i < nb.get_n_pages(); i++)
			{
				((PageWidget)nb.get_nth_page(i)).orientation_change();
			}
		}
	}
	
	public int get_screen_width()
	{
		return screen_width;
	}
	
	public int get_screen_height()
	{
		return screen_height;
	}
	
	public Discovery get_connection()
	{
		return discovery;
	}
	
	public void connect_server_manually()
	{
		if (!get_player().is_playing())
		{
			if (!connected)
			{
				alert("Trying to connect, please wait.");
				con.connection_event += (s) => {
					if (s.get_status() == ConIc.ConnectionStatus.CONNECTED || get_settings().get_value("ignore_conic") != null)
					{
						this.connected = true;
						connect_server_manually();
					}
					else
					{
						disconnect_servers();
					}
				};
				con.connect(ConIc.ConnectFlags.NONE);
			}
			else
			{
				string? server = get_connection().show_address_dialog();
				if (server != null)
				{
					if (get_connection().load_connection(server, true, true))
					{
						get_connection().add_server(server);
					}
				}
				if (get_connection().server_count() == 1)
				{
					alert("Connected to server " + get_connection().server_name());
					get_browser().clear();
					get_browser().browse();
					get_playlist().update_playlists();
					get_playlist().select_playlist(1);
					get_playlist().update_items();
					update_transcode_profiles();
				}
				else
				if (get_connection().server_count() > 1)
				{
					get_browser().show_serverlist();
				}
				else
				{
					disconnect_servers();
				}
				get_browser().reveal();
			}
		}
	}
	
	public void connect_server_automatically()
	{
		if (!get_player().is_playing())
		{
			if (!connected)
			{
				alert("Trying to connect, please wait.");
				con.connection_event += (s) => {
					if (s.get_status() == ConIc.ConnectionStatus.CONNECTED || get_settings().get_value("ignore_conic") != null)
					{
						this.connected = true;
						connect_server_automatically();
					}
					else
					{
						disconnect_servers();
					}
				};
				con.connect(ConIc.ConnectFlags.NONE);
			}
			else
			{
				get_connection().discover_server_address();
				if (get_connection().server_count() == 1)
				{
					alert("Connected to server " + get_connection().server_name());
					get_browser().clear();
					get_browser().browse();
					get_playlist().update_playlists();
					get_playlist().select_playlist(1);
					get_playlist().set_update_need(true);
					update_transcode_profiles();
				}
				else
				if (get_connection().server_count() > 1)
				{
					get_browser().show_serverlist();
				}
				else
				{
					disconnect_servers();
				}
				get_browser().reveal();
			}
		}
	}
	
	public void disconnect_servers()
	{
		alert("Not connected to server");
		get_browser().show_disconnect_message();
		disable_menus(true);
	}
	
	public Common get_common()
	{
		return common;
	}
	
	public Browser get_browser()
	{
		return (Browser)nb.get_nth_page(0);
	}
	
	public Info get_info()
	{
		return (Info)nb.get_nth_page(1);
	}
	
	public Playlist get_playlist()
	{
		return (Playlist)nb.get_nth_page(3);
	}
	
	public Player get_player()
	{
		return (Player)nb.get_nth_page(2);
	}
	
	public Notebook get_notebook()
	{
		return nb;
	}
	
	public void change_volume(bool up)
	{
		
		try
		{
			var client = GConf.Client.get_default();
			int vol = client.get_int("/apps/osso/sound/master_volume");
			if (up)
				vol += 5;
			else
				vol -= 5;
			if (vol > 100)
				vol = 100;
			else
			if (vol < 0)
				vol = 0;
			client.set_int("/apps/osso/sound/master_volume", vol);
			alert("Volume changed to " + vol.to_string());
		}
		catch (GLib.Error ge)
		{
		
		}
	}
	
	public void change_background_color(Widget widget, string col)
	{
		/*
		Gdk.Color color;
		Gdk.Color.parse(col, out color);
		widget.modify_bg (Gtk.StateType.NORMAL, color);
		widget.modify_bg (Gtk.StateType.SELECTED, color);
		widget.modify_bg (Gtk.StateType.ACTIVE, color);
		widget.modify_base (Gtk.StateType.NORMAL, color);
		widget.modify_base (Gtk.StateType.SELECTED, color);
		widget.modify_base (Gtk.StateType.ACTIVE, color);
		*/
	}
	
	public void change_foreground_color(Widget widget, string col)
	{
		Gdk.Color color;
		Gdk.Color.parse(col, out color);
		widget.modify_fg (Gtk.StateType.NORMAL, color);
		widget.modify_fg (Gtk.StateType.SELECTED, color);
		widget.modify_fg (Gtk.StateType.ACTIVE, color);
	}
	
	public void alert(string str){
	  	Hildon.Banner.show_information(window, "knots2", str);
	}
	
	public void puts(string message)
	{
		print("%s\n", message);
	}

	public void clean_up()
	{
		if (get_player().is_playing())
		{
			get_player().on_stop();
			get_player().stop();
		}
		get_settings().set_value("sort", get_browser().sort_settings()); 
		Gtk.main_quit();
	}
	
	public bool key_event(Gtk.Widget w, Gdk.EventKey ev)
	{
		if (!get_player().is_playing())
		{
			switch (ev.keyval) {
				case Gdk.KeySyms.F4:
					break;
				case Gdk.KeySyms.F6:
					toggle_fullscreen();
					break;
				case Gdk.KeySyms.F7:
					change_volume(true);
					break;
				case Gdk.KeySyms.F8:
					change_volume(false);
					break;
				case Gdk.KeySyms.Return:
					break;
				case Gdk.KeySyms.Escape:
					break;
				case Gdk.KeySyms.Up:
					((PageWidget)get_notebook().get_nth_page(get_notebook().get_current_page())).scroll_up();
					break;
				case Gdk.KeySyms.Down:
					((PageWidget)get_notebook().get_nth_page(get_notebook().get_current_page())).scroll_down();
					break;
			}
		}
		else
		{
			return get_player().key_event(ev);
		}
		return false;
	}
}

