using GLib;
using Gtk;
using Hildon;
using Gdk;

public class Info : PageWidget
{
	Gtk.Image image;
	Label plot;
	Gtk.ToolButton clear_position_button;
	int id;
	private Item item;
	
	public override void add_signals()
	{
		get_toolbar_button(0).clicked += () => {
			this.hide_info();
		};
		get_toolbar_button(1).clicked += () => {
			this.get_knots().get_player().play(this.id, this.get_knots().get_player().ITEM);
		};
		get_toolbar_button(2).clicked += () => {
			this.get_knots().get_player().play(this.id, this.get_knots().get_player().ARTIST);
		};
		get_toolbar_button(3).clicked += () => {
			this.get_knots().get_player().play(this.id, this.get_knots().get_player().ALBUM);
		};
		get_toolbar_button(4).clicked += () => {
			this.get_knots().get_playlist().add_to_playlist(this.id);
			if (get_knots().get_playlist().playlist_contains_item(this.id))
			{
				get_toolbar_button(4).hide();
				get_toolbar_button(5).show();
			}
		};
		get_toolbar_button(5).clicked += () => {
			
			if (item.get_item_attribute("pid") == null)
				this.get_knots().get_playlist().remove_item_from_playlist(this.id);
			else
				this.get_knots().get_playlist().remove_from_playlist(((string)item.get_item_attribute("pid")).to_int());
			
			if (item.get_item_attribute("pid") != null || !get_knots().get_playlist().playlist_contains_item(this.id))
			{
				get_toolbar_button(4).show();
				get_toolbar_button(5).hide();
				if (item.get_item_attribute("pid") != null)
					hide_info();
			}
		};
	}
	
	public override Gtk.Widget create_content()
	{
		clear_position_button = new Gtk.ToolButton(new Gtk.Image.from_file("/usr/share/knots/knots_button_clear_position.png"), "");
		clear_position_button.clicked += () => {
			clear_position();
		};
		image = new Gtk.Image();
		plot = new Gtk.Label("Plot");
		plot.set_line_wrap(true);
		get_knots().change_foreground_color(plot, "#fff");
		Gtk.Fixed f = new Gtk.Fixed();
		f.put(image, 10, 10);
		f.put(clear_position_button, 300, 80);
		f.put(plot, 10, 190);
		Scroller scroller = new Scroller(f);
		scroller.set_scroll_policy(false, true);
		return scroller;
	}
	
	public override string[] get_toolbar_items()
	{
		return {"back", "play", "play_artist", "play_album", "add_to_playlist", "remove_from_playlist"};
	}
	
	public void show_info(Item? item)
	{
		if (item != null)
		{
			this.item = item;
			get_knots().get_info().reveal();
		}
		this.id = this.item.get_item_id();
		if (get_knots().get_playlist().playlist_contains_item(id))
		{
			get_toolbar_button(4).hide();
			get_toolbar_button(5).show();
		}
		else
		{
			get_toolbar_button(4).show();
			get_toolbar_button(5).hide();
			get_toolbar_button(4).set_sensitive(get_knots().get_playlist().can_add_to_playlist(this.item.get_item_attribute("mediatype").to_int()));
			
		}
		if (this.item.get_item_attribute("mediatype").to_int() != 1)
		{
			get_toolbar_button(2).set_sensitive(false);
			get_toolbar_button(3).set_sensitive(false);
		}
		else
		{
			get_toolbar_button(2).set_sensitive(true);
			get_toolbar_button(3).set_sensitive(true);
		}
		image.set_from_pixbuf(this.item.get_image().get_pixbuf());
		update_info();
	}
	
	public int item_id()
	{
		return this.id;
	}
	
	public void update_info()
	{
		if (this.item != null)
		{
			item.load_image();
			image.set_from_pixbuf(item.get_image().get_pixbuf());
		}
		plot.set_label("");
		get_knots().get_connection().set_url_cache(false);
		string info = get_knots().get_connection().fetch("/external/info?id=" + this.id.to_string());
		if(info != null && info.str("Resume position") != null)
			clear_position_button.show();
		else
			clear_position_button.hide();
		plot.set_markup(info);
		((Scroller)get_content()).scroll_to_top();
	}
	
	public void clear_position()
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch("/external/clear_position?id=" + this.id.to_string());
		update_info();
	}
	
	public string humanize_duration(int duration)
	{
		return timefy(duration / 60 / 60 % 60) + ":" + timefy(duration / 60 % 60) + ":" + timefy(duration % 60);
	}
	
	public string timefy(int val)
	{
		if (val < 10)
			return "0" + val.to_string();
		else
			return val.to_string();
	}
	
	public void hide_info()
	{
		if (item.get_item_attribute("pid") == null)
			this.get_knots().get_browser().reveal();
		else
			this.get_knots().get_playlist().reveal();
	}
}
