/*
  Knips - A simple Camera program.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Configuration.h"

#include <iostream>

#include <Lum/Base/Path.h>
#include <Lum/Base/String.h>

#include <Lum/Config/Config.h>

#include <Lum/Manager/FileSystem.h>

Lum::Model::StringRef imageDirectory(new Lum::Model::String());
Lum::Model::StringRef imagePrefix(new Lum::Model::String());

bool LoadConfig()
{
  Lum::Config::Node      *top,*node;
  Lum::Config::ErrorList errors;
  std::wstring           dir;
  Lum::Base::Path        tmp;
  Lum::Base::Path        path(Lum::Base::Path::GetApplicationConfigPath());

  //Some default initialisation of configuration varaiables

  if (!Lum::Manager::FileSystem::Instance()->GetEntry(Lum::Manager::FileSystem::userPictureDir,
                                                      dir)) {
    Lum::Manager::FileSystem::Instance()->GetEntry(Lum::Manager::FileSystem::userDir,
                                                   dir);
  }

  imageDirectory->Set(dir);

  imagePrefix->Set(L"");

  top=Lum::Config::LoadConfigFromXMLFile(path.GetPath(),errors);

  if (top==NULL) {
    return false;
  }

  if (top->GetName()!=L"Knips") {
    std::cerr << "'" << Lum::Base::WStringToString(path.GetPath()) << "' is a valid config file!" << std::endl;
    delete top;
    return false;
  }

  node=top->GetAttribute(L"imageDirectory");
  if (node!=NULL) {
    imageDirectory->Set(node->GetValue());
  }

  node=top->GetAttribute(L"imagePrefix");
  if (node!=NULL) {
    imagePrefix->Set(node->GetValue());
  }

  delete top;

  return true;
}

bool SaveConfig()
{
  Lum::Config::Node *top;
  Lum::Base::Path   path(Lum::Base::Path::GetApplicationConfigPath());
  bool              res;

  top=new Lum::Config::Node();
  top->SetName(L"Knips");
  top->SetAttribute(L"imageDirectory",imageDirectory->Get());
  top->SetAttribute(L"imagePrefix",imagePrefix->Get());

  Lum::Base::Status status;

  status=path.CreateDirRecursive();

  if (!status) {
    std::cerr << "Cannot create config directory '" << Lum::Base::WStringToString(path.GetDir()) << "': " << Lum::Base::WStringToString(status.GetDescription()) << std::endl;
    return false;
  }

  res=Lum::Config::SaveConfigToXMLFile(path.GetPath(),top);

  delete top;

  return res;
}
