#include "test.h"

int main() {
    {
        TEST_INFO (Test string assignement shares string);
        String s ("foo");
        String t = s;
        TEST_VERIFY (t == "foo" );
        TEST_VERIFY ((const char *)s == (const char *)t );
    }
    {
        TEST_INFO (Test String::append);
        String s ("foo");
        s.append (" bar", 4);
        TEST_VERIFY (s == "foo bar" );
        s.append ("some dummy text", 0);
        TEST_VERIFY (s == "foo bar" );
    }
    {
        TEST_INFO (Test comparison);
        String s1 ("foo");
        String s2 ("bar");
        String s3 ("foo");
        TEST_VERIFY (s1 == s3);
        TEST_VERIFY (s1 == s1);
        TEST_VERIFY (s2 < s3);
    }
    {
        TEST_INFO (Test String::stripWhiteSpace);
        TEST_VERIFY (String ("").isEmpty () );
        TEST_VERIFY (String ("   foo   bar  ").stripWhiteSpace () == "foo   bar" );
        TEST_VERIFY (String ("foo   bar").stripWhiteSpace () == "foo   bar" );
        TEST_VERIFY (String ("f     ").stripWhiteSpace () == "f" );
        TEST_VERIFY (String (" f    ").stripWhiteSpace () == "f" );
        TEST_VERIFY (String ("     r").stripWhiteSpace () == "r" );
        TEST_VERIFY (String ("    r ").stripWhiteSpace () == "r" );
        TEST_VERIFY (String ("   f   r  ").stripWhiteSpace () == "f   r" );
    }
    {
        TEST_INFO (Test TextStream on 'foo');
        String foo ("foo");
        TextStream out (&foo);
        TEST_VERIFY (out.at ());
        if (out.at ())
            TEST_VERIFY (!strcmp (out.at (), "foo"));
        TEST_VERIFY (!out.atEnd ());
        Char c;
        out >> c;
        TEST_VERIFY (c == Char ('f'));
        TEST_VERIFY (out.at ());
        if (out.at ())
            TEST_VERIFY (!strcmp (out.at (), "oo"));
        out >> c;
        TEST_VERIFY (c == Char ('o'));
        if (out.at ())
            TEST_VERIFY (!strcmp (out.at (), "o"));
        out >> c;
        TEST_VERIFY (c == Char ('o'));
        TEST_VERIFY (out.atEnd ());
        if (out.at ())
            TEST_VERIFY (!*out.at ());
    }
    {
        TEST_INFO (Test TextStream on '');
        String foo ("");
        TextStream out (&foo);
        TEST_VERIFY (out.atEnd ());
        TEST_VERIFY (out.at ());
        if (out.at ())
            TEST_VERIFY (!*out.at ());
    }
    {
        TEST_INFO (Test TextStream on String());
        String foo;
        TextStream out (&foo);
        TEST_VERIFY (out.atEnd ());
        TEST_VERIFY (out.at ());
        if (out.at ())
            TEST_VERIFY (!*out.at ());
    }
    {
        TEST_INFO (Test TextStream on writing 'foo');
        TextStream out;
        out << "foo";
        TEST_VERIFY (out.release() == "foo");
    }
    {
        TEST_INFO (Test TextStream on writing noting);
        TextStream out;
        TEST_VERIFY (out.release().isEmpty());
    }
    return 0;
}
