#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
Filename: kfzcheck.py
Version: 1.1
last change: 2010-03-07
Function: KFZcheck is a small program written in python and uses the gtk toolkit. 
It searches for car (in german kfz) license plates shortcuts and the citys according to the 
searchword - german example: S for Stuttgart. 

You can change the csv file on line 69 in this script

Copyright (C) 2010 Patrick Beck <pbeck at yourse dot de>  

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''



import pygtk
import gtk
import hildon
import gobject
import sys
import csv
import re
import os
import portrait # auto rotate - thanks to thp
import gettext

APP = 'kfzcheck' # get i18n support - english and german
DIR = '/opt/kfzcheck/locale'

gettext.bindtextdomain(APP, DIR)
gettext.textdomain(APP)
_ = gettext.gettext

from optparse import OptionParser

class Kfzcheck(object):
    parser = OptionParser()
    parser.add_option("-s", "--search", dest="searchparameter")
    (optionen, args) = parser.parse_args()
    searchparameter = optionen.searchparameter

    imagelist = []
    for i in os.walk('./wappen'): # search all emblems in the wappen dir
        for i in i[2]:
            imagelist.append(i.replace('.png', ''))

    bl_image = {}
    for bl in imagelist: # generate the pixbufs to display faster a result
        text = '/home/user/MyDocs/development/kfzcheck/src/opt/kfzcheck/wappen/%s.png' % (bl)
        image = gtk.gdk.pixbuf_new_from_file_at_size(text, 60, 60)#.scale_simple(60, 60, gtk.gdk.INTERP_HYPER)            
        bl_image[bl] = image

    def load(self):
        csvfile = '/opt/kfzcheck/kfzliste.csv' # add here your file path 
        try: # check if the file is readable
            file = csv.reader(open(csvfile), delimiter=',') # parse the csv file
            return file 
        except:
            if self.selector.get_current_text() == None: # Do not add the sentence twice or more
                self.selector.append_text(_('csv file not found or has not enough rights.'))
                return None
    
    def searchdata(self, row0, row1, store_items, row2=None): # add the Bundesland (state in germany) and a emblem
        new_item = store_items.append()
        if row2 != None:
            output3 = '%s, %s \n%s' % (row0, row1, row2)
            store_items.set(new_item, 0, self.bl_image[row2], 1, output3)
        else:
            output2 = '%s, %s' % (row0, row1)
            store_items.set(new_item, 0, None, 1, output2)
        return store_items
                
    def search(self, widget=None, entry=None):
        self.deletecolumn() # delete the whole column before you add new items
            
        try:
            searchword = unicode(entry.get_text(), 'utf-8')
        except:
            searchword = unicode(entry, 'utf-8')
        searchtext = searchword.replace(' ', '')  # ignore any spaces (replace it with nothing)
        file = self.load() # load the csv file
        store_items = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING)

        if file is not None: # see the load function
            for row in file:
                row[0] = unicode(row[0], 'utf-8') # unicode for äöü
                row[1] = unicode(row[1], 'utf-8')
                
                if searchtext.upper() in row: # search for the shortcut (not casesensitive)
                    store_items.clear() 
                    try:
                        self.searchdata(row[0], row[1], store_items, row[2])
                    except IndexError:
                        self.searchdata(row[0], row[1], store_items)
                        
                    break # when the shortcut matches exactly => break the loop
                else:
                    if re.match(searchtext, row[1], re.IGNORECASE) != None: # search for the city (not casesensitive)
                        try:
                            self.searchdata(row[0], row[1], store_items, row[2])
                        except IndexError:
                            self.searchdata(row[0], row[1], store_items)
            
            try: # display a message when no results are found
                store_items[0]
            except IndexError:    
                new_item = store_items.append()
                nomatch = _('No matches found')
                store_items.set(new_item, 0, None, 1, nomatch)
            
            renderer = gtk.CellRendererPixbuf() 
            renderer.set_property('xalign', 0.1) # set it to center
            self.column = self.selector.append_column(store_items, renderer) #i have to call a renderer, not None
           
            self.column.pack_start(renderer, 0)
            self.column.set_attributes(renderer, pixbuf=0)
        
            renderer = gtk.CellRendererText()
            renderer.set_property('xalign', 0) # set it to center
            renderer.set_property('size-points', 14) # set the size manually
            self.column.pack_start(renderer, 1)
            self.column.set_attributes(renderer, text=1)

            self.column.set_property("text-column", 0) 
            return self.selector

    def about(self, widget):
        about = gtk.AboutDialog()
        about.set_program_name("KFZcheck")
        about.set_version("1.0")
        about.set_copyright("(c) Patrick Beck")
        about.set_comments(_("KFZcheck searches for kfz license plates shortcuts and citys - german example: S for Stuttgart. It has a german list with car shortcuts and the according citys included.")) 
        about.set_website("http://wiki.yourse.de/doku.php?id=python:kfzcheck")
        about.set_logo(gtk.gdk.pixbuf_new_from_file("/usr/share/pixmaps/kfzcheck.png"))
        about.run()
        about.destroy()

    def deletecolumn(self): # create a empty list and set it to the current
        self.selector.remove_column(0)

    def delete_event(self, widget, event, data=None):
        return False
        
    def destroy(self, widget, data=None):
        gtk.main_quit()
 
    def __init__(self):
        self.program = hildon.Program.get_instance()
        self.window = hildon.Window()
        self.program.add_window(self.window)
        
        self.window.set_title(_('KFZcheck'))
        self.window.connect('delete_event', self.delete_event)
        self.window.connect('destroy', self.destroy)
       
        self.selector = hildon.TouchSelector()
        self.selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE) # you can only select one item

        self.box = gtk.VBox(False,2)
        self.window.add(self.box)
        self.hbox = gtk.HBox(False,2)
        self.box.pack_end(self.hbox, False, False, 0)

        self.box.pack_start(self.selector, True, True, 0)       
        self.entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.entry.set_max_length(0)
        
        self.entry.connect('changed', self.search, self.entry)
        self.entry.set_placeholder(_('license plate or cityname...'))

        self.menu = hildon.AppMenu() 
        self.button_showall = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)

        self.button_about = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.button_about.set_label(_('About'))
        self.button_about.connect('clicked', self.about)
        self.menu.append(self.button_about)
        self.hbox.pack_start(self.entry, True, True, 2)

        self.menu.show_all()
        self.window.set_app_menu(self.menu)
        self.window.show_all()
        
        if self.searchparameter != None: # when kfzcheck would be start with the -s parameter on the commandline
            self.entry.set_text(self.searchparameter)
            self.entry.set_position(-1)
            self.search(entry = self.searchparameter)
        else:
            self.search(entry = '')    

        main_window = self.window   # auto rotate function by thp
        app_name = 'kfzcheck'
        app_version = '1.0'
        initial_mode = portrait.FremantleRotation.AUTOMATIC
        rotation_object = portrait.FremantleRotation(app_name, main_window, app_version, initial_mode)

def main():
    gtk.main()
    return 0
    
if __name__ == '__main__':
    Kfzcheck()
    main()

