#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
Filename: kfzcheck.py
Version: 1.0
last change: 2010-02-11
Function: KFZcheck is a small program written in python and uses the gtk toolkit. 
It searches for kfz license plates shortcuts and the citys according to the 
searchword - german example: S for Stuttgart. 

You can change the csv file on line 56 in this script

Copyright (C) 2010 Patrick Beck <pbeck at yourse dot de>  

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import pygtk
pygtk.require('2.0')
import gtk
import hildon
import gobject
import sys
import csv
import re
import portrait # auto rotate - thanks to thp
import gettext

APP = 'kfzcheck' # get i18n support - english and german
DIR = '/usr/share/locale'

gettext.bindtextdomain(APP, DIR)
gettext.textdomain(APP)
_ = gettext.gettext

from optparse import OptionParser

class Kfzcheck(object):
    parser = OptionParser()
    parser.add_option("-s", "--search", dest="searchparameter")
    (optionen, args) = parser.parse_args()
    searchparameter = optionen.searchparameter

    def load(self):
        csvfile = '/opt/kfzcheck/kfzliste.csv' # add here your file path 
        try: # check if the file is readable
            file = csv.reader(open(csvfile), delimiter=',') # parse the csv file
            return file 
        except:
            if self.selector.get_current_text() == None: # Do not add the sentence twice or more
                self.selector.append_text(_('csv file not found or has not enough rights.'))
                return None
                    
    def search(self, widget=None, entry=None):

        self.emptyselector() # delete the whole column before you add new items
            
        try:
            searchword = unicode(entry.get_text(), 'utf-8')
        except:
            searchword = entry
        searchtext = searchword.replace(' ', '')  # ignore any spaces (replace it with nothing)
        file = self.load() # load the csv file
        
#        icon_list = ['Bay']
#        store_icons = gtk.ListStore(gobject.TYPE_STRING)
#        for item in icon_list:
#            new_iter = store_icons.append()
#            store_icons.set(new_iter, 0, item)
#        renderer = gtk.CellRendererPixbuf()
#        renderer.set_fixed_size(-1, 100)
#        column = self.selector.append_column(store_icons, renderer, stock_id = 0)
#        column.set_property("text-column", 0)

        if file is not None: # see the load function
            for row in file:
                row[0] = unicode(row[0], 'utf-8') # unicode for äöü
                row[1] = unicode(row[1], 'utf-8')
                if searchtext.upper() in row: # search for the shortcut (not casesensitive)
                    self.emptyselector() # display only the exactly license plate (display only S for Stuttgart when its in the searchword)
                    self.selector.append_text(row[0] + ',' + ' ' + row[1])
                    break # when the shortcut matches exactly => break the loop
                else:
                    if re.match(searchtext, row[1], re.IGNORECASE) != None: # search for the shortcut (not casesensitive)
                        self.selector.append_text(row[0] + ',' + ' ' + row[1])
    



        # no matches found add!!!!!!!!!!
    
    
    
    def show(self, widget):
        file = self.load()
        self.emptyselector() # display only the exactly license plate (display only S for Stuttgart when its in the searchword)
        if file is not None:
            for row in file:
                self.selector.append_text(row[0] + ',' +  ' ' + row[1]) # show all shortcuts and names 
    
    def about(self, widget):
        about = gtk.AboutDialog()
        about.set_program_name("KFZcheck")
        about.set_version("1.0")
        about.set_copyright("(c) Patrick Beck")
        about.set_comments(_("KFZcheck searches for kfz license plates shortcuts and citys - german example: S for Stuttgart. It has a german list with car shortcuts and the according citys included.")) 
        about.set_website("http://wiki.yourse.de/doku.php?id=python:kfzcheck")
        about.set_logo(gtk.gdk.pixbuf_new_from_file("kfzcheck.png"))
        about.run()
        about.destroy()

    def emptyselector(self): # create a empty list and set it to the current
        empty_list = gtk.ListStore(gobject.TYPE_STRING)
        self.selector.set_model(0, empty_list)
   

    def delete_event(self, widget, event, data=None):
        return False
        
    def destroy(self, widget, data=None):
        gtk.main_quit()
 
    def __init__(self):
        self.program = hildon.Program.get_instance()
        self.window = hildon.Window()
        self.program.add_window(self.window)
        
        self.window.set_title(_('KFZcheck'))
        self.window.connect('delete_event', self.delete_event)
        self.window.connect('destroy', self.destroy)
       
        self.selector = hildon.TouchSelector(text = True)
        self.selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE) # you can only select one item
        self.selector.append_text(_('license plate or cityname...'))   

        self.box = gtk.VBox(False,2)
        self.window.add(self.box)
        self.hbox = gtk.HBox(False,2)
        self.box.pack_end(self.hbox, False, False, 0)

        self.box.pack_start(self.selector, True, True, 0)       
        self.entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.entry.set_max_length(0)

        if self.searchparameter != None:
            self.search(entry = self.searchparameter)
        
        self.entry.connect('activate', self.search, self.entry)
        self.entry.set_placeholder(_('license plate or cityname...'))

        self.button_search = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, _('Search'))
        self.button_search.connect('clicked', self.search, self.entry)

        self.menu = hildon.AppMenu() 
        self.button_showall = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.button_showall.set_label(_('Show all'))
        self.button_showall.connect('clicked', self.show)
        self.menu.append(self.button_showall)

        self.button_about = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.button_about.set_label(_('About'))
        self.button_about.connect('clicked', self.about)
        self.menu.append(self.button_about)
        self.hbox.pack_start(self.entry, True, True, 2)
        self.hbox.pack_start(self.button_search, False, False, 2)

        self.menu.show_all()
        self.window.set_app_menu(self.menu)
        self.window.show_all()
        

        main_window = self.window   # auto rotate function by thp
        app_name = 'kfzcheck'
        app_version = '1.0'
        initial_mode = portrait.FremantleRotation.AUTOMATIC
        rotation_object = portrait.FremantleRotation(app_name, main_window, app_version, initial_mode)

def main():
    gtk.main()
    return 0
    
if __name__ == '__main__':
    Kfzcheck()
    main()

